/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.internal.core.index;

import com.metamatrix.core.index.IDocument;
import com.metamatrix.core.index.IEntryResult;
import com.metamatrix.core.index.IIndex;
import com.metamatrix.core.index.IIndexer;
import com.metamatrix.core.index.IQueryResult;
import com.metamatrix.internal.core.index.BlocksIndexInput;
import com.metamatrix.internal.core.index.BlocksIndexOutput;
import com.metamatrix.internal.core.index.InMemoryIndex;
import com.metamatrix.internal.core.index.IndexInput;
import com.metamatrix.internal.core.index.IndexedFile;
import com.metamatrix.internal.core.index.IndexerOutput;
import com.metamatrix.internal.core.index.Int;
import com.metamatrix.internal.core.index.MergeFactory;
import com.metamatrix.internal.core.index.SimpleIndexInput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class Index
implements IIndex {
    public static final int MAX_FOOTPRINT = 10000000;
    protected InMemoryIndex addsIndex;
    protected IndexInput addsIndexInput;
    protected int state = 1;
    protected Map removedInAdds;
    protected Map removedInOld;
    protected static final int CAN_MERGE = 0;
    protected static final int MERGED = 1;
    private File indexFile;
    public String toString;

    public Index(File indexDirectory, boolean reuseExistingFile) throws IOException {
        this(indexDirectory, ".index", reuseExistingFile);
    }

    public Index(File indexDirectory, String indexName, boolean reuseExistingFile) throws IOException {
        this.indexFile = new File(indexDirectory, indexName);
        this.initialize(reuseExistingFile);
    }

    public Index(String indexName, boolean reuseExistingFile) throws IOException {
        this(indexName, null, reuseExistingFile);
    }

    public Index(String indexName, String toString, boolean reuseExistingFile) throws IOException {
        this.indexFile = new File(indexName);
        this.toString = toString;
        this.initialize(reuseExistingFile);
    }

    public void add(IDocument document, IIndexer indexer) throws IOException {
        IndexedFile indexedFile;
        if (this.timeToMerge()) {
            this.merge();
        }
        if ((indexedFile = this.addsIndex.getIndexedFile(document.getName())) != null) {
            this.remove(indexedFile, 0);
        }
        IndexerOutput output = new IndexerOutput(this.addsIndex);
        indexer.index(document, output);
        this.state = 0;
    }

    protected boolean canMerge() {
        return this.state == 0;
    }

    public void empty() throws IOException {
        if (this.indexFile.exists()) {
            this.indexFile.delete();
            InMemoryIndex mainIndex = new InMemoryIndex();
            BlocksIndexOutput mainIndexOutput = new BlocksIndexOutput(this.indexFile);
            if (!this.indexFile.exists()) {
                mainIndex.save(mainIndexOutput);
            }
        }
        this.addsIndex = new InMemoryIndex();
        this.addsIndexInput = new SimpleIndexInput(this.addsIndex);
        this.removedInAdds = new HashMap(11);
        this.removedInOld = new HashMap(11);
    }

    public File getIndexFile() {
        return this.indexFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumDocuments() throws IOException {
        BlocksIndexInput input = new BlocksIndexInput(this.indexFile);
        try {
            ((IndexInput)input).open();
            int n2 = ((IndexInput)input).getNumFiles();
            return n2;
        }
        finally {
            ((IndexInput)input).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumWords() throws IOException {
        BlocksIndexInput input = new BlocksIndexInput(this.indexFile);
        try {
            ((IndexInput)input).open();
            int n2 = ((IndexInput)input).getNumWords();
            return n2;
        }
        finally {
            ((IndexInput)input).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPath(int documentNumber) throws IOException {
        BlocksIndexInput input = new BlocksIndexInput(this.indexFile);
        try {
            ((IndexInput)input).open();
            IndexedFile file = ((IndexInput)input).getIndexedFile(documentNumber);
            if (file == null) {
                String string = null;
                return string;
            }
            String string = file.getPath();
            return string;
        }
        finally {
            ((IndexInput)input).close();
        }
    }

    public boolean hasChanged() {
        return this.canMerge();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(boolean reuseExistingFile) throws IOException {
        this.addsIndex = new InMemoryIndex();
        this.addsIndexInput = new SimpleIndexInput(this.addsIndex);
        this.removedInAdds = new HashMap(11);
        this.removedInOld = new HashMap(11);
        if (reuseExistingFile && this.indexFile.exists() && this.indexFile.length() > 0L) {
            BlocksIndexInput mainIndexInput = new BlocksIndexInput(this.indexFile);
            try {
                ((IndexInput)mainIndexInput).open();
            }
            catch (IOException e2) {
                BlocksIndexInput input = mainIndexInput;
                try {
                    input.opened = true;
                    input.close();
                }
                finally {
                    input.opened = false;
                }
                this.indexFile.delete();
                mainIndexInput = null;
                throw e2;
            }
            ((IndexInput)mainIndexInput).close();
        } else {
            InMemoryIndex mainIndex = new InMemoryIndex();
            BlocksIndexOutput mainIndexOutput = new BlocksIndexOutput(this.indexFile);
            mainIndex.save(mainIndexOutput);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void merge() throws IOException {
        File tempFile = new File(this.indexFile.getAbsolutePath() + "TempVA");
        BlocksIndexInput mainIndexInput = new BlocksIndexInput(this.indexFile);
        BlocksIndexOutput tempIndexOutput = new BlocksIndexOutput(tempFile);
        try {
            new MergeFactory(mainIndexInput, this.addsIndexInput, tempIndexOutput, this.removedInOld, this.removedInAdds).merge();
            File mainIndexFile = (File)((IndexInput)mainIndexInput).getSource();
            File tempIndexFile = (File)tempIndexOutput.getDestination();
            mainIndexFile.delete();
            tempIndexFile.renameTo(mainIndexFile);
            Object var7_6 = null;
            this.removedInAdds.clear();
            this.removedInOld.clear();
            this.addsIndex.init();
            this.addsIndexInput = new SimpleIndexInput(this.addsIndex);
            this.state = 1;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.removedInAdds.clear();
            this.removedInOld.clear();
            this.addsIndex.init();
            this.addsIndexInput = new SimpleIndexInput(this.addsIndex);
            this.state = 1;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IQueryResult[] query(String word) throws IOException {
        BlocksIndexInput input = new BlocksIndexInput(this.indexFile);
        try {
            IQueryResult[] iQueryResultArray = ((IndexInput)input).query(word);
            return iQueryResultArray;
        }
        finally {
            ((IndexInput)input).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IEntryResult[] queryEntries(char[] prefix) throws IOException {
        BlocksIndexInput input = new BlocksIndexInput(this.indexFile);
        try {
            IEntryResult[] iEntryResultArray = ((IndexInput)input).queryEntriesPrefixedBy(prefix);
            return iEntryResultArray;
        }
        finally {
            ((IndexInput)input).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IQueryResult[] queryInDocumentNames(String word) throws IOException {
        BlocksIndexInput input = new BlocksIndexInput(this.indexFile);
        try {
            IQueryResult[] iQueryResultArray = ((IndexInput)input).queryInDocumentNames(word);
            return iQueryResultArray;
        }
        finally {
            ((IndexInput)input).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IQueryResult[] queryPrefix(char[] prefix) throws IOException {
        BlocksIndexInput input = new BlocksIndexInput(this.indexFile);
        try {
            IQueryResult[] iQueryResultArray = ((IndexInput)input).queryFilesReferringToPrefix(prefix);
            return iQueryResultArray;
        }
        finally {
            ((IndexInput)input).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IEntryResult[] queryEntriesMatching(char[] prefix, boolean isCaseSensitive) throws IOException {
        BlocksIndexInput input = new BlocksIndexInput(this.indexFile);
        try {
            IEntryResult[] iEntryResultArray = input.queryEntriesMatching(prefix, isCaseSensitive);
            return iEntryResultArray;
        }
        finally {
            input.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IEntryResult[] queryEntriesMatching(Collection patterns, boolean isCaseSensitive) throws IOException {
        BlocksIndexInput input = new BlocksIndexInput(this.indexFile);
        try {
            IEntryResult[] iEntryResultArray = input.queryEntriesMatching(patterns, isCaseSensitive);
            return iEntryResultArray;
        }
        finally {
            input.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IEntryResult[] queryEntries(char[] prefix, boolean isCaseSensitive) throws IOException {
        BlocksIndexInput input = new BlocksIndexInput(this.indexFile);
        try {
            IEntryResult[] iEntryResultArray = input.queryEntriesPrefixedBy(prefix, isCaseSensitive);
            return iEntryResultArray;
        }
        finally {
            input.close();
        }
    }

    public void remove(String documentName) throws IOException {
        IndexedFile file = this.addsIndex.getIndexedFile(documentName);
        if (file != null) {
            Int lastRemoved = (Int)this.removedInAdds.get(documentName);
            if (lastRemoved != null) {
                int fileNum = file.getFileNumber();
                if (lastRemoved.value < fileNum) {
                    lastRemoved.value = fileNum;
                }
            } else {
                this.removedInAdds.put(documentName, new Int(file.getFileNumber()));
            }
        } else {
            this.removedInOld.put(documentName, new Int(1));
        }
        this.state = 0;
    }

    protected void remove(IndexedFile file, int index) throws IOException {
        String name = file.getPath();
        if (index == 0) {
            Int lastRemoved = (Int)this.removedInAdds.get(name);
            if (lastRemoved != null) {
                if (lastRemoved.value < file.getFileNumber()) {
                    lastRemoved.value = file.getFileNumber();
                }
            } else {
                this.removedInAdds.put(name, new Int(file.getFileNumber()));
            }
        } else if (index == 1) {
            this.removedInOld.put(name, new Int(1));
        } else {
            throw new Error();
        }
        this.state = 0;
    }

    public void save() throws IOException {
        if (this.canMerge()) {
            this.merge();
        }
    }

    protected boolean timeToMerge() {
        return this.addsIndex.getFootprint() >= 10000000L;
    }

    public String toString() {
        String str = this.toString;
        if (str == null) {
            str = super.toString();
        }
        str = str + "(length: " + this.getIndexFile().length() + ")";
        return str;
    }
}

