/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.internal.core.index;

public final class HashtableOfInt {
    public int[] keyTable;
    public Object[] valueTable;
    public int elementSize = 0;
    int threshold;

    public HashtableOfInt() {
        this(13);
    }

    public HashtableOfInt(int size) {
        this.threshold = size;
        int extraRoom = (int)((float)size * 1.75f);
        if (this.threshold == extraRoom) {
            ++extraRoom;
        }
        this.keyTable = new int[extraRoom];
        this.valueTable = new Object[extraRoom];
    }

    public boolean containsKey(int key) {
        int currentKey;
        int index = key % this.valueTable.length;
        while ((currentKey = this.keyTable[index]) != 0) {
            if (currentKey == key) {
                return true;
            }
            index = (index + 1) % this.keyTable.length;
        }
        return false;
    }

    public Object get(int key) {
        int currentKey;
        int index = key % this.valueTable.length;
        while ((currentKey = this.keyTable[index]) != 0) {
            if (currentKey == key) {
                return this.valueTable[index];
            }
            index = (index + 1) % this.keyTable.length;
        }
        return null;
    }

    public Object put(int key, Object value) {
        int currentKey;
        int index = key % this.valueTable.length;
        while ((currentKey = this.keyTable[index]) != 0) {
            if (currentKey == key) {
                this.valueTable[index] = value;
                return this.valueTable[index];
            }
            index = (index + 1) % this.keyTable.length;
        }
        this.keyTable[index] = key;
        this.valueTable[index] = value;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return value;
    }

    private void rehash() {
        HashtableOfInt newHashtable = new HashtableOfInt(this.elementSize * 2);
        int i2 = this.keyTable.length;
        while (--i2 >= 0) {
            int currentKey = this.keyTable[i2];
            if (currentKey == 0) continue;
            newHashtable.put(currentKey, this.valueTable[i2]);
        }
        this.keyTable = newHashtable.keyTable;
        this.valueTable = newHashtable.valueTable;
        this.threshold = newHashtable.threshold;
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        String s2 = "";
        int length = this.valueTable.length;
        for (int i2 = 0; i2 < length; ++i2) {
            Object object = this.valueTable[i2];
            if (object == null) continue;
            s2 = s2 + this.keyTable[i2] + " -> " + object.toString() + "\n";
        }
        return s2;
    }
}

