/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.internal.core.index;

import com.metamatrix.core.index.IEntryResult;
import com.metamatrix.core.util.CharOperation;

public class EntryResult
implements IEntryResult {
    private char[] word;
    private int[] fileRefs;

    public EntryResult(char[] word, int[] refs) {
        this.word = word;
        this.fileRefs = refs;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject != null && anObject instanceof EntryResult) {
            EntryResult anEntryResult = (EntryResult)anObject;
            if (!CharOperation.equals(this.word, anEntryResult.word)) {
                return false;
            }
            int[] refs = this.fileRefs;
            int length = this.fileRefs.length;
            int[] otherRefs = anEntryResult.fileRefs;
            if (length != anEntryResult.fileRefs.length) {
                return false;
            }
            for (int i2 = 0; i2 < length; ++i2) {
                if (refs[i2] == otherRefs[i2]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int[] getFileReferences() {
        return this.fileRefs;
    }

    public char[] getWord() {
        return this.word;
    }

    public int hashCode() {
        return CharOperation.hashCode(this.word);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.word.length * 2);
        buffer.append("EntryResult: word=");
        buffer.append(this.word);
        buffer.append(", refs={");
        for (int i2 = 0; i2 < this.fileRefs.length; ++i2) {
            if (i2 > 0) {
                buffer.append(',');
            }
            buffer.append(' ');
            buffer.append(this.fileRefs[i2]);
        }
        buffer.append(" }");
        return buffer.toString();
    }
}

