/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.internal.core.id;

import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.id.UUID;
import java.security.SecureRandom;
import java.util.Calendar;
import java.util.Random;

public class EmbeddedUUIDFactory {
    private static final int UUID_VERSION = 1;
    private static final int UUID_VARIANT = 32768;
    private static final String RNG_ALGORITHM = "SHA1PRNG";
    private static final int N_NODE_BYTES = 6;
    private static final int CLOCK_SEQ_LAST = 16384;
    private static final int MILLI_TO_NANO = 1000000;
    private final Calendar calendar = Calendar.getInstance();
    private Random rng = null;
    private long counter = 0L;
    long nodeComponent;
    int clockSeq;
    long lastTime = 0L;
    private long maxUuidsPerTick;
    private int uuidsThisTick = 0;

    public EmbeddedUUIDFactory() {
        try {
            this.rng = SecureRandom.getInstance(RNG_ALGORITHM);
        }
        catch (Exception everything) {
            System.out.println("Couldn't initialize random number generation algorithm SHA1PRNG");
            this.rng = new Random();
        }
        this.initNodeComponent();
        this.initClockSequence();
        this.lastTime = System.currentTimeMillis();
        long clockResolution = EmbeddedUUIDFactory.getClockResolution();
        this.maxUuidsPerTick = clockResolution * 1000000L / 10L;
    }

    public long getCount() {
        return this.counter;
    }

    public boolean validate(ObjectID id) {
        if (id instanceof UUID) {
            return UUID.validate(id);
        }
        return false;
    }

    public synchronized ObjectID create() {
        long currentTime = this.getSystemTime();
        if (currentTime < this.lastTime) {
            this.adjustClockSequence();
        }
        long timeComponent = this.adjustTimeComponent(currentTime);
        long timeLow = timeComponent & 0xFFFFFFFFL;
        long timeMid = timeComponent >> 32 & 0xFFFFL;
        long timeHigh = timeComponent >> 48 & 0x3FFFL;
        long timeHighAndVersion = timeHigh |= 0x1000L;
        long mostSig = timeLow << 32 | timeMid << 16 | timeHighAndVersion;
        long clockSeqAndReserved = this.clockSeq & 0x3FFF | 0x8000;
        long leastSig = clockSeqAndReserved << 48 | this.nodeComponent;
        ++this.counter;
        return new UUID(mostSig, leastSig);
    }

    private synchronized void initNodeComponent() {
        byte[] randBuf = new byte[6];
        this.rng.nextBytes(randBuf);
        this.nodeComponent = 0L;
        for (int i2 = 0; i2 < 6; ++i2) {
            this.nodeComponent = this.nodeComponent << 8 | (long)(randBuf[i2] & 0xFF);
        }
        this.nodeComponent |= 0x800000000000L;
    }

    private synchronized void initClockSequence() {
        byte[] clockBuf = new byte[2];
        this.rng.nextBytes(clockBuf);
        this.clockSeq = (clockBuf[0] & 0xFF) << 8 | clockBuf[1] & 0x3F;
    }

    private synchronized void adjustClockSequence() {
        this.clockSeq = (this.clockSeq + 1) % 16385;
        if (this.clockSeq == 0) {
            this.clockSeq = 1;
        }
    }

    private synchronized long adjustTimeComponent(long systemTime) {
        while (true) {
            if (systemTime != this.lastTime) {
                this.uuidsThisTick = 0;
                this.lastTime = systemTime;
                break;
            }
            if ((long)this.uuidsThisTick < this.maxUuidsPerTick) {
                ++this.uuidsThisTick;
                break;
            }
            systemTime = System.currentTimeMillis();
        }
        return systemTime * 1000000L + (long)this.uuidsThisTick;
    }

    private long getSystemTime() {
        long time = System.currentTimeMillis();
        int timeZoneOffset = this.calendar.get(15);
        int dstOffset = this.calendar.get(16);
        return time -= (long)(timeZoneOffset + dstOffset);
    }

    private static long getClockResolution() {
        long t1 = System.currentTimeMillis();
        long t2 = System.currentTimeMillis();
        long delta = t2 - t1;
        long resolution = Long.MAX_VALUE;
        t1 = t2;
        int k2 = 0;
        do {
            if ((delta = (t2 = System.currentTimeMillis()) - t1) > 0L & delta < resolution) {
                resolution = delta;
            }
            t1 = t2;
        } while (resolution == Long.MAX_VALUE || ++k2 < 1000);
        return resolution;
    }
}

