/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.service.metadata;

import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.dqp.service.metadata.QueryMetadataCache;
import java.net.URL;

public class SingletonMetadataCacheHolder {
    private static QueryMetadataCache metadataCache;

    private SingletonMetadataCacheHolder() {
    }

    public static synchronized QueryMetadataCache getMetadataCache(URL systemVdbUrl) throws MetaMatrixCoreException {
        if (!SingletonMetadataCacheHolder.hasCache()) {
            metadataCache = new QueryMetadataCache(systemVdbUrl);
        }
        return metadataCache;
    }

    public static synchronized QueryMetadataCache getMetadataCache(byte[] systemVdbContent) throws MetaMatrixCoreException {
        if (!SingletonMetadataCacheHolder.hasCache()) {
            metadataCache = new QueryMetadataCache(systemVdbContent);
        }
        return metadataCache;
    }

    public static QueryMetadataCache getMetadataCache() {
        if (SingletonMetadataCacheHolder.hasCache()) {
            return metadataCache;
        }
        return null;
    }

    public static boolean hasCache() {
        return metadataCache != null && metadataCache.isValid();
    }
}

