/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.service.buffer;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.application.ApplicationEnvironment;
import com.metamatrix.common.application.exception.ApplicationInitializationException;
import com.metamatrix.common.application.exception.ApplicationLifecycleException;
import com.metamatrix.common.buffer.BufferManager;
import com.metamatrix.common.buffer.LocalLookup;
import com.metamatrix.common.buffer.impl.BufferManagerImpl;
import com.metamatrix.common.buffer.storage.file.FileStorageManager;
import com.metamatrix.common.buffer.storage.memory.MemoryStorageManager;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.dqp.DQPPlugin;
import com.metamatrix.dqp.service.BufferService;
import java.rmi.RemoteException;
import java.util.Properties;

public class DQPBufferService
implements BufferService {
    private static final String DEFAULT_MEMORY_AVAILABLE = "9223372036854775807";
    private static final String DEFAULT_MANAGEMENT_INTERVAL = "0";
    private static final String DEFAULT_LOG_STATS_INTERVAL = "0";
    private static final String DEFAULT_SESSION_USE_PERCENTAGE = "100";
    private static final String DEFAULT_ID_CREATOR = "com.metamatrix.common.buffer.impl.LongIDCreator";
    private static final String DEFAULT_BUFFER_DIR = ".";
    private static final String DEFAULT_MAX_OPEN_FILES = "10";
    private BufferManager bufferMgr;

    public void initialize(Properties props) throws ApplicationInitializationException {
        String useDiskStr;
        String memAvail = props.getProperty("dqp.buffer.memory");
        if (memAvail == null || memAvail.length() == 0) {
            memAvail = DEFAULT_MEMORY_AVAILABLE;
        }
        if ((useDiskStr = props.getProperty("dqp.buffer.usedisk")) == null) {
            throw new ApplicationInitializationException(DQPPlugin.Util.getString("DQPBufferService.Error_initializing_buffer_manager__missing_required_property_7", "dqp.buffer.usedisk"));
        }
        boolean useDisk = Boolean.valueOf(useDiskStr);
        String bufferDir = props.getProperty("dqp.buffer.dir");
        if (useDisk && (bufferDir == null || bufferDir.length() == 0)) {
            bufferDir = DEFAULT_BUFFER_DIR;
        }
        if (!useDisk) {
            memAvail = DEFAULT_MEMORY_AVAILABLE;
        }
        try {
            Properties bufferProps = new Properties();
            bufferProps.setProperty("metamatrix.buffer.idCreator", DEFAULT_ID_CREATOR);
            bufferProps.setProperty("metamatrix.buffer.sessionUsePercentage", DEFAULT_SESSION_USE_PERCENTAGE);
            bufferProps.setProperty("metamatrix.buffer.logStatsInterval", "0");
            bufferProps.setProperty("metamatrix.buffer.managementInterval", "0");
            bufferProps.setProperty("metamatrix.buffer.memoryAvailable", memAvail);
            this.bufferMgr = new BufferManagerImpl();
            this.bufferMgr.initialize(new LocalLookup(this.bufferMgr), bufferProps);
            if (useDisk) {
                Properties fsmProps = new Properties();
                fsmProps.setProperty("metamatrix.buffer.storageDirectory", bufferDir);
                fsmProps.setProperty("metamatrix.buffer.maxOpenFiles", DEFAULT_MAX_OPEN_FILES);
                FileStorageManager fsm = new FileStorageManager();
                fsm.initialize(fsmProps);
                this.bufferMgr.addStorageManager(fsm);
            }
            this.bufferMgr.addStorageManager(new MemoryStorageManager());
        }
        catch (MetaMatrixComponentException e2) {
            throw new ApplicationInitializationException((Throwable)e2, DQPPlugin.Util.getString("DQPBufferService.Failed_initializing_buffer_manager._8"));
        }
        catch (RemoteException e3) {
            // empty catch block
        }
    }

    public void start(ApplicationEnvironment environment) throws ApplicationLifecycleException {
    }

    public void bind() throws ApplicationLifecycleException {
    }

    public void unbind() throws ApplicationLifecycleException {
    }

    public void stop() throws ApplicationLifecycleException {
        try {
            this.bufferMgr.stop();
        }
        catch (RemoteException ex) {
            throw new MetaMatrixRuntimeException(ex);
        }
    }

    public BufferManager getBufferManager() {
        return this.bufferMgr;
    }
}

