/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.process.multisource;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.dqp.internal.process.multisource.MultiSourceElement;
import com.metamatrix.query.b.a.c;
import com.metamatrix.query.b.b.b;
import com.metamatrix.query.m.a;
import com.metamatrix.query.m.e;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class MultiSourceMetadataWrapper
implements e {
    private e actualMetadata;
    private Collection multiSourceModels;

    public MultiSourceMetadataWrapper(e actualMetadata, Collection multiSourceModels) {
        this.actualMetadata = actualMetadata;
        this.multiSourceModels = multiSourceModels;
    }

    public Object getElementID(String elementName) throws MetaMatrixComponentException, QueryMetadataException {
        String shortName = this.getShortElementName(elementName);
        if (shortName.equalsIgnoreCase("SOURCE_NAME")) {
            try {
                String groupName = this.getGroupName(elementName);
                Object groupID = this.getGroupID(groupName);
                List elements = this.getElementIDsInGroupID(groupID);
                Iterator iter = elements.iterator();
                while (iter.hasNext()) {
                    Object id = iter.next();
                    if (!(id instanceof MultiSourceElement)) continue;
                    return id;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.actualMetadata.getElementID(elementName);
    }

    public Object getGroupID(String groupName) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getGroupID(groupName);
    }

    public Collection getGroupsForPartialName(String partialGroupName) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getGroupsForPartialName(partialGroupName);
    }

    public Object getModelID(Object groupOrElementID) throws MetaMatrixComponentException, QueryMetadataException {
        if (groupOrElementID instanceof MultiSourceElement) {
            Object groupID = ((MultiSourceElement)groupOrElementID).groupID;
            return this.getModelID(groupID);
        }
        return this.actualMetadata.getModelID(groupOrElementID);
    }

    public String getFullName(Object metadataID) throws MetaMatrixComponentException, QueryMetadataException {
        if (metadataID instanceof MultiSourceElement) {
            return ((MultiSourceElement)metadataID).fullName;
        }
        return this.actualMetadata.getFullName(metadataID);
    }

    public String getFullElementName(String fullGroupName, String shortElementName) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getFullElementName(fullGroupName, shortElementName);
    }

    public String getShortElementName(String fullElementName) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getShortElementName(fullElementName);
    }

    public String getGroupName(String fullElementName) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getGroupName(fullElementName);
    }

    public List getElementIDsInGroupID(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        ArrayList<MultiSourceElement> elements = this.actualMetadata.getElementIDsInGroupID(groupID);
        Object modelID = this.getModelID(groupID);
        String modelName = this.getFullName(modelID);
        if (this.multiSourceModels.contains(modelName)) {
            elements = new ArrayList<MultiSourceElement>(elements);
            String fullName = this.getFullName(groupID) + "." + "SOURCE_NAME";
            boolean elementExists = false;
            for (int i2 = 0; i2 < elements.size(); ++i2) {
                Object elemID = elements.get(i2);
                if (!this.actualMetadata.getFullName(elemID).endsWith(".SOURCE_NAME")) continue;
                elements.set(i2, new MultiSourceElement(groupID, i2 + 1, fullName));
                elementExists = true;
                break;
            }
            if (!elementExists) {
                int position = elements.size() + 1;
                elements.add(new MultiSourceElement(groupID, position, fullName));
            }
        }
        return elements;
    }

    public Object getGroupIDForElementID(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        if (elementID instanceof MultiSourceElement) {
            return ((MultiSourceElement)elementID).groupID;
        }
        return this.actualMetadata.getGroupIDForElementID(elementID);
    }

    public a getStoredProcedureInfoForProcedure(String fullyQualifiedProcedureName) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getStoredProcedureInfoForProcedure(fullyQualifiedProcedureName);
    }

    public String getElementType(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        if (elementID instanceof MultiSourceElement) {
            return "string";
        }
        return this.actualMetadata.getElementType(elementID);
    }

    public Object getDefaultValue(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        if (elementID instanceof MultiSourceElement) {
            return null;
        }
        return this.actualMetadata.getDefaultValue(elementID);
    }

    public Object getMinimumValue(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        if (elementID instanceof MultiSourceElement) {
            return null;
        }
        return this.actualMetadata.getMinimumValue(elementID);
    }

    public Object getMaximumValue(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        if (elementID instanceof MultiSourceElement) {
            return null;
        }
        return this.actualMetadata.getMaximumValue(elementID);
    }

    public int getDistinctValues(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        if (elementID instanceof MultiSourceElement) {
            return ((MultiSourceElement)elementID).position;
        }
        return this.actualMetadata.getDistinctValues(elementID);
    }

    public int getNullValues(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        if (elementID instanceof MultiSourceElement) {
            return ((MultiSourceElement)elementID).position;
        }
        return this.actualMetadata.getNullValues(elementID);
    }

    public int getPosition(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        if (elementID instanceof MultiSourceElement) {
            return ((MultiSourceElement)elementID).position;
        }
        return this.actualMetadata.getPosition(elementID);
    }

    public int getPrecision(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        if (elementID instanceof MultiSourceElement) {
            return 0;
        }
        return this.actualMetadata.getPrecision(elementID);
    }

    public int getScale(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        if (elementID instanceof MultiSourceElement) {
            return 0;
        }
        return this.actualMetadata.getScale(elementID);
    }

    public int getRadix(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        if (elementID instanceof MultiSourceElement) {
            return 0;
        }
        return this.actualMetadata.getRadix(elementID);
    }

    public boolean isVirtualGroup(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.isVirtualGroup(groupID);
    }

    public boolean isVirtualModel(Object modelID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.isVirtualModel(modelID);
    }

    public b getVirtualPlan(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getVirtualPlan(groupID);
    }

    public String getInsertPlan(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getInsertPlan(groupID);
    }

    public String getUpdatePlan(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getUpdatePlan(groupID);
    }

    public String getDeletePlan(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getDeletePlan(groupID);
    }

    public boolean modelSupports(Object modelID, int modelConstant) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.modelSupports(modelID, modelConstant);
    }

    public boolean groupSupports(Object groupID, int groupConstant) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.groupSupports(groupID, groupConstant);
    }

    public boolean elementSupports(Object elementID, int elementConstant) throws MetaMatrixComponentException, QueryMetadataException {
        if (elementID instanceof MultiSourceElement) {
            switch (elementConstant) {
                case 4: {
                    return false;
                }
                case 10: {
                    return false;
                }
                case 2: {
                    return true;
                }
                case 1: {
                    return true;
                }
                case 0: {
                    return true;
                }
                case 5: {
                    return false;
                }
                case 7: {
                    return false;
                }
                case 8: {
                    return false;
                }
                case 9: {
                    return false;
                }
                case 11: {
                    return false;
                }
            }
            throw new UnsupportedOperationException("Attempt to check support for unknown constant: " + elementConstant);
        }
        return this.actualMetadata.elementSupports(elementID, elementConstant);
    }

    public Properties getExtensionProperties(Object metadataID) throws MetaMatrixComponentException, QueryMetadataException {
        if (metadataID instanceof MultiSourceElement) {
            return new Properties();
        }
        return this.actualMetadata.getExtensionProperties(metadataID);
    }

    public int getMaxSetSize(Object modelID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getMaxSetSize(modelID);
    }

    public Collection getIndexesInGroup(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getIndexesInGroup(groupID);
    }

    public Collection getUniqueKeysInGroup(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getUniqueKeysInGroup(groupID);
    }

    public Collection getForeignKeysInGroup(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getForeignKeysInGroup(groupID);
    }

    public Object getPrimaryKeyIDForForeignKeyID(Object foreignKeyID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getPrimaryKeyIDForForeignKeyID(foreignKeyID);
    }

    public Collection getAccessPatternsInGroup(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getAccessPatternsInGroup(groupID);
    }

    public List getElementIDsInIndex(Object index) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getElementIDsInIndex(index);
    }

    public List getElementIDsInKey(Object key) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getElementIDsInKey(key);
    }

    public List getElementIDsInAccessPattern(Object accessPattern) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getElementIDsInAccessPattern(accessPattern);
    }

    public boolean isXMLGroup(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.isXMLGroup(groupID);
    }

    public boolean isTemporaryGroup(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.isTemporaryGroup(groupID);
    }

    public c getMappingNode(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getMappingNode(groupID);
    }

    public String getVirtualDatabaseName() throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getVirtualDatabaseName();
    }

    public Collection getXMLTempGroups(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getXMLTempGroups(groupID);
    }

    public int getCardinality(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getCardinality(groupID);
    }

    public List getXMLSchemas(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getXMLSchemas(groupID);
    }

    public String getNameInSource(Object metadataID) throws MetaMatrixComponentException, QueryMetadataException {
        if (metadataID instanceof MultiSourceElement) {
            return null;
        }
        return this.actualMetadata.getNameInSource(metadataID);
    }

    public int getElementLength(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        if (elementID instanceof MultiSourceElement) {
            return 255;
        }
        return this.actualMetadata.getElementLength(elementID);
    }

    public boolean hasMaterialization(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.hasMaterialization(groupID);
    }

    public Object getMaterialization(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getMaterialization(groupID);
    }

    public Object getMaterializationStage(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getMaterializationStage(groupID);
    }

    public String getNativeType(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        if (elementID instanceof MultiSourceElement) {
            return null;
        }
        return this.actualMetadata.getNativeType(elementID);
    }

    public boolean isProcedureInputElement(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.isProcedureInputElement(elementID);
    }

    public byte[] getBinaryVDBResource(String resourcePath) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getBinaryVDBResource(resourcePath);
    }

    public String getCharacterVDBResource(String resourcePath) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getCharacterVDBResource(resourcePath);
    }

    public String[] getVDBResourcePaths() throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getVDBResourcePaths();
    }

    public String getModeledType(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getModeledType(elementID);
    }

    public String getModeledBaseType(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getModeledBaseType(elementID);
    }

    public String getModeledPrimitiveType(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getModeledPrimitiveType(elementID);
    }
}

