/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.process;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixRuntimeException;
import com.metamatrix.api.exception.query.QueryParserException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.xa.MMUserTransactionServer;
import com.metamatrix.common.xa.XATransactionException;
import com.metamatrix.dqp.DQPPlugin;
import com.metamatrix.dqp.message.TransactionMessage;
import com.metamatrix.dqp.service.MetadataService;
import com.metamatrix.dqp.service.TrackingService;
import com.metamatrix.dqp.service.TransactionService;
import com.metamatrix.query.d.b;
import com.metamatrix.query.m.e;
import com.metamatrix.query.o.j.ac;
import com.metamatrix.query.o.j.l;
import com.metamatrix.query.o.j.u;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.NotSupportedException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class TransactionProcessor {
    private Map threadToXid;
    private TransactionService service;
    private MetadataService metadataService;
    private TrackingService trackingService;
    private boolean transactionsAllowed;

    public TransactionProcessor(TransactionService transactionService, MetadataService metadataService, TrackingService trackingService, boolean transactionsAllowed) {
        this.service = transactionService;
        this.metadataService = metadataService;
        this.trackingService = trackingService;
        this.transactionsAllowed = transactionsAllowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Message proccessTransactionMessage(TransactionMessage msg) throws MetaMatrixComponentException, XATransactionException, XAException {
        if (!this.transactionsAllowed) {
            String message = DQPPlugin.Util.getString("TransactionProcessor.Transactions_not_allowed_due_to_license_restriction");
            LogManager.logError("DQP", message);
            throw new MetaMatrixComponentException(message);
        }
        switch (msg.getRequestType()) {
            case 7: {
                if (this.trackingService.willRecordTxn()) {
                    this.trackingService.log(msg.getXid().toString(), (short)1, (short)5, msg.getConnectionID(), msg.getUserName(), msg.getVdbName(), msg.getVdbVersion());
                }
                try {
                    this.service.getXAServer().start(msg.getXid(), msg.getParameter());
                    break;
                }
                catch (RemoteException re) {
                    throw new XAException(-3);
                }
            }
            case 11: {
                if (this.trackingService.willRecordTxn()) {
                    this.trackingService.log(msg.getXid().toString(), (short)4, (short)6, msg.getConnectionID(), msg.getUserName(), msg.getVdbName(), msg.getVdbVersion());
                }
                try {
                    this.service.getXAServer().end(msg.getXid(), msg.getParameter());
                    break;
                }
                catch (RemoteException re) {
                    throw new XAException(-3);
                }
            }
            case 12: {
                if (this.trackingService.willRecordTxn()) {
                    this.trackingService.log(msg.getXid().toString(), (short)4, (short)7, msg.getConnectionID(), msg.getUserName(), msg.getVdbName(), msg.getVdbVersion());
                }
                try {
                    int result = this.service.getXAServer().prepare(msg.getXid());
                    msg.setParameter(result);
                    break;
                }
                catch (RemoteException re) {
                    throw new XAException(-3);
                }
            }
            case 8: {
                if (this.trackingService.willRecordTxn()) {
                    this.trackingService.log(msg.getXid().toString(), (short)2, (short)8, msg.getConnectionID(), msg.getUserName(), msg.getVdbName(), msg.getVdbVersion());
                }
                try {
                    this.service.getXAServer().commit(msg.getXid(), 1 == msg.getParameter());
                    break;
                }
                catch (RemoteException re) {
                    throw new XAException(-3);
                }
            }
            case 10: {
                if (this.trackingService.willRecordTxn()) {
                    this.trackingService.log(msg.getXid().toString(), (short)2, (short)9, msg.getConnectionID(), msg.getUserName(), msg.getVdbName(), msg.getVdbVersion());
                }
                try {
                    this.service.getXAServer().forget(msg.getXid());
                    break;
                }
                catch (RemoteException re) {
                    throw new XAException(-3);
                }
            }
            case 13: {
                if (this.trackingService.willRecordTxn()) {
                    this.trackingService.log(msg.getXid().toString(), (short)1, (short)10, msg.getConnectionID(), msg.getUserName(), msg.getVdbName(), msg.getVdbVersion());
                }
                try {
                    Xid[] xids = this.service.getXAServer().recover(msg.getParameter());
                    msg.setRecoveredXids(xids);
                    break;
                }
                catch (RemoteException re) {
                    throw new XAException(-3);
                }
            }
            case 9: {
                if (this.trackingService.willRecordTxn()) {
                    this.trackingService.log(msg.getXid().toString(), (short)2, (short)11, msg.getConnectionID(), msg.getUserName(), msg.getVdbName(), msg.getVdbVersion());
                }
                try {
                    this.service.getXAServer().rollback(msg.getXid());
                    break;
                }
                catch (RemoteException re) {
                    throw new XAException(-3);
                }
            }
            case 14: {
                try {
                    this.service.getXAServer().setTransactionTimeout(msg.getTxnTimeout());
                    break;
                }
                catch (RemoteException re) {
                    throw new XAException(-3);
                }
            }
            case 1: {
                msg.setTxnRequired(this.checkNeedTxn(msg));
                break;
            }
            case 2: {
                String threadId = msg.getThreadIdentifier();
                String txnID = this.getTransactionID(threadId);
                if (txnID != null) {
                    msg.setException(new NotSupportedException(DQPPlugin.Util.getString("TransactionProcessor.Client_thread_already_involved_in_transaction")));
                    break;
                }
                try {
                    MMUserTransactionServer uts = this.service.getTransactionManager().getUserTransactionService();
                    txnID = uts.begin(msg.getTxnTimeout());
                    this.addUserTransactionBinding(threadId, txnID);
                    msg.setMMXid(txnID);
                    if (!this.trackingService.willRecordTxn()) break;
                    this.trackingService.log(txnID, (short)1, (short)1, msg.getConnectionID(), msg.getUserName(), msg.getVdbName(), msg.getVdbVersion());
                }
                catch (Throwable e2) {
                    this.removeThreadMapping(threadId);
                    msg.setException(e2);
                }
                break;
            }
            case 3: {
                String threadId = msg.getThreadIdentifier();
                try {
                    MMUserTransactionServer uts = this.service.getTransactionManager().getUserTransactionService();
                    String xid = this.getTransactionID(threadId);
                    if (this.trackingService.willRecordTxn()) {
                        this.trackingService.log(xid, (short)2, (short)2, msg.getConnectionID(), msg.getUserName(), msg.getVdbName(), msg.getVdbVersion());
                    }
                    if (xid != null) {
                        uts.commit(xid);
                        break;
                    }
                    msg.setException(new MetaMatrixRuntimeException(DQPPlugin.Util.getString("TransactionProcessor.Unable_to_find_thread_to_Xid_mapping")));
                    break;
                }
                catch (Throwable e3) {
                    msg.setException(e3);
                    break;
                }
                finally {
                    this.removeThreadMapping(threadId);
                }
            }
            case 4: {
                String threadId = msg.getThreadIdentifier();
                try {
                    MMUserTransactionServer uts = this.service.getTransactionManager().getUserTransactionService();
                    String xid = this.getTransactionID(threadId);
                    if (this.trackingService.willRecordTxn()) {
                        this.trackingService.log(xid, (short)2, (short)3, msg.getConnectionID(), msg.getUserName(), msg.getVdbName(), msg.getVdbVersion());
                    }
                    if (xid != null) {
                        uts.rollback(xid);
                        break;
                    }
                    msg.setException(new MetaMatrixRuntimeException(DQPPlugin.Util.getString("TransactionProcessor.Unable_to_find_thread_to_Xid_mapping")));
                    break;
                }
                catch (Throwable e4) {
                    msg.setException(e4);
                    break;
                }
                finally {
                    this.removeThreadMapping(threadId);
                }
            }
            case 5: {
                String threadId = msg.getThreadIdentifier();
                try {
                    MMUserTransactionServer uts = this.service.getTransactionManager().getUserTransactionService();
                    String xid = this.getTransactionID(threadId);
                    if (this.trackingService.willRecordTxn()) {
                        this.trackingService.log(xid, (short)2, (short)4, msg.getConnectionID(), msg.getUserName(), msg.getVdbName(), msg.getVdbVersion());
                    }
                    if (xid != null) {
                        uts.setRollbackOnly(xid);
                        break;
                    }
                    msg.setException(new MetaMatrixRuntimeException(DQPPlugin.Util.getString("TransactionProcessor.Unable_to_find_thread_to_Xid_mapping")));
                    break;
                }
                catch (Throwable e5) {
                    msg.setException(e5);
                    break;
                }
                finally {
                    this.removeThreadMapping(threadId);
                }
            }
            case 6: {
                try {
                    MMUserTransactionServer uts = this.service.getTransactionManager().getUserTransactionService();
                    String xid = this.getTransactionID(msg.getThreadIdentifier());
                    int status = 5;
                    if (xid != null) {
                        status = uts.getStatus(xid);
                    } else {
                        msg.setException(new MetaMatrixRuntimeException(DQPPlugin.Util.getString("TransactionProcessor.Unable_to_find_thread_to_Xid_mapping")));
                    }
                    msg.setTxnStatus(status);
                    break;
                }
                catch (Throwable e6) {
                    msg.setException(e6);
                }
            }
        }
        return msg;
    }

    private void removeThreadMapping(String threadId) {
        if (this.threadToXid != null) {
            this.threadToXid.remove(threadId);
        }
    }

    private String getTransactionID(String threadIdentifier) {
        if (this.threadToXid == null) {
            return null;
        }
        return (String)this.threadToXid.get(threadIdentifier);
    }

    private void addUserTransactionBinding(String threadId, String xId) {
        if (this.threadToXid == null) {
            this.threadToXid = new HashMap(11);
        }
        this.threadToXid.put(threadId, xId);
    }

    private boolean checkNeedTxn(TransactionMessage msg) throws MetaMatrixComponentException {
        try {
            e metadata = this.metadataService.lookupMetadata(msg.getVdbName(), msg.getVdbVersion());
            l command = msg.getCommand();
            b parser = new b();
            if (command.gn() == 5) {
                command = parser.f(((ac)command).ii());
            } else if (command.gn() == 9) {
                List updates = ((u)command).hp();
                ArrayList<l> parsedCommands = new ArrayList<l>(updates.size());
                ac updateCommand = null;
                for (int i2 = 0; i2 < updates.size(); ++i2) {
                    updateCommand = (ac)updates.get(i2);
                    parsedCommands.add(parser.f(updateCommand.ii()));
                }
                command = new u(parsedCommands);
            }
            com.metamatrix.query.f.b.k(command, metadata);
            if (command.ge(metadata) > 1) {
                return true;
            }
        }
        catch (RuntimeException e2) {
            String errMsg = DQPPlugin.Util.getString("TransactionProcessor.checkNeedTxn.rtException", msg.getRequestID());
            LogManager.logError("DQP", (Throwable)e2, errMsg);
            throw new MetaMatrixComponentException((Throwable)e2, e2.getMessage());
        }
        catch (QueryResolverException e3) {
            return false;
        }
        catch (QueryParserException e4) {
            return false;
        }
        return false;
    }
}

