/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.process;

import com.metamatrix.common.comm.api.ClientConnection;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.core.util.LRUCache;
import com.metamatrix.query.e.e;
import com.metamatrix.query.k.b;
import com.metamatrix.query.o.j.l;
import java.util.List;

public class PreparedPlanCache {
    private static int DEFAULT_MAX_SIZE_TOTAL = 100;
    private LRUCache cache = new LRUCache();

    PreparedPlanCache() {
        this(0);
    }

    PreparedPlanCache(int maxSize) {
        if (maxSize == 0) {
            maxSize = DEFAULT_MAX_SIZE_TOTAL;
        }
        this.cache.setSpaceLimit(maxSize);
    }

    public synchronized PreparedPlan getPreparedPlan(ClientConnection clientConn, String sql) {
        ArgCheck.isNotNull(clientConn);
        ArgCheck.isNotNull(sql);
        CacheID cID = new CacheID(clientConn, sql);
        return (PreparedPlan)this.cache.get(cID);
    }

    public synchronized PreparedPlan createPreparedPlan(ClientConnection clientConn, String sql) {
        ArgCheck.isNotNull(clientConn);
        ArgCheck.isNotNull(sql);
        CacheID cID = new CacheID(clientConn, sql);
        PreparedPlan preparedPlan = (PreparedPlan)this.cache.get(cID);
        if (preparedPlan == null) {
            preparedPlan = new PreparedPlan();
            this.cache.put(cID, preparedPlan);
        }
        return preparedPlan;
    }

    public synchronized void clear(ClientConnection clientConn) {
        ArgCheck.isNotNull(clientConn);
    }

    public synchronized void clearAll() {
        this.cache.flush();
    }

    int getTotalSize() {
        return this.cache.getCurrentSpace();
    }

    static class PreparedPlan {
        private e plan;
        private l command;
        private List refs;
        private b analysisRecord;

        PreparedPlan() {
        }

        public e getPlan() {
            return this.plan;
        }

        public b getAnalysisRecord() {
            return this.analysisRecord;
        }

        public l getCommand() {
            return this.command;
        }

        public List getReferences() {
            return this.refs;
        }

        public void setPlan(e planValue) {
            this.plan = planValue;
        }

        public void setAnalysisRecord(b analysisRecord) {
            this.analysisRecord = analysisRecord;
        }

        public void setCommand(l commandValue) {
            this.command = commandValue;
        }

        public void setReferences(List refsValue) {
            this.refs = refsValue;
        }
    }

    static class CacheID {
        private ClientConnection clientConn;
        private String sql;
        int hashCode;

        CacheID(ClientConnection clientConn, String sql) {
            this.clientConn = clientConn;
            this.sql = sql;
            this.hashCode = HashCodeUtil.hashCode(HashCodeUtil.hashCode(0, clientConn), sql);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof CacheID)) {
                return false;
            }
            CacheID that = (CacheID)obj;
            return this.clientConn.equals(that.clientConn) && this.sql.equals(that.sql);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

