/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.datamgr.impl;

import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.api.SecurityContext;
import com.metamatrix.dqp.internal.datamgr.ExecutionContextInternal;
import com.metamatrix.dqp.internal.datamgr.impl.AtomicRequestID;
import java.io.Serializable;

public class ExecutionContextImpl
implements ExecutionContextInternal,
SecurityContext {
    private String requestID;
    private String partID;
    private String vdbName;
    private String vdbVersion;
    private String userName;
    private Serializable trustedPayload;
    private Serializable executionPayload;
    private String connectionID;
    private boolean useResultSetCache;
    private AtomicRequestID atomicRequestID;

    public ExecutionContextImpl(String vdbName, String vdbVersion, String userName, Serializable trustedPayload, Serializable executionPayload, String connectionID, boolean useResultSetCache, AtomicRequestID atomicRequestID) {
        this.vdbName = vdbName;
        this.vdbVersion = vdbVersion;
        this.userName = userName;
        this.trustedPayload = trustedPayload;
        this.executionPayload = executionPayload;
        this.requestID = atomicRequestID.getRequestID();
        this.partID = atomicRequestID.getPartID();
        this.connectionID = connectionID;
        this.useResultSetCache = useResultSetCache;
        this.atomicRequestID = atomicRequestID;
    }

    public String getRequestIdentifier() {
        return this.requestID;
    }

    public String getPartIdentifier() {
        return this.partID;
    }

    public String getVirtualDatabaseName() {
        return this.vdbName;
    }

    public String getVirtualDatabaseVersion() {
        return this.vdbVersion;
    }

    public String getUser() {
        return this.userName;
    }

    public Serializable getTrustedPayload() {
        return this.trustedPayload;
    }

    public Serializable getExecutionPayload() {
        return this.executionPayload;
    }

    public String getConnectionIdentifier() {
        return this.connectionID;
    }

    public boolean useResultSetCache() {
        return this.useResultSetCache;
    }

    public AtomicRequestID getAtomicRequestID() {
        return this.atomicRequestID;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof ExecutionContext)) {
            return false;
        }
        ExecutionContext other = (ExecutionContext)obj;
        return this.compareWithNull(this.getRequestIdentifier(), other.getRequestIdentifier()) && this.compareWithNull(this.getPartIdentifier(), other.getPartIdentifier());
    }

    private boolean compareWithNull(Object obj1, Object obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        if (obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    public int hashCode() {
        return HashCodeUtil.hashCode(HashCodeUtil.hashCode(0, this.requestID), this.partID);
    }

    public String toString() {
        return "ExecutionContext<vdb=" + this.vdbName + ", version=" + this.vdbVersion + ", user=" + this.userName + ">";
    }
}

