/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.datamgr.impl;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.application.ApplicationEnvironment;
import com.metamatrix.common.application.basic.BasicApplication;
import com.metamatrix.common.application.exception.ApplicationLifecycleException;
import com.metamatrix.common.comm.api.ClientConnection;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.api.ServerListener;
import com.metamatrix.common.comm.exception.ApplicationException;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.queue.QueueSuspendedException;
import com.metamatrix.common.queue.WorkerPool;
import com.metamatrix.common.queue.WorkerPoolStats;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.common.xa.ConnectorTransactionManager;
import com.metamatrix.common.xa.XATransactionException;
import com.metamatrix.data.api.Connection;
import com.metamatrix.data.api.Connector;
import com.metamatrix.data.api.ConnectorCapabilities;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ValueChunk;
import com.metamatrix.data.api.ValueReference;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.monitor.AliveStatus;
import com.metamatrix.data.monitor.ConnectionStatus;
import com.metamatrix.data.monitor.MonitoredConnector;
import com.metamatrix.data.xa.api.XAConnector;
import com.metamatrix.dqp.DQPPlugin;
import com.metamatrix.dqp.internal.cache.ResultSetCache;
import com.metamatrix.dqp.internal.cache.connector.CacheConnector;
import com.metamatrix.dqp.internal.datamgr.CapabilitiesConverter;
import com.metamatrix.dqp.internal.datamgr.ConnectorID;
import com.metamatrix.dqp.internal.datamgr.ConnectorManager;
import com.metamatrix.dqp.internal.datamgr.exception.ConnectorInitializationException;
import com.metamatrix.dqp.internal.datamgr.impl.AtomicRequestID;
import com.metamatrix.dqp.internal.datamgr.impl.ConnectorEnvironmentImpl;
import com.metamatrix.dqp.internal.datamgr.impl.ConnectorStateManager;
import com.metamatrix.dqp.internal.datamgr.impl.ConnectorWorkerFactory;
import com.metamatrix.dqp.internal.datamgr.impl.DefaultConnectorLogger;
import com.metamatrix.dqp.internal.datamgr.impl.ExecutionContextImpl;
import com.metamatrix.dqp.internal.datamgr.impl.NullMonitoredConnector;
import com.metamatrix.dqp.message.AdminRequestMessage;
import com.metamatrix.dqp.message.AdminResultsMessage;
import com.metamatrix.dqp.message.AtomicRequestMessage;
import com.metamatrix.dqp.message.CapabilitiesMessage;
import com.metamatrix.dqp.message.DQPInboundMessage;
import com.metamatrix.dqp.message.DQPMessage;
import com.metamatrix.dqp.message.RequestMessage;
import com.metamatrix.dqp.message.ResultsMessage;
import com.metamatrix.dqp.service.MetadataService;
import com.metamatrix.dqp.service.TrackingService;
import com.metamatrix.dqp.service.TransactionService;
import com.metamatrix.internal.core.text.MessageFormat;
import com.metamatrix.query.i.e;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;

public class ConnectorManagerImpl
extends BasicApplication
implements ConnectorManager {
    public static final String DEFAULT_MAX_PROCESSOR_THREADS = "15";
    public static final String DEFAULT_PROCESSOR_TREAD_TTL = "120000";
    private ConnectorEnvironment connectorEnv;
    private Connector connector;
    private MonitoredConnector monitoredConnector;
    private Collection clientConnections = new HashSet();
    private ConnectorStateManager connectorStateManager;
    private ConnectorID connectorID;
    private WorkerPool connectorWorkerPool;
    private ConnectorWorkerFactory connectorWorkerFactory;
    private MetadataService metadataService;
    private TrackingService tracker;
    private TransactionService transactionService;
    private boolean poolIsOpen;
    private ServerListener listenerFilter = new InternalServerListener();

    public String getName() {
        String name = null;
        if (this.connectorID != null) {
            name = this.connectorID.toString();
        }
        return name;
    }

    public ConnectionStatus getStatus() {
        if (this.monitoredConnector != null) {
            return this.monitoredConnector.getStatus();
        }
        return new ConnectionStatus(AliveStatus.UNKNOWN);
    }

    public void setConnectorID(ConnectorID connectorID) {
        this.connectorID = connectorID;
    }

    public ConnectorID getConnectorID() {
        return this.connectorID;
    }

    public void clearPool(boolean force) {
        this.poolIsOpen = false;
        if (force && this.connectorWorkerPool != null) {
            this.connectorWorkerPool.shutdown();
            this.connectorWorkerPool = null;
        }
    }

    public void start() throws ApplicationLifecycleException {
        Properties appProps = this.getEnvironment().getApplicationProperties();
        String connectorName = appProps.getProperty("ConnectorBindingName");
        if (this.connectorID == null) {
            String connIDStr = appProps.getProperty("ConnectorID");
            this.connectorID = new ConnectorID(connIDStr);
        }
        Object[] cname = new Object[]{connectorName};
        LogManager.logInfo("CONNECTOR", DQPPlugin.Util.getString("ConnectorManagerImpl.Initializing_connector", cname));
        int maxResultRows = -1;
        String maxResultRowsString = appProps.getProperty("MaxResultRows");
        if (maxResultRowsString != null && maxResultRowsString.trim().length() > 0) {
            try {
                maxResultRows = Integer.parseInt(maxResultRowsString);
            }
            catch (NumberFormatException e2) {
                Object[] params = new Object[]{"MaxResultRows"};
                String msg = DQPPlugin.Util.getString("ConnectorManagerImpl.Couldn__t_parse_property", params);
                LogManager.logError("CONNECTOR", (Throwable)e2, msg);
                throw new ApplicationLifecycleException((Throwable)e2, msg);
            }
        }
        this.transactionService = (TransactionService)this.getEnvironment().findService("dqp.transaction");
        String connectorClassString = appProps.getProperty("ConnectorClass");
        if (connectorClassString == null || connectorClassString.trim().length() == 0) {
            Object[] params = new Object[]{"ConnectorClass", connectorName};
            String msg = DQPPlugin.Util.getString("ConnectorManagerImpl.Missing_required_property_in_ConnectorManager", params);
            LogManager.logError("CONNECTOR", msg);
            throw new ApplicationLifecycleException(msg);
        }
        connectorClassString = connectorClassString.trim();
        this.connectorEnv = this.createConnectorEnvironment(this.connectorID, connectorClassString, maxResultRows);
        this.initStartConnector(this.connectorEnv);
        this.metadataService = (MetadataService)this.getEnvironment().findService("dqp.metadata");
        if (this.metadataService == null) {
            Object[] params = new Object[]{"dqp.metadata", connectorName};
            String msg = DQPPlugin.Util.getString("ConnectorManagerImpl.Can__t_find_instance_of_service_in_ConnectorManager", params);
            LogManager.logError("CONNECTOR", msg);
            throw new ApplicationLifecycleException(msg);
        }
        this.tracker = (TrackingService)this.getEnvironment().findService("dqp.tracking");
        try {
            this.createConnectorPool(appProps);
        }
        catch (ConnectorInitializationException e3) {
            throw new ApplicationLifecycleException(e3);
        }
        this.poolIsOpen = true;
    }

    public boolean started() {
        return this.poolIsOpen;
    }

    public void stop() throws ApplicationLifecycleException {
        super.stop();
        this.stopMyself();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopMyself() {
        this.poolIsOpen = false;
        this.notifyClosing();
        if (this.connectorWorkerPool != null) {
            this.connectorWorkerPool.shutdown();
        }
        if (this.connector != null) {
            Thread currentThread = Thread.currentThread();
            ClassLoader threadContextLoader = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(this.connector.getClass().getClassLoader());
                this.connector.stop();
            }
            finally {
                currentThread.setContextClassLoader(threadContextLoader);
            }
            if (this.connector instanceof CacheConnector) {
                ((CacheConnector)this.connector).getCache().shutDown();
            }
        }
        if (this.connectorStateManager != null) {
            this.connectorStateManager.shutdown();
        }
    }

    public void restart() throws ApplicationLifecycleException {
        this.stopMyself();
        this.start();
    }

    public Connector getConnector() {
        return this.connector;
    }

    private Collection getQueueStatistics() {
        if (this.connectorWorkerPool == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<WorkerPoolStats> statList = new ArrayList<WorkerPoolStats>(1);
        statList.add(this.connectorWorkerPool.getStats());
        return statList;
    }

    private Collection getQueueStatistics(String name) {
        if (this.connectorID == null || !name.equalsIgnoreCase(this.connectorID.getID()) || this.connectorWorkerPool == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<WorkerPoolStats> stats = new ArrayList<WorkerPoolStats>(2);
        stats.add(this.connectorWorkerPool.getStats());
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyClosing() {
        Collection collection = this.clientConnections;
        synchronized (collection) {
            Iterator clientConnectionItr = this.clientConnections.iterator();
            while (clientConnectionItr.hasNext()) {
                ClientConnection clientConnection = (ClientConnection)clientConnectionItr.next();
                try {
                    clientConnection.shutdown();
                }
                catch (CommunicationException e2) {
                    LogManager.logError("CONNECTOR", (Throwable)e2, DQPPlugin.Util.getString("ConnectorManagerImpl.Error_closing_client_connection_in_ConnectorManager"));
                }
            }
        }
    }

    private ConnectorEnvironment createConnectorEnvironment(ConnectorID id, String connectorClassName, int maxResultRows) {
        ApplicationEnvironment env = this.getEnvironment();
        Properties clonedProps = PropertiesUtils.clone(env.getApplicationProperties());
        ConnectorEnvironmentImpl connectorEnv = new ConnectorEnvironmentImpl(clonedProps, new DefaultConnectorLogger(id), this.connectorID, env);
        return connectorEnv;
    }

    private void sendFailure(ClientConnection connection, ResultsMessage failureMsg, String key) {
        try {
            Object[] params = new Object[]{failureMsg.getRequestID(), failureMsg.getException()};
            LogManager.logError("CONNECTOR", DQPPlugin.Util.getString("ConnectorManagerImpl.RequestMessage_{0}_failed.__Cause__{1}", params));
            connection.send(failureMsg, key);
        }
        catch (CommunicationException e2) {
            Object[] params = new Object[]{connection.getConnectionProperty("connectionID"), failureMsg.getException()};
            LogManager.logError("CONNECTOR", (Throwable)e2, DQPPlugin.Util.getString("ConnectorManagerImpl.Unable_to_notify_client_of_failure", params));
        }
    }

    private void createConnectorPool(Properties appProps) throws ConnectorInitializationException {
        Object[] params;
        this.connectorStateManager = new ConnectorStateManager(this.connector, this);
        this.connectorWorkerFactory = new ConnectorWorkerFactory(this.connectorStateManager, this.getEnvironment(), this.metadataService, this.tracker, this.transactionService, this.connector.getClass().getClassLoader());
        String maxThreadsString = appProps.getProperty("ConnectorMaxThreads");
        String threadTTLString = appProps.getProperty("ConnectorThreadTTL");
        if (maxThreadsString == null || maxThreadsString.trim().length() == 0) {
            maxThreadsString = DEFAULT_MAX_PROCESSOR_THREADS;
            params = new Object[]{"ConnectorMaxThreads", DEFAULT_MAX_PROCESSOR_THREADS};
            LogManager.logWarning("DQP", DQPPlugin.Util.getString("ConnectorManagerImpl.Missing_property_Using_default_in_ConnectorManager", params));
        }
        if (threadTTLString == null || threadTTLString.trim().length() == 0) {
            threadTTLString = DEFAULT_PROCESSOR_TREAD_TTL;
            params = new Object[]{"ConnectorThreadTTL", DEFAULT_PROCESSOR_TREAD_TTL};
            LogManager.logWarning("DQP", DQPPlugin.Util.getString("ConnectorManagerImpl.Missing_property_Using_default_in_ConnectorManager", params));
        }
        int maxThreads = 0;
        int threadTTL = 0;
        try {
            maxThreads = Integer.parseInt(maxThreadsString);
        }
        catch (NumberFormatException e2) {
            Object[] params2 = new Object[]{maxThreadsString, "ConnectorMaxThreads", this.connectorID};
            String msg = DQPPlugin.Util.getString("ConnectorManagerImpl.Unable_to_parse_required_property_in_ConnectorManager", params2);
            throw new ConnectorInitializationException((Throwable)e2, msg);
        }
        try {
            threadTTL = Integer.parseInt(threadTTLString);
        }
        catch (NumberFormatException e3) {
            Object[] params3 = new Object[]{threadTTLString, "ConnectorThreadTTL", this.connectorID};
            String msg = DQPPlugin.Util.getString("ConnectorManagerImpl.Unable_to_parse_required_property_in_ConnectorManager", params3);
            throw new ConnectorInitializationException((Throwable)e3, msg);
        }
        String connectorName = appProps.getProperty("ConnectorBindingName");
        if (connectorName == null) {
            connectorName = "Unknown_Binding_Name";
        }
        String threadName = connectorName + "_" + this.connectorID.getID();
        this.connectorWorkerPool = new WorkerPool(threadName, this.connectorWorkerFactory, maxThreads, threadTTL);
        this.connectorWorkerFactory.setWorkerPool(this.connectorWorkerPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initStartConnector(ConnectorEnvironment env) throws ApplicationLifecycleException {
        block19: {
            String connectorClassName = env.getProperties().getProperty("ConnectorClass");
            ClassLoader loader = (ClassLoader)this.getEnvironment().getApplicationProperties().get("ConnectorClassLoader");
            if (loader == null) {
                loader = this.getClass().getClassLoader();
            }
            Class<?> clazz = null;
            try {
                clazz = loader.loadClass(connectorClassName);
            }
            catch (ClassNotFoundException e2) {
                Object[] params = new Object[]{connectorClassName};
                String msg = DQPPlugin.Util.getString("ConnectorManagerImpl.Couldn__t_find_Connector_class", params);
                LogManager.logError("CONNECTOR", (Throwable)e2, msg);
                throw new ApplicationLifecycleException((Throwable)e2, msg);
            }
            XAConnector xaConnector = null;
            try {
                this.connector = (Connector)clazz.newInstance();
                if (this.connector instanceof XAConnector) {
                    xaConnector = (XAConnector)this.connector;
                    if (this.transactionService == null) {
                        String bindingName = (String)this.getEnvironment().getApplicationProperties().get("ConnectorBindingName");
                        String msg = DQPPlugin.Util.getString("ConnectorManagerImpl.no_txn_manager", new Object[]{bindingName});
                        throw new ApplicationLifecycleException(msg);
                    }
                }
                this.monitoredConnector = this.connector instanceof MonitoredConnector ? (MonitoredConnector)((Object)this.connector) : new NullMonitoredConnector();
                this.connector = this.wrapCacheConnector(this.connector);
            }
            catch (InstantiationException e3) {
                Object[] params = new Object[]{connectorClassName};
                String msg = DQPPlugin.Util.getString("ConnectorManagerImpl.Couldn__t_instantiate_Connector_class", params);
                LogManager.logError("CONNECTOR", (Throwable)e3, msg);
                throw new ApplicationLifecycleException((Throwable)e3, msg);
            }
            catch (IllegalAccessException e4) {
                Object[] params = new Object[]{connectorClassName};
                String msg = DQPPlugin.Util.getString("ConnectorManagerImpl.Couldn__t_access_Connector_class", params);
                LogManager.logError("CONNECTOR", (Throwable)e4, msg);
                throw new ApplicationLifecycleException((Throwable)e4, msg);
            }
            Thread currentThread = Thread.currentThread();
            ClassLoader threadContextLoader = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(loader);
                try {
                    this.connector.initialize(env);
                }
                catch (ConnectorException e5) {
                    Object[] params = new Object[]{connectorClassName};
                    String msg = DQPPlugin.Util.getString("ConnectorManagerImpl.Couldn__t_initialize_Connector_class", params);
                    LogManager.logError("CONNECTOR", (Throwable)e5, msg);
                    throw new ApplicationLifecycleException((Throwable)e5, msg);
                }
                try {
                    this.connector.start();
                }
                catch (ConnectorException e6) {
                    String msg = DQPPlugin.Util.getString("ConnectorManagerImpl.Couldn__t_start_Connector", this.getConnectorID(), e6.getMessage());
                    LogManager.logError("CONNECTOR", (Throwable)e6, msg);
                    throw new ApplicationLifecycleException((Throwable)e6, msg);
                }
                if (xaConnector == null) break block19;
                try {
                    Object rResource = xaConnector.getRecoverableResource();
                    ConnectorTransactionManager ctm = (ConnectorTransactionManager)((Object)this.transactionService.getTransactionManager());
                    ctm.registerResource(rResource);
                }
                catch (ConnectorException e7) {
                    throw new ApplicationLifecycleException(e7);
                }
                catch (XATransactionException e8) {
                    throw new ApplicationLifecycleException(e8);
                }
                catch (MetaMatrixComponentException e9) {
                    throw new ApplicationLifecycleException(e9);
                }
            }
            finally {
                currentThread.setContextClassLoader(threadContextLoader);
            }
        }
    }

    private Connector wrapCacheConnector(Connector connector) {
        Properties props = this.connectorEnv.getProperties();
        Properties rsCacheProps = null;
        if (Boolean.valueOf(props.getProperty("ResultSetCacheEnabled", "false")).booleanValue()) {
            rsCacheProps = new Properties();
            rsCacheProps.setProperty("maxSize", props.getProperty("ResultSetCacheMaxSize", "0"));
            rsCacheProps.setProperty("maxAge", props.getProperty("ResultSetCacheMaxAge", "0"));
            rsCacheProps.setProperty("scope", props.getProperty("ResultSetCacheScope", "vdb"));
            try {
                ResultSetCache rsCache = new ResultSetCache(rsCacheProps);
                return new CacheConnector(connector, rsCache);
            }
            catch (MetaMatrixComponentException e2) {
                LogManager.logWarning("CONNECTOR", (Throwable)e2, DQPPlugin.Util.getString("DQPCORE.6"));
            }
        }
        return connector;
    }

    private ValueReference getValueReference(e valueID) {
        return ((ConnectorEnvironmentImpl)this.connectorEnv).getReference(valueID);
    }

    public void connectionAdded(ClientConnection connection) {
        this.listenerFilter.connectionAdded(connection);
    }

    public void connectionRemoved(ClientConnection connection) {
        this.listenerFilter.connectionRemoved(connection);
    }

    public void receive(ClientConnection connection, Message message, String messageKey) {
        this.listenerFilter.receive(connection, message, messageKey);
    }

    public Message receive(ClientConnection connection, Message message) throws ApplicationException {
        return this.listenerFilter.receive(connection, message);
    }

    public ConnectorEnvironment getConnectorEnvironment() {
        return this.connectorEnv;
    }

    class InternalServerListener
    implements ServerListener {
        InternalServerListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connectionAdded(ClientConnection connection) {
            Collection collection = ConnectorManagerImpl.this.clientConnections;
            synchronized (collection) {
                ConnectorManagerImpl.this.clientConnections.add(connection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connectionRemoved(ClientConnection connection) {
            Collection collection = ConnectorManagerImpl.this.clientConnections;
            synchronized (collection) {
                ConnectorManagerImpl.this.clientConnections.remove(connection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Message receive(ClientConnection connection, Message message) throws ApplicationException {
            DQPInboundMessage incomingMessage = (DQPInboundMessage)message;
            if (DQPPlugin.DEBUG) {
                Object[] params = new Object[]{connection.getConnectionProperty("connectionID"), message};
                LogManager.logInfo("CONNECTOR", MessageFormat.format("ConnectorManagerImpl.receive (synch) - clientIdentifier: {0} Message: {1}", params));
            }
            DQPMessage result = null;
            int msgType = incomingMessage.getMessageType();
            block3 : switch (msgType) {
                case 9: {
                    CapabilitiesMessage capMsg = (CapabilitiesMessage)message;
                    Connection conn = null;
                    try {
                        AtomicRequestID atomicID = new AtomicRequestID("", "", "");
                        ExecutionContextImpl context = new ExecutionContextImpl(capMsg.getVdbName(), capMsg.getVdbVersion(), capMsg.getUserName(), capMsg.getTrustedPayload(), capMsg.getExecutionPayload(), "", false, atomicID);
                        Thread currentThread = Thread.currentThread();
                        ClassLoader threadContextLoader = currentThread.getContextClassLoader();
                        try {
                            currentThread.setContextClassLoader(ConnectorManagerImpl.this.connector.getClass().getClassLoader());
                            conn = ConnectorManagerImpl.this.connector.getConnection(context);
                            ConnectorCapabilities caps = conn.getCapabilities();
                            CapabilitiesMessage retMsg = new CapabilitiesMessage();
                            retMsg.setCaps(CapabilitiesConverter.convertCapabilities(caps));
                            result = retMsg;
                            break;
                        }
                        finally {
                            currentThread.setContextClassLoader(threadContextLoader);
                        }
                    }
                    catch (ConnectorException e2) {
                        Object[] params = new Object[]{capMsg};
                        String msg = DQPPlugin.Util.getString("ConnectorStateManager.Unable_to_create_connection_for_request", params);
                        ApplicationException ce = new ApplicationException((Throwable)e2, msg);
                        LogManager.logError("CONNECTOR", (Throwable)ce, ce.getMessage());
                        throw ce;
                    }
                    finally {
                        if (conn != null) {
                            conn.release();
                        }
                    }
                }
                case 10: {
                    AdminRequestMessage adminReq = (AdminRequestMessage)incomingMessage;
                    switch (adminReq.getRequestType()) {
                        case 2: {
                            result = new AdminResultsMessage(ConnectorManagerImpl.this.getQueueStatistics());
                            break;
                        }
                        case 3: {
                            result = new AdminResultsMessage(ConnectorManagerImpl.this.getQueueStatistics(adminReq.getMsgParam()));
                            break;
                        }
                        case 6: {
                            if (!(ConnectorManagerImpl.this.connector instanceof CacheConnector)) break block3;
                            ((CacheConnector)ConnectorManagerImpl.this.connector).getCache().clear();
                            break;
                        }
                        default: {
                            result = null;
                            break;
                        }
                    }
                    break;
                }
                default: {
                    Object[] params = new Object[]{ConnectorManagerImpl.this.connectorID, incomingMessage.getRequestID(), incomingMessage.getClass()};
                    String msg = DQPPlugin.Util.getString("ConnectorManagerImpl.ConnectorManager_{0}_recieved_message_{1}_of_unexpected_type", params);
                    ConnectorException e3 = new ConnectorException(msg);
                    LogManager.logError("CONNECTOR", (Throwable)e3, msg);
                    throw new ApplicationException(msg);
                }
            }
            return result;
        }

        public void receive(ClientConnection connection, Message message, String messageKey) {
            int msgType;
            ResultsMessage failureMsg = null;
            if (message == null) {
                Object[] params = new Object[]{ConnectorManagerImpl.this.connectorID};
                String msg = DQPPlugin.Util.getString("ConnectorManagerImpl.ConnectorManager_received_null_message", params);
                ConnectorException e2 = new ConnectorException(msg);
                LogManager.logError("CONNECTOR", (Throwable)e2, msg);
                failureMsg = new ResultsMessage();
                failureMsg.setException(e2);
                ConnectorManagerImpl.this.sendFailure(connection, failureMsg, messageKey);
                return;
            }
            DQPInboundMessage incomingMessage = (DQPInboundMessage)message;
            if (LogManager.isMessageToBeRecorded("CONNECTOR", 5)) {
                Object[] params = new Object[]{connection.getConnectionProperty("connectionID"), incomingMessage};
                LogManager.logDetail("CONNECTOR", MessageFormat.format("ConnectorManagerImpl.receive (asynch) - clientIdentifier: {0} Message: {1}", params));
            }
            if ((msgType = incomingMessage.getMessageType()) != 1) {
                Object[] params = new Object[]{ConnectorManagerImpl.this.connectorID, incomingMessage.getRequestID(), incomingMessage.getClass()};
                String msg = DQPPlugin.Util.getString("ConnectorManagerImpl.ConnectorManager_{0}_recieved_message_{1}_of_unexpected_type", params);
                ConnectorException e3 = new ConnectorException(msg);
                LogManager.logError("CONNECTOR", (Throwable)e3, msg);
                failureMsg = new ResultsMessage();
                failureMsg.setException(e3);
                ConnectorManagerImpl.this.sendFailure(connection, failureMsg, messageKey);
                return;
            }
            AtomicRequestMessage requestMsg = (AtomicRequestMessage)incomingMessage;
            switch (requestMsg.getType()) {
                case 1: {
                    requestMsg.markProcessingStart();
                    requestMsg.setConnectorID(ConnectorManagerImpl.this.connectorID);
                    requestMsg.setClientConnection(connection);
                    requestMsg.setMessageKey(messageKey);
                    if (ConnectorManagerImpl.this.poolIsOpen) {
                        Object[] params;
                        try {
                            ConnectorManagerImpl.this.connectorStateManager.createAndAddRequestState(requestMsg);
                        }
                        catch (ConnectorException e4) {
                            params = new Object[]{requestMsg.getRequestID(), ConnectorManagerImpl.this.connectorID};
                            LogManager.logError("CONNECTOR", (Throwable)e4, DQPPlugin.Util.getString("ConnectorManagerImpl.Error_creating_connector_request_{0}_state_for_connector_{1}", params));
                            failureMsg = new ResultsMessage(requestMsg, true);
                            failureMsg.setException(e4);
                        }
                        try {
                            ConnectorManagerImpl.this.connectorWorkerPool.addWork(requestMsg);
                        }
                        catch (QueueSuspendedException e5) {
                            params = new Object[]{requestMsg.getRequestID(), ConnectorManagerImpl.this.connectorID};
                            LogManager.logError("CONNECTOR", (Throwable)e5, DQPPlugin.Util.getString("ConnectorManagerImpl.Error_enqueuing_request_in_ConnectorManager", params));
                            failureMsg = new ResultsMessage(requestMsg, true);
                            failureMsg.setException(e5);
                        }
                        break;
                    }
                    Object[] params = new Object[]{requestMsg.getRequestID(), ConnectorManagerImpl.this.connectorID};
                    String msg = DQPPlugin.Util.getString("ConnectorManagerImpl.Unable_to_service_request_{0}_in_connector_{1}_-_Shutting_down", params);
                    ApplicationLifecycleException e6 = new ApplicationLifecycleException(msg);
                    LogManager.logError("CONNECTOR", (Throwable)e6, msg);
                    failureMsg = new ResultsMessage(requestMsg, true);
                    failureMsg.setException(e6);
                    break;
                }
                case 2: {
                    requestMsg.setConnectorID(ConnectorManagerImpl.this.connectorID);
                    requestMsg.setClientConnection(connection);
                    requestMsg.setMessageKey(messageKey);
                    if (ConnectorManagerImpl.this.poolIsOpen) {
                        if (!ConnectorManagerImpl.this.connectorStateManager.isActive(requestMsg)) break;
                        try {
                            ConnectorManagerImpl.this.connectorWorkerPool.addWork(requestMsg);
                        }
                        catch (QueueSuspendedException e7) {
                            Object[] params = new Object[]{requestMsg.getRequestID(), ConnectorManagerImpl.this.connectorID};
                            LogManager.logError("CONNECTOR", (Throwable)e7, DQPPlugin.Util.getString("ConnectorManagerImpl.Error_enqueuing_request_in_ConnectorManager", params));
                            failureMsg = new ResultsMessage(requestMsg, true);
                            failureMsg.setException(e7);
                        }
                        break;
                    }
                    Object[] params = new Object[]{requestMsg.getRequestID(), ConnectorManagerImpl.this.connectorID};
                    String msg = DQPPlugin.Util.getString("ConnectorManagerImpl.Unable_to_service_request_{0}_in_connector_{1}_-_Shutting_down", params);
                    ApplicationLifecycleException e8 = new ApplicationLifecycleException(msg);
                    LogManager.logError("CONNECTOR", (Throwable)e8, msg);
                    failureMsg = new ResultsMessage(requestMsg, true);
                    failureMsg.setException(e8);
                    break;
                }
                case 3: {
                    if (ConnectorManagerImpl.this.poolIsOpen) {
                        if (!ConnectorManagerImpl.this.connectorStateManager.isActive(requestMsg)) break;
                        try {
                            ConnectorManagerImpl.this.connectorWorkerPool.addWork(requestMsg);
                        }
                        catch (QueueSuspendedException e9) {
                            Object[] params = new Object[]{requestMsg.getRequestID(), ConnectorManagerImpl.this.connectorID};
                            LogManager.logError("CONNECTOR", (Throwable)e9, DQPPlugin.Util.getString("ConnectorManagerImpl.Error_enqueuing_request_in_ConnectorManager", params));
                        }
                        break;
                    }
                    Object[] params = new Object[]{requestMsg.getRequestID(), ConnectorManagerImpl.this.connectorID};
                    String msg = DQPPlugin.Util.getString("ConnectorManagerImpl.Unable_to_service_request_{0}_in_connector_{1}_-_Shutting_down", params);
                    ApplicationLifecycleException e10 = new ApplicationLifecycleException(msg);
                    LogManager.logError("CONNECTOR", (Throwable)e10, msg);
                    break;
                }
                case 4: {
                    requestMsg.setConnectorID(ConnectorManagerImpl.this.connectorID);
                    requestMsg.setClientConnection(connection);
                    requestMsg.setMessageKey(messageKey);
                    ValueReference valueRef = ConnectorManagerImpl.this.getValueReference(requestMsg.getValueID());
                    requestMsg.setValueID(requestMsg.getValueID());
                    requestMsg.setLobRequest(true);
                    ResultsMessage response = new ResultsMessage(requestMsg, true);
                    try {
                        if (requestMsg.getStartPosition() == 0L && requestMsg.getChunkSize() == 0) {
                            response.setStreamLength(valueRef.getSize());
                            requestMsg.getClientConnection().send(response, messageKey);
                            break;
                        }
                        try {
                            ValueChunk chunk = valueRef.createChunk(requestMsg.getStartPosition(), requestMsg.getChunkSize());
                            response.setValueChunk(chunk);
                            requestMsg.getClientConnection().send(response, messageKey);
                        }
                        catch (ConnectorException se) {
                            Object[] params = new Object[]{requestMsg.getRequestID().getConnectionID()};
                            String msg = DQPPlugin.Util.getString("ConnectorWorker.Error_communicating_results_to_client", params);
                            LogManager.logError("CONNECTOR", (Throwable)se, msg);
                            failureMsg = new ResultsMessage(requestMsg, true);
                            failureMsg.setException(se);
                        }
                    }
                    catch (CommunicationException e11) {
                        Object[] params = new Object[]{requestMsg.getRequestID().getConnectionID()};
                        String msg = DQPPlugin.Util.getString("ConnectorWorker.Error_communicating_results_to_client", params);
                        LogManager.logError("CONNECTOR", (Throwable)e11, msg);
                        failureMsg = new ResultsMessage(requestMsg, true);
                        failureMsg.setException(e11);
                    }
                    break;
                }
                default: {
                    Object[] params = new Object[]{new Integer(msgType), incomingMessage.getRequestID(), ConnectorManagerImpl.this.connectorID};
                    String msg = DQPPlugin.Util.getString("ConnectorManagerImpl.Unknown_incoming_request_type_for_request_in_ConnectorManager", params);
                    ConnectorException e12 = new ConnectorException(msg);
                    LogManager.logError("CONNECTOR", (Throwable)e12, msg);
                    if (incomingMessage instanceof RequestMessage) {
                        failureMsg = new ResultsMessage((RequestMessage)incomingMessage, true);
                    } else {
                        RequestMessage errorRequest = new RequestMessage();
                        errorRequest.setRequestID(incomingMessage.getRequestID());
                        failureMsg = new ResultsMessage(errorRequest, true);
                    }
                    failureMsg.setException(e12);
                    break;
                }
            }
            if (failureMsg != null) {
                ConnectorManagerImpl.this.sendFailure(connection, failureMsg, messageKey);
            }
        }
    }
}

