/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.datamgr.impl;

import com.metamatrix.dqp.message.AtomicRequestMessage;

public class AtomicRequestID {
    private static final String SEPARATOR = ".";
    private String id;
    private String requestID;
    private String partID;

    public AtomicRequestID(AtomicRequestMessage request) {
        this.requestID = request.getRequestID().toString();
        this.partID = Integer.toString(request.getNodeID());
        this.id = this.requestID + SEPARATOR + this.partID + SEPARATOR + request.getExecCount();
    }

    public AtomicRequestID(String requestID, String partID, String execCount) {
        this.requestID = requestID;
        this.partID = partID;
        this.id = requestID + SEPARATOR + partID + SEPARATOR + execCount;
    }

    public String getRequestID() {
        return this.requestID;
    }

    public String getPartID() {
        return this.partID;
    }

    public String getID() {
        return this.id;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof AtomicRequestID)) {
            return false;
        }
        AtomicRequestID atomicRequestID = (AtomicRequestID)o2;
        return !(this.id != null ? !this.id.equals(atomicRequestID.id) : atomicRequestID.id != null);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        return this.id;
    }
}

