/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.cache.connector;

import com.metamatrix.data.api.Connection;
import com.metamatrix.data.api.ConnectorCapabilities;
import com.metamatrix.data.api.ConnectorMetadata;
import com.metamatrix.data.api.Execution;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.api.ProcedureExecution;
import com.metamatrix.data.api.SynchQueryExecution;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;
import com.metamatrix.dqp.internal.cache.ResultSetCache;
import com.metamatrix.dqp.internal.cache.connector.CacheProcedureExecution;
import com.metamatrix.dqp.internal.cache.connector.CacheSynchQueryExecution;

public class CacheConnection
implements Connection {
    private Connection actualConn;
    private ResultSetCache cache;

    public CacheConnection(Connection actualConn, ResultSetCache cache) {
        this.actualConn = actualConn;
        this.cache = cache;
    }

    public ConnectorCapabilities getCapabilities() {
        return this.actualConn.getCapabilities();
    }

    public Execution createExecution(int executionMode, ExecutionContext executionContext, RuntimeMetadata metadata) throws ConnectorException {
        Execution execution = this.actualConn.createExecution(executionMode, executionContext, metadata);
        if (executionMode == 0) {
            return new CacheSynchQueryExecution((SynchQueryExecution)execution, this.cache, executionContext);
        }
        if (executionMode == 2) {
            return new CacheProcedureExecution((ProcedureExecution)execution, this.cache, executionContext);
        }
        return execution;
    }

    public ConnectorMetadata getMetadata() {
        return this.actualConn.getMetadata();
    }

    public void release() {
        this.actualConn.release();
    }
}

