/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.cache.connector;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.data.api.Batch;
import com.metamatrix.data.api.BatchedExecution;
import com.metamatrix.data.api.Execution;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.basic.BasicBatch;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.dqp.internal.cache.CacheID;
import com.metamatrix.dqp.internal.cache.CacheResults;
import com.metamatrix.dqp.internal.cache.ResultSetCache;
import java.util.HashMap;
import java.util.List;

public abstract class CacheBaseExecution {
    private static final char DELIMITER = '.';
    private Execution actualExec;
    private ResultSetCache cache;
    private CacheID cacheID;
    private int maxBatchSize;
    private int firstRow = 1;
    private boolean hasResults;
    private Object requestID;
    private String cacheScopeID;
    private boolean useResultSetCache;
    private List outParameter;
    private int outParamsterCnt;

    public CacheBaseExecution(Execution actualExec, ResultSetCache cache, ExecutionContext executionContext) {
        this.actualExec = actualExec;
        this.cache = cache;
        this.useResultSetCache = executionContext.useResultSetCache();
        if (this.useResultSetCache) {
            String scope = cache.getCacheScope();
            this.cacheScopeID = "vdb".equalsIgnoreCase(scope) ? executionContext.getVirtualDatabaseName() + '.' + executionContext.getVirtualDatabaseVersion() : executionContext.getConnectionIdentifier();
            this.requestID = executionContext.getRequestIdentifier() + '.' + executionContext.getPartIdentifier();
        }
    }

    public void close() throws ConnectorException {
        this.removeTempCacheResults();
        this.actualExec.close();
    }

    public void cancel() throws ConnectorException {
        this.removeTempCacheResults();
        this.actualExec.cancel();
    }

    public Batch nextBatch() throws ConnectorException {
        if (this.hasResults) {
            CacheResults results = this.cache.getResults(this.cacheID, new int[]{this.firstRow, this.firstRow + this.maxBatchSize - 1});
            BasicBatch batch = new BasicBatch();
            List[] rows = results.getResults();
            for (int i2 = 0; i2 < rows.length; ++i2) {
                batch.addRow(rows[i2]);
            }
            if (results.isFinal()) {
                batch.setLast();
            }
            LogManager.logTrace("DQP", new Object[]{"CacheSynchQueryExecution - returnning batch from cache, startRow =", new Integer(this.firstRow), ", endRow =", new Integer(this.firstRow + rows.length - 1)});
            this.firstRow += rows.length;
            return batch;
        }
        Batch batch = null;
        try {
            batch = ((BatchedExecution)((Object)this.actualExec)).nextBatch();
        }
        catch (ConnectorException e2) {
            this.removeTempCacheResults();
            throw e2;
        }
        if (this.useResultSetCache) {
            boolean isFinal = batch.isLast() && (this.outParameter == null || this.outParameter.isEmpty());
            CacheResults cr = new CacheResults(batch.getResults(), this.firstRow, isFinal);
            this.cache.setResults(this.cacheID, cr, this.requestID);
            this.firstRow += batch.getRowCount();
        }
        return batch;
    }

    protected boolean areResultsInCache(String command) {
        if (this.useResultSetCache) {
            this.firstRow = 1;
            this.cacheID = new CacheID(this.cacheScopeID, command);
            if (this.cache.hasResults(this.cacheID)) {
                this.hasResults = true;
                return true;
            }
        }
        return false;
    }

    protected void setMaxBatchSize(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
    }

    private void removeTempCacheResults() {
        if (this.useResultSetCache) {
            this.cache.removeTempResults(this.cacheID);
        }
    }

    protected boolean hasResults() {
        return this.hasResults;
    }

    protected void setParameters(List outParameter) {
        this.outParameter = outParameter;
    }

    protected void setOutputValue(String parameter, Object value) {
        if (this.useResultSetCache) {
            ++this.outParamsterCnt;
            HashMap<String, Object> paramValue = new HashMap<String, Object>();
            paramValue.put(parameter, value);
            CacheResults results = new CacheResults(paramValue, this.outParameter.size() == this.outParamsterCnt);
            this.cache.setResults(this.cacheID, results, this.requestID);
        }
    }

    protected Object getOutputValue(String parameter) {
        CacheResults results = this.cache.getResults(this.cacheID, new int[]{1, 1});
        return results.getParamValues().get(parameter);
    }
}

