/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.cache;

import com.metamatrix.common.buffer.impl.SizeUtility;
import com.metamatrix.dqp.internal.cache.CacheID;
import com.metamatrix.dqp.internal.cache.ResultSetCache;
import com.metamatrix.dqp.message.RequestMessage;

public class ResultSetCacheUtil {
    private static final char DELIMITOR = '.';

    public static CacheID createCacheID(RequestMessage request, ResultSetCache rsCache) {
        String scopeID = null;
        scopeID = "vdb".equalsIgnoreCase(rsCache.getCacheScope()) ? request.getVdbName() + '.' + request.getVdbVersion() : request.getConnectionID();
        return new CacheID(scopeID, request.getCacheCommand(), request.getParameterValues());
    }

    public static long getResultsSize(Object[] results, boolean useEstimate) {
        if (results == null || results.length == 0) {
            return 0L;
        }
        if (useEstimate) {
            Object row = results[0];
            long rowSize = SizeUtility.getSize(row);
            return rowSize * (long)results.length;
        }
        return SizeUtility.getSize(results);
    }
}

