/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.cache;

import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.common.util.Intervals;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.data.api.ValueChunk;
import com.metamatrix.dqp.DQPPlugin;
import com.metamatrix.dqp.internal.cache.CursorReceiverWindowBuffer;
import com.metamatrix.dqp.internal.cache.ResultSetCacheUtil;
import com.metamatrix.query.k.b;
import com.metamatrix.query.o.i.j;
import com.metamatrix.query.o.j.l;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CacheResults {
    private List[] results;
    private List elements;
    private b analysisRecord;
    private l command;
    private Map paramValues;
    private boolean isFinal;
    private int firstRow;
    private long size = -1L;
    private int finalRow = -1;
    private long length;
    private Map chunks;
    private CursorReceiverWindowBuffer tempResults;
    private Object requestID;

    public CacheResults(List[] results, int firstRow, boolean isFinal) {
        this(results, null, firstRow, isFinal);
    }

    public CacheResults(List[] results, List elements, int firstRow, boolean isFinal) {
        this.results = results;
        this.firstRow = firstRow;
        this.isFinal = isFinal;
        this.elements = elements;
    }

    public CacheResults(Map paramValues, boolean isFinal) {
        this.paramValues = paramValues;
        this.isFinal = isFinal;
    }

    public int getFirstRow() {
        return this.firstRow;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public List[] getResults() {
        return this.results;
    }

    public List getElements() {
        return this.elements;
    }

    public l getCommand() {
        return this.command;
    }

    public void setCommand(l command) {
        this.command = command;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public b getAnalysisRecord() {
        return this.analysisRecord;
    }

    public void setAnalysisRecord(b analysisRecord) {
        this.analysisRecord = analysisRecord;
    }

    public int getFinalRow() {
        return this.finalRow;
    }

    public void setFinalRow(int finalRow) {
        this.finalRow = finalRow;
    }

    public Map getParamValues() {
        return this.paramValues;
    }

    public void setParamValues(Map paramValues) {
        if (this.paramValues == null) {
            this.paramValues = paramValues;
        } else if (paramValues != null) {
            this.paramValues.putAll(paramValues);
        }
    }

    public CacheResults getLobChunks(Object valueID) {
        return (CacheResults)this.chunks.get(valueID);
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    boolean addResults(CacheResults cacheResults, Object requestID, Object valueID) {
        char[] chars;
        CacheResults chunkResults;
        if (valueID == null) {
            return this.addResults(cacheResults, requestID);
        }
        if (this.chunks == null) {
            this.chunks = new HashMap();
        }
        if ((chunkResults = (CacheResults)this.chunks.get(valueID)) == null) {
            chunkResults = new CacheResults(null, cacheResults.getElements(), 1, false);
            this.chunks.put(valueID, chunkResults);
        }
        if ((chars = ((ValueChunk)cacheResults.getResults()[0].get(0)).getChars()) != null) {
            this.length += (long)chars.length;
        }
        return chunkResults.addResults(cacheResults, requestID);
    }

    boolean addResults(CacheResults cacheResults, Object requestID) {
        int firstRow = cacheResults.getFirstRow() - 1;
        boolean isFinal = cacheResults.isFinal();
        List[] results = cacheResults.getResults();
        this.size += cacheResults.size;
        if (this.requestID == null) {
            if (firstRow != 0) {
                return false;
            }
            if (isFinal) {
                this.results = results;
                this.command = cacheResults.getCommand();
                this.analysisRecord = cacheResults.getAnalysisRecord();
                this.firstRow = 1;
                this.isFinal = true;
                this.finalRow = this.results.length;
                return true;
            }
            this.requestID = requestID;
            this.tempResults = new CursorReceiverWindowBuffer();
        }
        if (!requestID.equals(this.requestID)) {
            throw new IllegalStateException(DQPPlugin.Util.getString("CacheResults.Trying_to_cache_unexpected_results", this.requestID, requestID));
        }
        if (results != null && results.length > 0) {
            this.tempResults.add(new int[]{firstRow, firstRow + results.length - 1}, results);
        }
        if (isFinal) {
            if (!this.tempResults.getContents().isContiguous()) {
                throw new MetaMatrixRuntimeException(DQPPlugin.Util.getString("ResultSetCache.1"));
            }
            this.results = this.tempResults.getAllRows();
            this.command = cacheResults.getCommand();
            this.analysisRecord = cacheResults.getAnalysisRecord();
            this.paramValues = cacheResults.getParamValues();
            this.firstRow = 1;
            this.isFinal = true;
            this.finalRow = this.results.length;
            this.tempResults = null;
            this.requestID = null;
        }
        return true;
    }

    long getCurrentSize() {
        if (this.tempResults == null) {
            return 0L;
        }
        Intervals intervals = this.tempResults.getContents();
        int[] bound = intervals.getBoundingInterval();
        int totalRows = bound[1] - bound[0] + 1;
        return ResultSetCacheUtil.getResultsSize(new Object[]{this.tempResults.getRow(0)}, true) * (long)totalRows;
    }

    boolean hasAllResults() {
        if (!this.isFinal) {
            return false;
        }
        if (this.isLob()) {
            if (this.chunks == null) {
                return false;
            }
            for (int i2 = 0; i2 < this.results.length; ++i2) {
                Object valueID;
                CacheResults chunkResults;
                if (this.results[i2].size() == 0 || (chunkResults = (CacheResults)this.chunks.get(valueID = this.results[i2].get(0))) != null && chunkResults.hasAllResults()) continue;
                return false;
            }
        }
        return true;
    }

    boolean isLob() {
        if (this.elements != null && this.elements.size() == 1) {
            Class type = ((j)this.elements.get(0)).ag();
            return DataTypeManager.DefaultDataClasses.XML.equals(type) || DataTypeManager.DefaultDataClasses.CLOB.equals(type) || DataTypeManager.DefaultDataClasses.BLOB.equals(type);
        }
        return false;
    }
}

