/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.embedded.services;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.application.ApplicationEnvironment;
import com.metamatrix.common.application.exception.ApplicationInitializationException;
import com.metamatrix.common.application.exception.ApplicationLifecycleException;
import com.metamatrix.common.vdb.api.VDBStream;
import com.metamatrix.dqp.embedded.services.EmbeddedBaseDQPService;
import com.metamatrix.dqp.service.ConfigurationService;
import com.metamatrix.dqp.service.DQPServiceRegistry;
import com.metamatrix.dqp.service.MetadataService;
import com.metamatrix.dqp.service.VDBLifeCycleListener;
import com.metamatrix.dqp.service.VDBService;
import com.metamatrix.dqp.service.metadata.IndexSelectorSource;
import com.metamatrix.dqp.service.metadata.QueryMetadataCache;
import com.metamatrix.modeler.core.index.IndexSelector;
import com.metamatrix.query.m.e;
import java.util.Properties;

public class EmbeddedMetadataService
extends EmbeddedBaseDQPService
implements MetadataService,
IndexSelectorSource {
    private QueryMetadataCache metadataCache = null;

    public EmbeddedMetadataService(DQPServiceRegistry svcRegistry) throws MetaMatrixComponentException {
        super("dqp.metadata", svcRegistry);
    }

    public void initializeService(Properties properties) throws ApplicationInitializationException {
        try {
            ConfigurationService configSvc = this.getConfigurationService();
            this.metadataCache = new QueryMetadataCache(configSvc.getSystemVdb());
            configSvc.register(new VDBLifeCycleListener(){

                public void loaded(String vdbName, String vdbVersion) {
                }

                public void unloaded(String vdbName, String vdbVersion) {
                    EmbeddedMetadataService.this.metadataCache.removeFromCache(vdbName, vdbVersion);
                }
            });
        }
        catch (MetaMatrixComponentException e2) {
            throw new ApplicationInitializationException(e2);
        }
    }

    public void startService(ApplicationEnvironment environment) throws ApplicationLifecycleException {
        this.metadataCache.shareIncrement();
    }

    public void bindService() throws ApplicationLifecycleException {
    }

    public void unbindService() throws ApplicationLifecycleException {
    }

    public void stopService() throws ApplicationLifecycleException {
        this.metadataCache.shareDecrement();
        this.metadataCache.clearCache();
    }

    public e lookupMetadata(String vdbName, String vdbVersion) throws MetaMatrixComponentException {
        e qmi = this.metadataCache.lookupMetadata(vdbName, vdbVersion);
        if (qmi == null) {
            VDBStream vdbStream = ((VDBService)this.lookupService("dqp.vdb")).getVDBResource(vdbName, vdbVersion);
            if (vdbStream != null) {
                return this.metadataCache.lookupMetadata(vdbName, vdbVersion, vdbStream.toByteArray());
            }
            return null;
        }
        return qmi;
    }

    public IndexSelector getIndexSelector(String vdbName, String vdbVersion) throws MetaMatrixComponentException {
        return this.metadataCache.getCompositeSelector(vdbName, vdbVersion);
    }
}

