/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.embedded.services;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.application.ApplicationEnvironment;
import com.metamatrix.common.application.ApplicationService;
import com.metamatrix.common.application.exception.ApplicationInitializationException;
import com.metamatrix.common.application.exception.ApplicationLifecycleException;
import com.metamatrix.common.vdb.api.VDBDefn;
import com.metamatrix.dqp.service.ConfigurationService;
import com.metamatrix.dqp.service.DQPServiceRegistry;
import com.metamatrix.dqp.service.DataService;
import com.metamatrix.dqp.service.VDBService;
import java.util.Properties;

public abstract class EmbeddedBaseDQPService
implements ApplicationService {
    public static final String SYSTEM_PHYSICAL_MODEL_NAME = "SystemPhysical";
    private DQPServiceRegistry svcRegistry = null;
    private boolean started = false;
    private boolean bound = false;
    private boolean initialized = false;

    public EmbeddedBaseDQPService(String serviceName, DQPServiceRegistry svcRegistry) throws MetaMatrixComponentException {
        this.svcRegistry = svcRegistry;
        svcRegistry.registerService(serviceName, this);
    }

    public final void initialize(Properties props) throws ApplicationInitializationException {
        if (!this.initialized) {
            this.initialized = true;
            this.initializeService(props);
        }
    }

    public abstract void initializeService(Properties var1) throws ApplicationInitializationException;

    public final void start(ApplicationEnvironment environment) throws ApplicationLifecycleException {
        if (!this.started) {
            this.started = true;
            this.startService(environment);
        }
    }

    public abstract void startService(ApplicationEnvironment var1) throws ApplicationLifecycleException;

    public final void bind() throws ApplicationLifecycleException {
        if (!this.bound) {
            this.bound = true;
            this.bindService();
        }
    }

    public abstract void bindService() throws ApplicationLifecycleException;

    public final void unbind() throws ApplicationLifecycleException {
        if (this.bound) {
            this.bound = false;
            this.unbindService();
        }
    }

    public abstract void unbindService() throws ApplicationLifecycleException;

    public final void stop() throws ApplicationLifecycleException {
        if (this.started) {
            this.started = false;
            this.stopService();
        }
    }

    public abstract void stopService() throws ApplicationLifecycleException;

    protected ApplicationService lookupService(String serviceName) throws MetaMatrixComponentException {
        return this.svcRegistry.lookupService(serviceName);
    }

    protected ConfigurationService getConfigurationService() throws MetaMatrixComponentException {
        return (ConfigurationService)this.lookupService("dqp.configuration");
    }

    protected DataService getDataService() throws MetaMatrixComponentException {
        return (DataService)this.lookupService("dqp.data");
    }

    protected VDBService getVDBService() throws MetaMatrixComponentException {
        return (VDBService)this.lookupService("dqp.vdb");
    }

    protected final boolean isStarted() {
        return this.started;
    }

    protected final boolean isBound() {
        return this.bound;
    }

    protected String vdbId(VDBDefn vdb) {
        return this.vdbId(vdb.getName(), vdb.getVersion());
    }

    protected String vdbId(String name, String version) {
        return name.toUpperCase() + "_" + version;
    }
}

