/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.embedded.configuration;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.protocol.URLHelper;
import com.metamatrix.common.util.ByteArrayHelper;
import com.metamatrix.common.vdb.api.VDBDefn;
import com.metamatrix.core.util.ObjectConverterUtil;
import com.metamatrix.dqp.embedded.DQPEmbeddedPlugin;
import com.metamatrix.vdb.edit.loader.VDBReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class VDBConfigurationReader {
    private static final String VDB = ".vdb";
    private static final String DEF = ".def";

    public static VDBDefn loadVDB(String name, char[] defContents, byte[] vdbContents) throws MetaMatrixComponentException {
        try {
            return VDBReader.loadVDBDefn(name, vdbContents, defContents);
        }
        catch (Exception e2) {
            throw new MetaMatrixComponentException(e2);
        }
    }

    public static VDBDefn loadVDB(String name, byte[] vdbContents) throws MetaMatrixComponentException {
        try {
            return VDBReader.loadVDBDefn(name, vdbContents, null);
        }
        catch (Exception e2) {
            throw new MetaMatrixComponentException(e2);
        }
    }

    public static VDBDefn loadVDB(URL vdbURL) throws MetaMatrixComponentException {
        String vdblocation = vdbURL.toString().toLowerCase();
        if (vdblocation.endsWith(VDB) || vdblocation.endsWith(DEF)) {
            try {
                InputStream in;
                char[] defContents = null;
                if (vdblocation.endsWith(DEF)) {
                    in = vdbURL.openStream();
                    defContents = ObjectConverterUtil.convertToCharArray(in, -1, null);
                    in.close();
                    VDBDefn dummy = VDBReader.loadVDBDefn(null, new byte[0], defContents);
                    String vdbName = dummy.getFileName();
                    vdbURL = URLHelper.buildURL((URL)vdbURL, (String)vdbName);
                }
                in = vdbURL.openStream();
                byte[] vdbContents = ByteArrayHelper.toByteArray(in);
                in.close();
                VDBDefn vdb = VDBReader.loadVDBDefn(null, vdbContents, defContents);
                if (vdb.doesVDBHaveValidityError()) {
                    String[] errors = vdb.getVDBValidityErrors();
                    StringBuffer sb = new StringBuffer();
                    for (int i2 = 0; i2 < errors.length; ++i2) {
                        sb.append("-").append(errors[i2]).append(";");
                    }
                    DQPEmbeddedPlugin.logError("VDBReader.validityErrors", new Object[]{vdbURL, sb});
                }
                return vdb;
            }
            catch (Exception e2) {
                DQPEmbeddedPlugin.logWarning("VDBReader.Archive_not_Found", new Object[]{vdbURL});
                throw new MetaMatrixComponentException(e2);
            }
        }
        throw new MetaMatrixComponentException(DQPEmbeddedPlugin.Util.getString("VDBReader.Invalid_location", vdbURL));
    }

    public static boolean isDEFFileIncluded(URL vdbURL) throws MetaMatrixComponentException {
        try {
            InputStream in = vdbURL.openStream();
            byte[] vdbContents = ByteArrayHelper.toByteArray(in);
            in.close();
            return VDBReader.isValidVDBDefFileIncluded(vdbContents);
        }
        catch (Exception e2) {
            DQPEmbeddedPlugin.logWarning("VDBReader.Archive_not_Found", new Object[]{vdbURL});
            throw new MetaMatrixComponentException(e2);
        }
    }

    public static HashMap loadVDBS(URL[] urls) throws MetaMatrixComponentException {
        HashMap<URL, VDBDefn> vdbs = new HashMap<URL, VDBDefn>();
        ArrayList<URL> vdbURLs = new ArrayList<URL>();
        for (int i2 = 0; i2 < urls.length; ++i2) {
            String vdblocation = urls[i2].toString().toLowerCase();
            if (vdblocation.endsWith(VDB) || vdblocation.endsWith(DEF)) {
                vdbURLs.add(urls[i2]);
                continue;
            }
            vdbURLs.addAll(VDBConfigurationReader.getVDBResources(urls[i2]));
        }
        Iterator i3 = vdbURLs.iterator();
        while (i3.hasNext()) {
            URL vdbURL = (URL)i3.next();
            VDBDefn vdb = VDBConfigurationReader.loadVDB(vdbURL);
            if (vdb.doesVDBHaveValidityError()) continue;
            vdbs.put(vdbURL, vdb);
        }
        return vdbs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static List getVDBResources(URL vdbRepositoryURL) throws MetaMatrixComponentException {
        ArrayList<URL> arrayList;
        ObjectInputStream in = null;
        ArrayList<URL> urlList = new ArrayList<URL>();
        String vdblocation = vdbRepositoryURL.toString() + "?action=list&filter=.vdb,.def";
        try {
            try {
                vdbRepositoryURL = URLHelper.buildURL((String)vdblocation);
                in = new ObjectInputStream(vdbRepositoryURL.openStream());
                String[] urls = (String[])in.readObject();
                for (int i2 = 0; i2 < urls.length; ++i2) {
                    boolean add = true;
                    URL vdbFileURL = URLHelper.buildURL((String)urls[i2]);
                    if (!add) continue;
                    urlList.add(vdbFileURL);
                }
                arrayList = urlList;
                Object var9_10 = null;
                if (in == null) return arrayList;
            }
            catch (Exception e3) {
                throw new MetaMatrixComponentException(e3);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e2) {
                throw throwable;
            }
        }
        try {}
        catch (IOException e2) {
            // empty catch block
            return arrayList;
        }
        in.close();
        return arrayList;
    }
}

