/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.embedded.configuration;

import com.metamatrix.common.classloader.NonDelegatingClassLoader;
import com.metamatrix.common.protocol.MetaMatrixURLStreamHandlerFactory;
import com.metamatrix.dqp.embedded.DQPEmbeddedPlugin;
import com.metamatrix.query.function.e;
import com.metamatrix.query.function.k.d;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.util.Collection;

public class UDFSource
implements e {
    private Collection functionMethods;
    private URL udfFile = null;
    private URL[] classpath = null;
    private ClassLoader classLoader = null;

    public UDFSource(URL url) {
        this.udfFile = url;
    }

    public UDFSource(URL url, URL[] classpath) {
        this.udfFile = url;
        this.classpath = classpath;
    }

    public Collection getFunctionMethods() {
        if (this.functionMethods == null) {
            this.reloadMethods();
        }
        return this.functionMethods;
    }

    public Class getInvocationClass(String className) throws ClassNotFoundException {
        if (this.classpath == null || this.classpath.length == 0) {
            return Class.forName(className);
        }
        if (this.classLoader == null) {
            this.classLoader = new NonDelegatingClassLoader(this.classpath, Thread.currentThread().getContextClassLoader(), (URLStreamHandlerFactory)new MetaMatrixURLStreamHandlerFactory());
        }
        return this.classLoader.loadClass(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void reloadMethods() {
        InputStream in = null;
        in = this.udfFile.openStream();
        this.functionMethods = d.b(in);
        Object var4_2 = null;
        if (in == null) return;
        try {
            in.close();
            return;
        }
        catch (IOException e2) {}
        return;
        {
            catch (IOException e3) {
                DQPEmbeddedPlugin.logError(e3, "UDFSource.failed_to_read", new Object[]{this.udfFile});
                Object var4_3 = null;
                if (in == null) return;
                try {
                    in.close();
                    return;
                }
                catch (IOException e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }
}

