/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.embedded.configuration;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.config.api.ComponentDefnID;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.ConnectorBindingType;
import com.metamatrix.common.config.model.BasicConfiguration;
import com.metamatrix.common.config.model.BasicConfigurationObjectEditor;
import com.metamatrix.common.config.model.BasicServiceComponentDefn;
import com.metamatrix.common.config.model.ConfigurationModelContainerAdapter;
import com.metamatrix.common.config.model.ConfigurationModelContainerImpl;
import com.metamatrix.common.protocol.URLHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;

public class ServerConfigFileWriter {
    private static final String QUERY_SERVICE = "QueryService";

    public static char[] writeToCharArray(ConfigurationModelContainer model) throws MetaMatrixComponentException {
        try {
            ConfigurationModelContainerAdapter configAdapter = new ConfigurationModelContainerAdapter();
            ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
            configAdapter.writeConfigurationModel(bos, model, "DQP");
            char[] contents = bos.toString().toCharArray();
            bos.close();
            return contents;
        }
        catch (Exception e2) {
            throw new MetaMatrixComponentException(e2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void write(ConfigurationModelContainer model, URL configFileURL) throws MetaMatrixComponentException {
        ConfigurationModelContainerAdapter configAdapter = new ConfigurationModelContainerAdapter();
        OutputStream out = null;
        try {
            try {
                String configFile = configFileURL.toString() + "?action=write";
                configFileURL = URLHelper.buildURL((String)configFile);
                out = configFileURL.openConnection().getOutputStream();
                configAdapter.writeConfigurationModel(out, model, "DQP");
            }
            catch (Exception e3) {
                throw new MetaMatrixComponentException(e3);
            }
            Object var6_6 = null;
            if (out == null) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (out == null) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e2) {}
        out.close();
        return;
    }

    public static ConfigurationModelContainer addConnectorBinding(ConfigurationModelContainer model, ConnectorBinding binding) throws MetaMatrixComponentException {
        ConfigurationModelContainerImpl config = (ConfigurationModelContainerImpl)model;
        ((BasicConfiguration)config.getConfiguration()).addComponentDefn(binding);
        return config;
    }

    public static ConfigurationModelContainer deleteConnectorBinding(ConfigurationModelContainer model, ConnectorBinding binding) throws MetaMatrixComponentException {
        ConfigurationModelContainerImpl config = (ConfigurationModelContainerImpl)model;
        ((BasicConfiguration)config.getConfiguration()).removeComponentObject((ComponentDefnID)binding.getID());
        return config;
    }

    public static ConfigurationModelContainer addConnectorType(ConfigurationModelContainer model, ConnectorBindingType type) throws MetaMatrixComponentException {
        ConfigurationModelContainerImpl config = (ConfigurationModelContainerImpl)model;
        config.addComponentType(type);
        return config;
    }

    public static ConfigurationModelContainer deleteConnectorType(ConfigurationModelContainer model, ConnectorBindingType type) throws MetaMatrixComponentException {
        ConfigurationModelContainerImpl config = (ConfigurationModelContainerImpl)model;
        config.remove(type.getID());
        return config;
    }

    public static ConfigurationModelContainer addProperty(ConfigurationModelContainer model, String propertyName, String propertyValue) throws MetaMatrixComponentException {
        BasicServiceComponentDefn component = (BasicServiceComponentDefn)model.getConfiguration().getServiceComponentDefn(QUERY_SERVICE);
        BasicConfigurationObjectEditor editor = new BasicConfigurationObjectEditor();
        Properties currentProperties = component.getProperties();
        currentProperties.put(propertyName, propertyValue);
        editor.modifyProperties(component, currentProperties, 0);
        return model;
    }

    public static ConfigurationModelContainer addProperties(ConfigurationModelContainer model, Properties properties) throws MetaMatrixComponentException {
        BasicServiceComponentDefn component = (BasicServiceComponentDefn)model.getConfiguration().getServiceComponentDefn(QUERY_SERVICE);
        BasicConfigurationObjectEditor editor = new BasicConfigurationObjectEditor();
        Properties currentProperties = component.getProperties();
        currentProperties.putAll((Map<?, ?>)properties);
        editor.modifyProperties(component, currentProperties, 0);
        return model;
    }
}

