/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.embedded.configuration;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.config.api.ExtensionModule;
import com.metamatrix.common.config.model.BasicExtensionModule;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.protocol.URLHelper;
import com.metamatrix.common.util.ByteArrayHelper;
import com.metamatrix.dqp.embedded.DQPEmbeddedPlugin;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class ExtensionModuleReader {
    private static final String MM_JAR_PROTOCOL = "extensionjar";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ExtensionModule loadExtensionModule(String extModuleName, URL extModuleURL) throws MetaMatrixComponentException {
        byte[] contents = null;
        InputStream in = null;
        try {
            try {
                in = extModuleURL.openStream();
                contents = ByteArrayHelper.toByteArray(in);
            }
            catch (FileNotFoundException e3) {
                throw new MetaMatrixComponentException(DQPEmbeddedPlugin.Util.getString("ExtensionModuleReader.ext_module_does_not_exist", new String[]{extModuleName}));
            }
            catch (IOException e4) {
                throw new MetaMatrixComponentException((Throwable)e4, DQPEmbeddedPlugin.Util.getString("ExtensionModuleReader.ext_module_failed_to_read", new String[]{extModuleName}));
            }
            Object var6_4 = null;
            if (in == null) return new BasicExtensionModule(extModuleName, "JAR File", "Jar File", contents);
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e2) {}
        in.close();
        return new BasicExtensionModule(extModuleName, "JAR File", "Jar File", contents);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List loadExtensionModules(URL extensionPathURL) throws MetaMatrixComponentException {
        ObjectInputStream in = null;
        ArrayList<BasicExtensionModule> extModuleList = new ArrayList<BasicExtensionModule>();
        String extensionPath = extensionPathURL.toString() + "?action=list&filter=.jar";
        extensionPathURL = URLHelper.buildURL((String)extensionPath);
        in = new ObjectInputStream(extensionPathURL.openStream());
        String[] jarFiles = (String[])in.readObject();
        for (int i2 = 0; i2 < jarFiles.length; ++i2) {
            String jarName = jarFiles[i2];
            jarName = jarName.substring(jarName.lastIndexOf(47) + 1);
            byte[] contents = null;
            try {
                URL jarFileURL = URLHelper.buildURL((String)jarFiles[i2]);
                InputStream jarStream = jarFileURL.openStream();
                contents = ByteArrayHelper.toByteArray(jarStream);
                jarStream.close();
            }
            catch (IOException e2) {
                throw new MetaMatrixComponentException((Throwable)e2, DQPEmbeddedPlugin.Util.getString("ExtensionModuleReader.ext_module_failed_to_read", new Object[]{jarFiles[i2]}));
            }
            extModuleList.add(new BasicExtensionModule(jarName, "JAR File", "Jar File", contents));
        }
        Object var11_13 = null;
        if (in == null) return extModuleList;
        try {
            in.close();
            return extModuleList;
        }
        catch (IOException e3) {}
        return extModuleList;
        {
            catch (FileNotFoundException e4) {
                Object var11_14 = null;
                if (in == null) return extModuleList;
                try {
                    in.close();
                    return extModuleList;
                }
                catch (IOException e3) {}
                return extModuleList;
            }
            catch (Exception e5) {
                throw new MetaMatrixComponentException(e5);
            }
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e3) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public static URL[] resolveExtensionClasspath(String extClassPath, URL context) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        StringTokenizer st = new StringTokenizer(extClassPath, ";");
        while (st.hasMoreTokens()) {
            URL entry = null;
            String temp = st.nextToken();
            int idx = temp.indexOf(MM_JAR_PROTOCOL);
            if (idx != -1) {
                entry = URLHelper.buildURL((URL)context, (String)temp.substring(idx + MM_JAR_PROTOCOL.length() + 1));
                InputStream in = null;
                try {
                    in = entry.openStream();
                    in.close();
                }
                catch (IOException e2) {
                    LogManager.logDetail("DQP", DQPEmbeddedPlugin.Util.getString("DataService.ext_module_not_found", entry));
                }
            } else {
                entry = new URL(temp);
            }
            urls.add(entry);
        }
        return urls.toArray(new URL[urls.size()]);
    }
}

