/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.embedded.admin;

import com.metamatrix.admin.api.embedded.EmbeddedMonitoringAdmin;
import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.api.exception.AdminProcessingException;
import com.metamatrix.admin.api.objects.AdminObject;
import com.metamatrix.admin.api.objects.ConnectorBinding;
import com.metamatrix.admin.api.objects.SystemObject;
import com.metamatrix.admin.objects.MMAdminObject;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.common.comm.impl.local.LocalClientConnection;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.vdb.api.VDBDefn;
import com.metamatrix.dqp.embedded.DQPEmbeddedManager;
import com.metamatrix.dqp.embedded.DQPEmbeddedPlugin;
import com.metamatrix.dqp.embedded.admin.BaseAdmin;
import com.metamatrix.dqp.message.AdminRequestMessage;
import com.metamatrix.dqp.message.AdminResultsMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class DQPMonitoringAdminImpl
extends BaseAdmin
implements EmbeddedMonitoringAdmin {
    public DQPMonitoringAdminImpl(DQPEmbeddedManager manager) {
        super(manager);
    }

    public Collection getConnectorTypes(String identifier) throws AdminException {
        if (identifier == null || !identifier.matches("\\w*(\\s*\\w)*(\\*)?")) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_identifier"));
        }
        return super.getConnectorTypes(identifier);
    }

    public Collection getVDBs(String identifier) throws AdminException {
        if (identifier == null || !identifier.matches("\\w*(\\*)?(\\.\\d+)?")) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_identifier"));
        }
        if (identifier.indexOf(".") == -1 && identifier.indexOf("*") == -1) {
            identifier = identifier + "." + "*";
        }
        try {
            List vdbs = this.getVDBService().getAvailableVDBs();
            ArrayList<VDBDefn> matchedVdbs = new ArrayList<VDBDefn>();
            Iterator i2 = vdbs.iterator();
            while (i2.hasNext()) {
                VDBDefn vdb = (VDBDefn)i2.next();
                if (!this.matches(identifier, vdb.getName() + "." + vdb.getVersion())) continue;
                matchedVdbs.add(vdb);
            }
            return (List)this.convertToAdminObjects(matchedVdbs);
        }
        catch (MetaMatrixComponentException err) {
            this.handleSystemException(err);
        }
        catch (MetaMatrixProcessingException err) {
            this.handleProcessingException(err);
        }
        return Collections.EMPTY_LIST;
    }

    public Collection getConnectorBindings(String identifier) throws AdminException {
        if (identifier == null) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_identifier"));
        }
        return super.getConnectorBindings(identifier);
    }

    public Collection getConnectorBindingsInVDB(String identifier) throws AdminException {
        List vdbs = null;
        HashMap bindings = new HashMap();
        if (identifier == null || !identifier.matches("\\w*(\\*)?(\\.\\d+)?")) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_identifier"));
        }
        if (identifier.indexOf(".") == -1 && identifier.indexOf("*") == -1) {
            identifier = identifier + "*";
        }
        try {
            vdbs = this.getVDBService().getAvailableVDBs();
            Iterator i2 = vdbs.iterator();
            while (i2.hasNext()) {
                VDBDefn vdb = (VDBDefn)i2.next();
                if (!this.matches(identifier, vdb.getName() + "." + vdb.getVersion())) continue;
                Map connectorBindings = vdb.getConnectorBindings();
                bindings.putAll(connectorBindings);
            }
        }
        catch (MetaMatrixComponentException e2) {
            this.handleSystemException(this.unsupported);
        }
        catch (MetaMatrixProcessingException e3) {
            this.handleProcessingException(e3);
        }
        return bindings.values();
    }

    public Collection getExtensionModules(String identifier) throws AdminException {
        if (identifier == null || !identifier.matches("\\w+((\\.\\*)|(\\.\\w+)|(\\.\\w*\\*))*|\\w*(\\*){1}")) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_identifier"));
        }
        try {
            List extModules = this.getConfigurationService().getExtensionModules();
            extModules = (List)this.convertToAdminObjects(extModules);
            return this.matchedCollection(identifier, extModules);
        }
        catch (MetaMatrixComponentException e2) {
            this.handleSystemException(e2);
        }
        catch (MetaMatrixProcessingException e3) {
            this.handleProcessingException(e3);
        }
        throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.ext_path_invalid"));
    }

    public Collection getQueueWorkerPools(String identifier) throws AdminException {
        if (identifier == null || !identifier.matches("\\w*(\\s*\\w)*(\\*)?")) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_identifier"));
        }
        ArrayList results = new ArrayList();
        if (this.matches(identifier, "dqp")) {
            AdminRequestMessage msg = new AdminRequestMessage();
            msg.setRequestType(2);
            AdminResultsMessage result = (AdminResultsMessage)this.processMessage(msg);
            Collection c2 = result.getResults();
            if (c2 != null && !c2.isEmpty()) {
                results.addAll(c2);
            }
        }
        try {
            Collection bindings = super.getConnectorBindings(identifier);
            Iterator i2 = bindings.iterator();
            while (i2.hasNext()) {
                ConnectorBinding binding = (ConnectorBinding)i2.next();
                Collection c3 = this.getDataService().getConnectorBindingStatistics(binding.getName());
                if (c3 == null || c3.isEmpty()) continue;
                results.addAll(c3);
            }
        }
        catch (MetaMatrixComponentException e2) {
            this.handleSystemException(e2);
        }
        catch (MetaMatrixProcessingException e3) {
            this.handleProcessingException(e3);
        }
        if (!results.isEmpty()) {
            return (List)this.convertToAdminObjects(results);
        }
        return Collections.EMPTY_LIST;
    }

    public Collection getCaches(String identifier) throws AdminException {
        if (identifier == null || !identifier.matches("\\w*(\\*)?")) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_identifier"));
        }
        ArrayList<String> cacheList = new ArrayList<String>();
        for (int i2 = 0; i2 < cacheTypes.length; ++i2) {
            if (!this.matches(identifier, cacheTypes[i2])) continue;
            cacheList.add(cacheTypes[i2]);
        }
        return cacheList;
    }

    public Collection getSessions(String identifier) throws AdminException {
        if (identifier == null || !identifier.matches("\\d*(\\*)?")) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_identifier"));
        }
        ArrayList<LocalClientConnection> goodConections = new ArrayList<LocalClientConnection>();
        Set connections = this.getClientConnections();
        Iterator i2 = connections.iterator();
        while (i2.hasNext()) {
            LocalClientConnection connection = (LocalClientConnection)i2.next();
            if (connection.isShutdown()) continue;
            goodConections.add(connection);
        }
        return this.matchedCollection(identifier, (List)this.convertToAdminObjects(goodConections));
    }

    public Collection getRequests(String identifier) throws AdminException {
        if (identifier == null || !identifier.matches("\\d+((\\.\\*)|(\\.\\d+)|(\\.\\d*\\*))*|\\d*(\\*){1}")) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_identifier"));
        }
        AdminRequestMessage msg = new AdminRequestMessage();
        msg.setRequestType(0);
        ArrayList requestList = new ArrayList();
        AdminResultsMessage result = (AdminResultsMessage)this.processMessage(msg);
        Collection results = result.getResults();
        if (results != null && !results.isEmpty()) {
            Iterator i2 = results.iterator();
            while (i2.hasNext()) {
                Map requests = (Map)i2.next();
                requestList.addAll(requests.keySet());
            }
            return this.matchedCollection(identifier, (List)this.convertToAdminObjects(requestList));
        }
        return Collections.EMPTY_LIST;
    }

    public Collection getSourceRequests(String identifier) throws AdminException {
        if (identifier == null || !identifier.matches("\\d+((\\.\\*)|(\\.\\d+)|(\\.\\d*\\*))*|\\d*(\\*){1}")) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_identifier"));
        }
        AdminRequestMessage msg = new AdminRequestMessage();
        msg.setRequestType(0);
        ArrayList atomicRequestList = new ArrayList();
        AdminResultsMessage result = (AdminResultsMessage)this.processMessage(msg);
        Collection results = result.getResults();
        if (results != null && !results.isEmpty()) {
            Iterator i2 = results.iterator();
            while (i2.hasNext()) {
                Map requests = (Map)i2.next();
                Iterator j2 = requests.keySet().iterator();
                while (j2.hasNext()) {
                    Object key = j2.next();
                    Collection atomicRequests = (Collection)requests.get(key);
                    atomicRequestList.addAll(atomicRequests);
                }
            }
            return this.matchedCollection(identifier, (List)this.convertToAdminObjects(atomicRequestList));
        }
        return Collections.EMPTY_LIST;
    }

    public SystemObject getSystem() throws AdminException {
        return super.getSystem();
    }

    public Collection getPropertyDefinitions(String identifier, String className) throws AdminException {
        Collection adminObjects = this.getAdminObjects(identifier, className);
        if (adminObjects == null || adminObjects.size() == 0) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.No_Objects_Found", identifier, className));
        }
        if (adminObjects.size() > 1) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Multiple_Objects_Found", identifier, className));
        }
        AdminObject adminObject = (AdminObject)adminObjects.iterator().next();
        try {
            String objectIdentifier = adminObject.getIdentifier();
            ComponentType ctype = null;
            int type = MMAdminObject.getObjectType(className);
            switch (type) {
                case 19: {
                    Properties properties = this.manager.getDQPProperties();
                    return this.convertPropertyDefinitions(properties);
                }
                case 2: {
                    String ctypeName = ((ConnectorBinding)adminObject).getConnectorTypeName();
                    ctype = this.getConfigurationService().getSystemConfiguration().getComponentType(ctypeName);
                    ConnectorBinding binding = (ConnectorBinding)this.getConnectorBindings(objectIdentifier).iterator().next();
                    return this.convertPropertyDefinitions(ctype, binding.getProperties());
                }
                case 3: {
                    ctype = this.getConfigurationService().getSystemConfiguration().getComponentType(adminObject.getName());
                    return this.convertPropertyDefinitions(ctype, new Properties());
                }
            }
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Unsupported_Object_Class", className));
        }
        catch (Exception e2) {
            this.handleSystemException(e2);
            return Collections.EMPTY_LIST;
        }
    }
}

