/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.embedded.admin;

import EDU.oswego.cs.dl.util.concurrent.Slot;
import com.metamatrix.admin.api.exception.AdminComponentException;
import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.api.exception.AdminProcessingException;
import com.metamatrix.admin.api.objects.AdminObject;
import com.metamatrix.admin.api.objects.ConnectorType;
import com.metamatrix.admin.api.objects.LogConfiguration;
import com.metamatrix.admin.api.objects.Model;
import com.metamatrix.admin.api.objects.QueueWorkerPool;
import com.metamatrix.admin.api.objects.Request;
import com.metamatrix.admin.api.objects.Session;
import com.metamatrix.admin.api.objects.SystemObject;
import com.metamatrix.admin.api.objects.VDB;
import com.metamatrix.admin.objects.MMAdminObject;
import com.metamatrix.admin.objects.MMConnectorBinding;
import com.metamatrix.admin.objects.MMConnectorType;
import com.metamatrix.admin.objects.MMExtensionModule;
import com.metamatrix.admin.objects.MMLogConfiguration;
import com.metamatrix.admin.objects.MMModel;
import com.metamatrix.admin.objects.MMPropertyDefinition;
import com.metamatrix.admin.objects.MMQueueWorkerPool;
import com.metamatrix.admin.objects.MMRequest;
import com.metamatrix.admin.objects.MMSession;
import com.metamatrix.admin.objects.MMSystem;
import com.metamatrix.admin.objects.MMVDB;
import com.metamatrix.admin.util.AdminExceptionConverter;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.common.application.exception.ApplicationInitializationException;
import com.metamatrix.common.comm.api.ClientConnection;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.api.MessageListener;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ComponentTypeDefn;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.ConnectorBindingType;
import com.metamatrix.common.config.api.ExtensionModule;
import com.metamatrix.common.log.config.BasicLogConfiguration;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.common.queue.WorkerPoolStats;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.CryptoUtil;
import com.metamatrix.common.vdb.api.ModelInfo;
import com.metamatrix.common.vdb.api.VDBDefn;
import com.metamatrix.data.monitor.AliveStatus;
import com.metamatrix.dqp.application.DQP;
import com.metamatrix.dqp.config.DQPConfigSource;
import com.metamatrix.dqp.embedded.DQPEmbeddedManager;
import com.metamatrix.dqp.embedded.DQPEmbeddedPlugin;
import com.metamatrix.dqp.embedded.DataClientConnection;
import com.metamatrix.dqp.message.AtomicRequestMessage;
import com.metamatrix.dqp.message.DQPInboundMessage;
import com.metamatrix.dqp.message.RequestMessage;
import com.metamatrix.dqp.service.ConfigurationService;
import com.metamatrix.dqp.service.DataService;
import com.metamatrix.dqp.service.VDBService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;

abstract class BaseAdmin {
    static final String DOT = ".";
    static final String STAR = "*";
    static final String FILE_NAME_REGEX = "\\w+\\.\\w+";
    static final String MULTIPLE_WORDS_REGEX = "\\w+(\\s*\\w)*";
    static final String SINGLE_WORD_REGEX = "\\w+";
    static final String MULTIPLE_WORD_WILDCARD_REGEX = "\\w*(\\s*\\w)*(\\*)?";
    static final String SINGLE_WORD_WILDCARD_REGEX = "\\w*(\\*)?";
    static final String WORD_AND_DOT_WILDCARD_REGEX = "\\w+((\\.\\*)|(\\.\\w+)|(\\.\\w*\\*))*|\\w*(\\*){1}";
    static final String VDB_REGEX = "\\w*(\\*)?(\\.\\d+)?";
    static final String NUMBER_DOT_REGEX = "\\d+((\\.\\*)|(\\.\\d+)|(\\.\\d*\\*))*|\\d*(\\*){1}";
    static final String NUMBER_REGEX = "\\d*(\\*)?";
    static final String[] cacheTypes = new String[]{"CodeTableCache", "ConnectorResultSetCache", "PreparedPlanCache", "QueryServiceResultSetCache"};
    RuntimeException unsupported = new UnsupportedOperationException();
    DQPEmbeddedManager manager = null;
    AdminMessageListener adminListener = new AdminMessageListener();
    DataClientConnection adminConnection = new DataClientConnection(this.adminListener);

    BaseAdmin(DQPEmbeddedManager manager) {
        this.manager = manager;
    }

    protected void handleSystemException(Exception e2) throws AdminComponentException {
        throw AdminExceptionConverter.convertToComponentException(e2, e2.getMessage());
    }

    protected AdminException accumulateSystemException(AdminException parent, Exception e2) {
        if (parent == null) {
            return AdminExceptionConverter.convertToComponentException(e2, e2.getMessage());
        }
        parent.addChild((AdminException)AdminExceptionConverter.convertToComponentException(e2, e2.getMessage()));
        return parent;
    }

    protected void handleProcessingException(Exception e2) throws AdminProcessingException {
        throw AdminExceptionConverter.convertToProcessingException(e2, e2.getMessage());
    }

    protected AdminException accumulateProcessingException(AdminException parent, Exception e2) {
        if (parent == null) {
            return AdminExceptionConverter.convertToProcessingException(e2, e2.getMessage());
        }
        parent.addChild((AdminException)AdminExceptionConverter.convertToProcessingException(e2, e2.getMessage()));
        return parent;
    }

    protected String prettyPrintBindingNames(List bindings) {
        StringBuffer buffer = new StringBuffer();
        Iterator iter = bindings.iterator();
        while (iter.hasNext()) {
            ConnectorBinding binding = (ConnectorBinding)iter.next();
            buffer.append(binding.getName());
            if (!iter.hasNext()) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    public DQPEmbeddedManager getManager() {
        return this.manager;
    }

    public DQPConfigSource getDQPConfig() {
        return this.manager.getDQPConfig();
    }

    VDBService getVDBService() throws MetaMatrixProcessingException {
        try {
            return (VDBService)this.getDQPConfig().getService("dqp.vdb");
        }
        catch (ApplicationInitializationException e2) {
            throw new MetaMatrixProcessingException((Throwable)e2, DQPEmbeddedPlugin.Util.getString("Failed_To_Service"));
        }
    }

    DataService getDataService() throws MetaMatrixProcessingException {
        try {
            return (DataService)this.getDQPConfig().getService("dqp.data");
        }
        catch (ApplicationInitializationException e2) {
            throw new MetaMatrixProcessingException((Throwable)e2, DQPEmbeddedPlugin.Util.getString("Failed_To_Service"));
        }
    }

    ConfigurationService getConfigurationService() throws MetaMatrixProcessingException {
        try {
            return (ConfigurationService)this.getDQPConfig().getService("dqp.configuration");
        }
        catch (ApplicationInitializationException e2) {
            throw new MetaMatrixProcessingException((Throwable)e2, DQPEmbeddedPlugin.Util.getString("Failed_To_Service"));
        }
    }

    protected Object convertToAdminObjects(Object src) {
        return this.convertToAdminObjects(src, null);
    }

    protected Object convertToAdminObjects(Object src, Object parent) {
        if (src == null) {
            return src;
        }
        if (src != null && src instanceof List) {
            ArrayList<Object> modified = new ArrayList<Object>();
            List list = (List)src;
            Iterator i2 = list.iterator();
            while (i2.hasNext()) {
                Object e2 = i2.next();
                Object converted = this.convertToAdminObject(e2, parent);
                modified.add(converted);
            }
            return modified;
        }
        if (src != null && src instanceof Collection) {
            ArrayList<Object> modified = new ArrayList<Object>();
            Iterator i3 = ((Collection)src).iterator();
            while (i3.hasNext()) {
                Object e3 = i3.next();
                Object converted = this.convertToAdminObject(e3, parent);
                modified.add(converted);
            }
            return modified;
        }
        if (src != null && src instanceof Object[]) {
            ArrayList<Object> modified = new ArrayList<Object>();
            Object[] srcArray = (Object[])src;
            for (int i4 = 0; i4 < srcArray.length; ++i4) {
                Object converted = this.convertToAdminObject(srcArray[i4], parent);
                modified.add(converted);
            }
            return modified;
        }
        return this.convertToAdminObject(src, parent);
    }

    private Object convertToAdminObject(Object src, Object parent) {
        if (src != null && src instanceof ConnectorBinding) {
            ConnectorBinding binding = (ConnectorBinding)src;
            return this.convertConnectorType(binding, parent);
        }
        if (src != null && src instanceof ConnectorBindingType) {
            ConnectorBindingType type = (ConnectorBindingType)src;
            return this.convertConnectorType(type, parent);
        }
        if (src != null && src instanceof VDBDefn) {
            VDBDefn vdb = (VDBDefn)src;
            return this.convertVDB(vdb, parent);
        }
        if (src != null && src instanceof ModelInfo) {
            ModelInfo model = (ModelInfo)src;
            return this.convertModel(model, parent);
        }
        if (src != null && src instanceof com.metamatrix.common.log.LogConfiguration) {
            com.metamatrix.common.log.LogConfiguration config = (com.metamatrix.common.log.LogConfiguration)src;
            return this.covertLogConfiguration(config);
        }
        if (src != null && src instanceof RequestMessage) {
            RequestMessage request = (RequestMessage)src;
            return this.convertRequest(request);
        }
        if (src != null && src instanceof WorkerPoolStats) {
            WorkerPoolStats stats = (WorkerPoolStats)src;
            return this.convertStats(stats);
        }
        if (src != null && src instanceof ClientConnection) {
            ClientConnection conn = (ClientConnection)src;
            return this.convertConnection(conn);
        }
        if (src != null && src instanceof ExtensionModule) {
            ExtensionModule extModule = (ExtensionModule)src;
            return this.convertExtensionModule(extModule);
        }
        throw new UnsupportedOperationException(DQPEmbeddedPlugin.Util.getString("UnSupported_object_conversion"));
    }

    Object convertToNativeObjects(Object src) {
        if (src instanceof LogConfiguration) {
            LogConfiguration config = (LogConfiguration)src;
            return this.covertLogConfiguration(config);
        }
        throw new UnsupportedOperationException(DQPEmbeddedPlugin.Util.getString("UnSupported_object_conversion"));
    }

    private com.metamatrix.admin.api.objects.ExtensionModule convertExtensionModule(ExtensionModule src) {
        MMExtensionModule module = new MMExtensionModule(new String[]{src.getFullName()});
        module.setDescription(src.getDescription());
        module.setFileContents(src.getFileContents());
        module.setModuleType(src.getModuleType());
        return module;
    }

    private Session convertConnection(ClientConnection src) {
        MMSession session = new MMSession(new String[]{(String)src.getConnectionProperty("connectionID")});
        session.setVDBName((String)src.getConnectionProperty("vdbName"));
        session.setVDBVersion((String)src.getConnectionProperty("vdbVersion"));
        return session;
    }

    private QueueWorkerPool convertStats(WorkerPoolStats src) {
        MMQueueWorkerPool pool = new MMQueueWorkerPool(new String[]{src.name});
        pool.setDeployed(true);
        pool.setRegistered(true);
        pool.setDequeues(src.dequeues);
        pool.setEnqueues(src.enqueues);
        pool.setHighwaterMark(src.highwaterMark);
        pool.setQueued(src.queued);
        pool.setThreads(src.threads);
        pool.setTotalDequeues(src.totalDequeues);
        pool.setTotalEnqueues(src.totalEnqueues);
        pool.setTotalHighwaterMark(src.totalHighwaterMark);
        return pool;
    }

    private LogConfiguration covertLogConfiguration(com.metamatrix.common.log.LogConfiguration src) {
        MMLogConfiguration log = new MMLogConfiguration();
        log.setDiscardedContexts(src.getDiscardedContexts());
        log.setLogLevel(src.getMessageLevel());
        return log;
    }

    private com.metamatrix.common.log.LogConfiguration covertLogConfiguration(LogConfiguration src) {
        return new BasicLogConfiguration(src.getDiscardedContexts(), src.getLogLevel());
    }

    private com.metamatrix.admin.api.objects.ConnectorBinding convertConnectorType(ConnectorBinding src, Object parent) {
        MMConnectorBinding binding = new MMConnectorBinding(new String[]{src.getName()});
        binding.setConnectorTypeName(src.getComponentTypeID().getFullName());
        binding.setCreated(src.getCreatedDate());
        binding.setCreatedBy(src.getCreatedBy());
        binding.setDeployed(src.isEnabled());
        binding.setDescription(src.getDescription());
        binding.setEnabled(src.isEnabled());
        binding.setLastUpdated(src.getLastChangedDate());
        binding.setLastUpdatedBy(src.getLastChangedBy());
        binding.setProcessID(0L);
        binding.setProperties(src.getProperties());
        binding.setRegistered(true);
        binding.setRoutingUUID(src.getRoutingUUID());
        binding.setServiceID(0L);
        try {
            AliveStatus status = this.getDataService().getConnectorBindingState(src.getName());
            if (status == AliveStatus.ALIVE) {
                binding.setState(1);
            } else if (status == AliveStatus.DEAD) {
                binding.setState(2);
            } else {
                binding.setState(6);
            }
        }
        catch (Exception e2) {
            binding.setState(6);
        }
        binding.setStateChangedTime(src.getLastChangedDate());
        return binding;
    }

    private ConnectorType convertConnectorType(ConnectorBindingType src, Object parent) {
        MMConnectorType type = new MMConnectorType(new String[]{src.getName()});
        type.setCreated(src.getCreatedDate());
        type.setCreatedBy(src.getCreatedBy());
        type.setDeployed(src.isDeployable());
        type.setEnabled(true);
        type.setLastUpdated(src.getLastChangedDate());
        type.setRegistered(true);
        return type;
    }

    private VDB convertVDB(VDBDefn src, Object parent) {
        MMVDB vdb = new MMVDB(new String[]{src.getName(), src.getVersion()});
        vdb.setCreated(src.getDateCreated());
        vdb.setCreatedBy(src.getCreatedBy());
        vdb.setDeployed(src.isActiveStatus());
        vdb.setEnabled(src.isActiveStatus());
        vdb.setLastUpdated(src.getDateCreated());
        vdb.setLastUpdatedBy(src.getCreatedBy());
        vdb.setMaterializedViews(src.getMatertializationModel() != null);
        vdb.setModels((Collection)this.convertToAdminObjects(src.getModels(), src));
        vdb.setProperties(null);
        vdb.setRegistered(true);
        vdb.setStatus(src.getStatus());
        vdb.setUID(0L);
        vdb.setVersionedBy(src.getCreatedBy());
        vdb.setVersionedDate(src.getDateCreated());
        return vdb;
    }

    private Model convertModel(ModelInfo src, Object parent) {
        List bindings;
        VDBDefn vdb = (VDBDefn)parent;
        MMModel model = new MMModel(new String[]{src.getName()});
        model.setCreated(vdb.getDateCreated());
        model.setCreatedBy(vdb.getCreatedBy());
        model.setDeployed(vdb.isActiveStatus());
        model.setEnabled(vdb.isActiveStatus());
        model.setLastUpdated(vdb.getDateCreated());
        model.setLastUpdatedBy(vdb.getCreatedBy());
        model.setModelType(src.getModelTypeName());
        model.setModelURI(src.getModelURI());
        model.setMaterialization(src.isMaterialization());
        model.setPhysical(src.isPhysical());
        model.setRegistered(true);
        model.setSupportsMultiSourceBindings(src.isMultiSourceBindingEnabled());
        model.setVisible(src.isVisible());
        if (src.isPhysical() && (bindings = src.getConnectorBindingNames()) != null && !bindings.isEmpty()) {
            ArrayList<ConnectorBinding> names = new ArrayList<ConnectorBinding>();
            for (int i2 = 0; i2 < bindings.size(); ++i2) {
                names.add(vdb.getConnectorBindingByName((String)bindings.get(i2)));
            }
            model.setConnectorBindingNames(names);
        }
        return model;
    }

    private Request convertRequest(RequestMessage src) {
        ClientConnection conn = src.getClientConnection();
        String connId = (String)conn.getConnectionProperty("connectionID");
        MMRequest request = null;
        request = src instanceof AtomicRequestMessage ? new MMRequest(new String[]{connId, String.valueOf(src.getRequestID().getExecutionID()), String.valueOf(((AtomicRequestMessage)src).getNodeID())}) : new MMRequest(new String[]{connId, String.valueOf(src.getRequestID().getExecutionID())});
        request.setSqlCommand(src.getCommand().toString());
        if (src.getTransactionXid() != null) {
            request.setTransactionID(src.getTransactionXid().toString());
        }
        if (src.getUserName() != null) {
            request.setUserName(src.getUserName());
        }
        request.setCreated(src.getProcessingTimestamp());
        if (src instanceof AtomicRequestMessage) {
            request.setSource(true);
            request.setNodeID(String.valueOf(((AtomicRequestMessage)src).getNodeID()));
        }
        return request;
    }

    ClientConnection getClientConnection(String identifier) throws AdminException {
        try {
            Set connections = this.getConfigurationService().getClientConnections();
            Iterator i2 = connections.iterator();
            while (i2.hasNext()) {
                ClientConnection clientConnection = (ClientConnection)i2.next();
                String id = (String)clientConnection.getConnectionProperty("connectionID");
                if (!id.equals(identifier)) continue;
                return clientConnection;
            }
        }
        catch (MetaMatrixProcessingException e2) {
            this.handleSystemException(e2);
        }
        return null;
    }

    Set getClientConnections() throws AdminException {
        try {
            return this.getConfigurationService().getClientConnections();
        }
        catch (MetaMatrixProcessingException e2) {
            this.handleSystemException(e2);
            return null;
        }
    }

    Message processMessage(Message message) throws AdminException {
        try {
            DQPInboundMessage dqpMessage;
            ClientConnection connection;
            DQP dqp = this.manager.getDQP();
            if (message instanceof DQPInboundMessage && (connection = (dqpMessage = (DQPInboundMessage)message).getClientConnection()) != null) {
                return dqp.receive(connection, message);
            }
            return dqp.receive(this.adminConnection, message);
        }
        catch (Exception e2) {
            this.handleSystemException(e2);
            return null;
        }
    }

    boolean matches(String regEx, String value) {
        regEx = regEx.replaceAll("\\*", ".*");
        regEx = regEx.replaceAll(AdminObject.ESCAPED_DELIMITER, "");
        return value.matches(regEx);
    }

    List matchedCollection(String identifier, List adminObjects) {
        ArrayList<AdminObject> matched = new ArrayList<AdminObject>();
        Iterator i2 = adminObjects.iterator();
        while (i2.hasNext()) {
            AdminObject aObj = (AdminObject)i2.next();
            if (!this.matches(identifier, aObj.getName()) && !this.matches(identifier, aObj.getIdentifier())) continue;
            matched.add(aObj);
        }
        return matched;
    }

    Collection getConnectorBindings(String identifier) throws AdminException {
        try {
            List connectorBindings = this.getDataService().getConnectorBindings();
            connectorBindings = (List)this.convertToAdminObjects(connectorBindings);
            return this.matchedCollection(identifier, connectorBindings);
        }
        catch (MetaMatrixComponentException e2) {
            this.handleSystemException(e2);
        }
        catch (MetaMatrixProcessingException e3) {
            this.handleProcessingException(e3);
        }
        return Collections.EMPTY_LIST;
    }

    Collection getConnectorTypes(String identifier) throws AdminException {
        try {
            List connectorTypes = this.getConfigurationService().getConnectorTypes();
            connectorTypes = (List)this.convertToAdminObjects(connectorTypes);
            return this.matchedCollection(identifier, connectorTypes);
        }
        catch (MetaMatrixComponentException err) {
            this.handleSystemException(err);
        }
        catch (MetaMatrixProcessingException err) {
            this.handleProcessingException(err);
        }
        return Collections.EMPTY_LIST;
    }

    public SystemObject getSystem() throws AdminException {
        MMSystem system = new MMSystem();
        system.setStartTime(new Date(this.manager.getDQPStartTime()));
        system.setStarted(this.manager.isDQPAlive());
        system.setProperties(this.manager.getDQPProperties());
        return system;
    }

    boolean isMaskedProperty(String propName, ComponentType type) {
        ComponentTypeDefn typeDef;
        return type != null && (typeDef = type.getComponentTypeDefinition(propName)) != null && typeDef.getPropertyDefinition().isMasked();
    }

    String encryptString(String value) throws AdminException {
        try {
            return new String(CryptoUtil.stringEncrypt(value.toCharArray()));
        }
        catch (CryptoException e2) {
            this.handleSystemException(e2);
            return null;
        }
    }

    protected Collection convertPropertyDefinitions(ComponentType ctype, Properties properties) {
        ArrayList<MMPropertyDefinition> results = new ArrayList<MMPropertyDefinition>();
        Iterator iter = ctype.getComponentTypeDefinitions().iterator();
        while (iter.hasNext()) {
            ComponentTypeDefn cdefn = (ComponentTypeDefn)iter.next();
            PropertyDefinition pdefn = cdefn.getPropertyDefinition();
            MMPropertyDefinition result = new MMPropertyDefinition(new String[]{pdefn.getName()});
            result.setAllowedValues(pdefn.getAllowedValues());
            result.setConstrainedToAllowedValues(pdefn.isConstrainedToAllowedValues());
            result.setDefaultValue(pdefn.getDefaultValue());
            result.setDescription(pdefn.getShortDescription());
            result.setDisplayName(pdefn.getDisplayName());
            result.setExpert(pdefn.isExpert());
            result.setHidden(pdefn.isHidden());
            result.setMasked(pdefn.isMasked());
            result.setMinimumMultiplicity(pdefn.getMultiplicity().getMinimum());
            result.setMaximumMultiplicity(pdefn.getMultiplicity().getMaximum());
            result.setModifiable(pdefn.isModifiable());
            result.setPreferred(pdefn.isPreferred());
            result.setPropertyType(pdefn.getPropertyType().getDisplayName());
            result.setPropertyTypeClassName(pdefn.getPropertyType().getClassName());
            result.setRequired(pdefn.isRequired());
            result.setRequiresRestart(pdefn.getRequiresRestart());
            result.setValueDelimiter(pdefn.getValueDelimiter());
            String value = properties.getProperty(pdefn.getName());
            result.setValue(value);
            results.add(result);
        }
        return results;
    }

    protected Collection convertPropertyDefinitions(Properties properties) {
        ArrayList<MMPropertyDefinition> results = new ArrayList<MMPropertyDefinition>();
        Iterator<Object> iter = properties.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = properties.getProperty(key);
            MMPropertyDefinition result = new MMPropertyDefinition(new String[]{key});
            result.setDisplayName(key);
            result.setValue(value);
            results.add(result);
        }
        return results;
    }

    protected Collection getAdminObjects(String identifier, String className) throws AdminException {
        int code = MMAdminObject.getObjectType(className);
        ArrayList<SystemObject> list = null;
        switch (code) {
            case 2: {
                return this.getConnectorBindings(identifier);
            }
            case 3: {
                return this.getConnectorTypes(identifier);
            }
            case 19: {
                list = new ArrayList<SystemObject>();
                list.add(this.getSystem());
                return list;
            }
        }
        throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("AdminImpl.Unsupported_Admin_Object", className));
    }

    private static class AdminMessageListener
    implements MessageListener {
        Slot slot = new Slot();

        private AdminMessageListener() {
        }

        public void deliverMessage(Message message, String messageKey) {
            try {
                this.slot.put(message);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

