/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.embedded;

import com.metamatrix.common.application.basic.BasicApplication;
import com.metamatrix.common.application.exception.ApplicationInitializationException;
import com.metamatrix.common.application.exception.ApplicationLifecycleException;
import com.metamatrix.dqp.application.ClientConnectionListener;
import com.metamatrix.dqp.application.DQP;
import com.metamatrix.dqp.config.DQPConfigSource;
import com.metamatrix.dqp.config.DQPLauncher;
import com.metamatrix.dqp.embedded.DQPEmbeddedPlugin;
import com.metamatrix.dqp.embedded.DQPListener;
import com.metamatrix.dqp.embedded.EmbeddedConfigSource;
import com.metamatrix.dqp.embedded.EmbeddedConfigUtil;
import java.net.URL;
import java.util.Date;
import java.util.Properties;

public class DQPEmbeddedManager {
    private DQPConfigSource configSource;
    private DQP dqpInstance;
    private long dqpStarttime = -1L;
    DQPListener dqpListener = null;

    public DQPEmbeddedManager(URL dqpURL, Properties connectionProperties, DQPListener listener) throws ApplicationInitializationException {
        this.configSource = new EmbeddedConfigSource(dqpURL, connectionProperties);
        this.dqpListener = listener;
    }

    public DQPConfigSource getDQPConfig() {
        return this.configSource;
    }

    public synchronized DQP createDQP(ClientConnectionListener listener) throws ApplicationInitializationException {
        if (this.dqpInstance == null) {
            DQPLauncher launcher = new DQPLauncher(this.configSource);
            this.dqpInstance = launcher.createDqp(listener);
            this.dqpStarttime = System.currentTimeMillis();
            DQPEmbeddedPlugin.logInfo("DQPEmbeddedManager.start_dqp", new Object[]{new Date(System.currentTimeMillis()).toString()});
            if (this.dqpListener != null) {
                this.dqpListener.onStart();
            }
        }
        return this.dqpInstance;
    }

    public DQP getDQP() {
        return this.dqpInstance;
    }

    public synchronized void shutdown() throws ApplicationLifecycleException {
        if (this.dqpInstance != null) {
            this.dqpInstance.stop();
            this.dqpInstance = null;
            this.configSource = null;
            this.dqpStarttime = -1L;
            if (this.dqpListener != null) {
                this.dqpListener.onShutdown();
                this.dqpListener = null;
            }
            DQPEmbeddedPlugin.logInfo("DQPEmbeddedManager.shutdown_dqp", new Object[]{new Date(System.currentTimeMillis()).toString()});
            EmbeddedConfigUtil.shutdownLogger();
        }
    }

    public long getDQPStartTime() {
        return this.dqpStarttime;
    }

    public boolean isDQPAlive() {
        return this.dqpInstance != null;
    }

    public Properties getDQPProperties() {
        if (this.isDQPAlive()) {
            return ((BasicApplication)((Object)this.dqpInstance)).getEnvironment().getApplicationProperties();
        }
        return null;
    }
}

