/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.util;

import java.util.Collection;
import java.util.Iterator;

public final class ObjectVector {
    static int INITIAL_SIZE = 10;
    public int size;
    int maxSize;
    Object[] elements;

    public ObjectVector() {
        this.maxSize = INITIAL_SIZE;
        this.size = 0;
        this.elements = new Object[this.maxSize];
    }

    public ObjectVector(int maxSize) {
        this.maxSize = maxSize;
        this.size = 0;
        this.elements = new Object[this.maxSize];
    }

    public void add(Object newElement) {
        if (this.size == this.maxSize) {
            this.elements = new Object[this.maxSize *= 2];
            System.arraycopy(this.elements, 0, this.elements, 0, this.size);
        }
        this.elements[this.size++] = newElement;
    }

    public void addAll(Object[] newElements) {
        if (this.size + newElements.length >= this.maxSize) {
            this.maxSize = this.size + newElements.length;
            this.elements = new Object[this.maxSize];
            System.arraycopy(this.elements, 0, this.elements, 0, this.size);
        }
        System.arraycopy(newElements, 0, this.elements, this.size, newElements.length);
        this.size += newElements.length;
    }

    public void addAll(ObjectVector newVector) {
        if (this.size + newVector.size >= this.maxSize) {
            this.maxSize = this.size + newVector.size;
            this.elements = new Object[this.maxSize];
            System.arraycopy(this.elements, 0, this.elements, 0, this.size);
        }
        System.arraycopy(newVector.elements, 0, this.elements, this.size, newVector.size);
        this.size += newVector.size;
    }

    public void addAll(Collection collection) {
        if (collection.isEmpty()) {
            return;
        }
        if (this.size + collection.size() >= this.maxSize) {
            this.maxSize = this.size + collection.size();
            this.elements = new Object[this.maxSize];
            System.arraycopy(this.elements, 0, this.elements, 0, this.size);
        }
        int index = this.size;
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            this.elements[index] = iter.next();
            ++index;
        }
        this.size += collection.size();
    }

    public boolean containsIdentical(Object element) {
        int i2 = this.size;
        while (--i2 >= 0) {
            if (element != this.elements[i2]) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Object element) {
        int i2 = this.size;
        while (--i2 >= 0) {
            if (!element.equals(this.elements[i2])) continue;
            return true;
        }
        return false;
    }

    public void copyInto(Object[] targetArray) {
        this.copyInto(targetArray, 0);
    }

    public void copyInto(Object[] targetArray, int index) {
        System.arraycopy(this.elements, 0, targetArray, index, this.size);
    }

    public Object elementAt(int index) {
        return this.elements[index];
    }

    public Object find(Object element) {
        int i2 = this.size;
        while (--i2 >= 0) {
            if (!element.equals(this.elements[i2])) continue;
            return element;
        }
        return null;
    }

    public Object remove(Object element) {
        int i2 = this.size;
        while (--i2 >= 0) {
            if (!element.equals(this.elements[i2])) continue;
            System.arraycopy(this.elements, i2 + 1, this.elements, i2, --this.size - i2);
            this.elements[this.size] = null;
            return element;
        }
        return null;
    }

    public void removeAll() {
        int i2 = this.size;
        while (--i2 >= 0) {
            this.elements[i2] = null;
        }
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        String s2 = "";
        for (int i2 = 0; i2 < this.size; ++i2) {
            s2 = s2 + this.elements[i2].toString() + "\n";
        }
        return s2;
    }
}

