/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.util;

import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.util.MetaMatrixNestedException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.naming.ConfigurationException;
import org.eclipse.core.runtime.CoreException;

public class MetaMatrixExceptionUtil {
    private static final Iterator EMPTY_ITERATOR = new Iterator(){

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    };

    private MetaMatrixExceptionUtil() {
    }

    public static Iterator getChildrenIterator(Throwable e2) {
        if (e2 instanceof CoreException || e2 instanceof ConfigurationException || e2 instanceof SQLException || e2 instanceof MetaMatrixNestedException) {
            return new NestedExceptionIterator(e2);
        }
        return EMPTY_ITERATOR;
    }

    public static void printNestedStackTrace(Throwable exception, PrintStream output) {
        if (exception != null) {
            exception.printStackTrace(output);
            Iterator children = MetaMatrixExceptionUtil.getChildrenIterator(exception);
            while (children.hasNext()) {
                exception = (Throwable)children.next();
                output.print(MetaMatrixRuntimeException.CAUSED_BY_STRING);
                exception.printStackTrace(output);
            }
        }
    }

    public static void printStackTrace(MetaMatrixNestedException nestedException, PrintStream output) {
        if (nestedException != null) {
            nestedException.superPrintStackTrace(output);
            Throwable exception = (Throwable)((Object)nestedException);
            Iterator children = MetaMatrixExceptionUtil.getChildrenIterator(exception);
            while (children.hasNext()) {
                exception = (Throwable)children.next();
                output.print(MetaMatrixRuntimeException.CAUSED_BY_STRING);
                if (exception instanceof MetaMatrixNestedException) {
                    ((MetaMatrixNestedException)((Object)exception)).superPrintStackTrace(output);
                    continue;
                }
                exception.printStackTrace(output);
            }
        }
    }

    public static void printStackTrace(MetaMatrixNestedException nestedException, PrintWriter output) {
        if (nestedException != null) {
            nestedException.superPrintStackTrace(output);
            Throwable exception = (Throwable)((Object)nestedException);
            Iterator children = MetaMatrixExceptionUtil.getChildrenIterator(exception);
            while (children.hasNext()) {
                exception = (Throwable)children.next();
                output.print(MetaMatrixRuntimeException.CAUSED_BY_STRING);
                if (exception instanceof MetaMatrixNestedException) {
                    ((MetaMatrixNestedException)((Object)exception)).superPrintStackTrace(output);
                    continue;
                }
                exception.printStackTrace(output);
            }
        }
    }

    public static String getFullMessage(MetaMatrixNestedException exception) {
        return MetaMatrixExceptionUtil.getLinkedMessagesVerbose((Throwable)((Object)exception), 0);
    }

    public static void printStackTrace(MetaMatrixNestedException exception) {
        MetaMatrixExceptionUtil.printStackTrace(exception, System.err);
    }

    public static String getLinkedMessagesVerbose(Throwable exception) {
        return MetaMatrixExceptionUtil.getLinkedMessagesVerbose(exception, 0);
    }

    public static String getLinkedMessagesVerbose(Throwable exception, int level) {
        if (exception != null) {
            StringBuffer buf = new StringBuffer();
            String lastMessage = MetaMatrixExceptionUtil.appendMessage("", buf, null, exception);
            Iterator children = MetaMatrixExceptionUtil.getChildrenIterator(exception);
            while (children.hasNext()) {
                ++level;
                exception = (Throwable)children.next();
                lastMessage = MetaMatrixExceptionUtil.appendMessage("->", buf, lastMessage, exception);
            }
            return buf.toString();
        }
        return "";
    }

    public static String getLinkedMessages(Throwable exception) {
        return MetaMatrixExceptionUtil.getLinkedMessages(exception, 0);
    }

    public static String getLinkedMessages(Throwable exception, int level) {
        if (exception != null) {
            StringBuffer buf = new StringBuffer();
            buf.append(exception.getMessage());
            Iterator children = MetaMatrixExceptionUtil.getChildrenIterator(exception);
            while (children.hasNext()) {
                ++level;
                exception = (Throwable)children.next();
                buf.append(exception.getMessage());
            }
            return buf.toString();
        }
        return "";
    }

    private static final String appendMessage(String prefix, StringBuffer buffer, String lastMessage, Throwable exception) {
        String message = exception.getMessage();
        buffer.append(prefix);
        buffer.append(MetaMatrixExceptionUtil.getClassName(exception));
        if (message != null && !message.equals(lastMessage)) {
            buffer.append('-');
            buffer.append(message);
        }
        return message;
    }

    private static final String getClassName(Throwable exception) {
        String className = exception.getClass().getName();
        int index = className.lastIndexOf(46);
        if (index >= 0 && index < className.length() - 1) {
            return className.substring(index + 1);
        }
        return className;
    }

    public static class NestedExceptionIterator
    implements Iterator {
        Throwable exception;
        Throwable child;

        public NestedExceptionIterator(Throwable e2) {
            this.exception = e2;
        }

        public boolean hasNext() {
            this.check();
            return this.child != null;
        }

        public Object next() {
            this.check();
            if (this.child == null) {
                throw new NoSuchElementException();
            }
            this.exception = this.child;
            this.child = null;
            return this.exception;
        }

        private void check() {
            if (this.child == null) {
                if (this.exception instanceof MetaMatrixNestedException) {
                    MetaMatrixNestedException e2 = (MetaMatrixNestedException)((Object)this.exception);
                    this.child = e2.getNestedException();
                } else if (this.exception instanceof MetaMatrixCoreException) {
                    MetaMatrixCoreException e3 = (MetaMatrixCoreException)this.exception;
                    this.child = e3.getException();
                } else if (this.exception instanceof ConfigurationException) {
                    ConfigurationException e4 = (ConfigurationException)this.exception;
                    this.child = e4.getRootCause();
                } else if (this.exception instanceof SQLException) {
                    SQLException e5 = (SQLException)this.exception;
                    this.child = e5.getNextException();
                }
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface MessageFormatter {
        public String getFormattedMessage(Throwable var1, int var2);
    }
}

