/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.util;

public class EquivalenceUtil {
    protected EquivalenceUtil() {
    }

    public static boolean areEqual(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    public static boolean areEquivalent(Object[] array1, Object[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null) {
            return array2 == null || array2.length == 0;
        }
        if (array2 == null) {
            return array1.length == 0;
        }
        if (array1.length != array2.length) {
            return false;
        }
        for (int i2 = 0; i2 < array1.length; ++i2) {
            if (EquivalenceUtil.areEqual(array1[i2], array2[i2])) continue;
            return false;
        }
        return true;
    }

    public static boolean areStrictlyEquivalent(Object obj1, Object obj2) {
        if (obj1 == obj2 || obj1 == null || obj2 == null) {
            return false;
        }
        return EquivalenceUtil.areEqual(obj1, obj2);
    }

    public static boolean areStrictlyEquivalent(Object[] array1, Object[] array2) {
        if (array1 == array2) {
            return false;
        }
        if (array1 == null) {
            return array2.length == 0;
        }
        if (array2 == null) {
            return array1.length == 0;
        }
        if (array1.length != array2.length) {
            return false;
        }
        for (int i2 = 0; i2 < array1.length; ++i2) {
            if (EquivalenceUtil.areStrictlyEquivalent(array1[i2], array2[i2])) continue;
            return false;
        }
        return true;
    }
}

