/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class EnhancedStringTokenizer
implements Enumeration {
    private int currentPosition = 0;
    private int newPosition = -1;
    private int maxPosition;
    private String str;
    private String delimiters;
    private int lastCurrentPosition = -1;
    private boolean retDelims;
    private boolean delimsChanged = false;
    private char maxDelimChar;

    private void setMaxDelimChar() {
        if (this.delimiters == null) {
            this.maxDelimChar = '\u0000';
            return;
        }
        char m2 = '\u0000';
        for (int i2 = 0; i2 < this.delimiters.length(); ++i2) {
            char c2 = this.delimiters.charAt(i2);
            if (m2 >= c2) continue;
            m2 = c2;
        }
        this.maxDelimChar = m2;
    }

    public EnhancedStringTokenizer(String str, String delim, boolean returnDelims) {
        this.str = str;
        this.maxPosition = str.length();
        this.delimiters = delim;
        this.retDelims = returnDelims;
        this.setMaxDelimChar();
    }

    public EnhancedStringTokenizer(String str, String delim) {
        this(str, delim, false);
    }

    public EnhancedStringTokenizer(String str) {
        this(str, " \t\n\r\f", false);
    }

    private int skipDelimiters(int startPos) {
        char c2;
        int position;
        if (this.delimiters == null) {
            throw new NullPointerException();
        }
        for (position = startPos; !this.retDelims && position < this.maxPosition && (c2 = this.str.charAt(position)) <= this.maxDelimChar && this.delimiters.indexOf(c2) >= 0; ++position) {
        }
        return position;
    }

    private int scanToken(int startPos) {
        char c2;
        int position;
        for (position = startPos; position < this.maxPosition && ((c2 = this.str.charAt(position)) > this.maxDelimChar || this.delimiters.indexOf(c2) < 0); ++position) {
        }
        if (this.retDelims && startPos == position && (c2 = this.str.charAt(position)) <= this.maxDelimChar && this.delimiters.indexOf(c2) >= 0) {
            ++position;
        }
        return position;
    }

    public boolean hasMoreTokens() {
        this.newPosition = this.skipDelimiters(this.currentPosition);
        return this.newPosition < this.maxPosition;
    }

    public String nextDelimiters() {
        int nextPosition;
        if (this.currentPosition == 0 && this.lastCurrentPosition == -1) {
            this.lastCurrentPosition = 0;
            return null;
        }
        int n2 = nextPosition = this.newPosition >= 0 && !this.delimsChanged ? this.newPosition : this.skipDelimiters(this.currentPosition);
        if (nextPosition == this.lastCurrentPosition) {
            return null;
        }
        String result = this.str.substring(this.lastCurrentPosition, nextPosition);
        this.lastCurrentPosition = this.maxPosition;
        return result;
    }

    public String nextToken() {
        this.currentPosition = this.newPosition >= 0 && !this.delimsChanged ? this.newPosition : this.skipDelimiters(this.currentPosition);
        this.delimsChanged = false;
        this.newPosition = -1;
        if (this.currentPosition >= this.maxPosition) {
            throw new NoSuchElementException();
        }
        int start = this.currentPosition;
        this.currentPosition = this.scanToken(this.currentPosition);
        String result = this.str.substring(start, this.currentPosition);
        this.lastCurrentPosition = this.currentPosition;
        return result;
    }

    public String nextToken(String delim) {
        this.delimiters = delim;
        this.delimsChanged = true;
        this.setMaxDelimChar();
        return this.nextToken();
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public int countTokens() {
        int count = 0;
        int currpos = this.currentPosition;
        while (currpos < this.maxPosition && (currpos = this.skipDelimiters(currpos)) < this.maxPosition) {
            currpos = this.scanToken(currpos);
            ++count;
        }
        return count;
    }
}

