/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.tree;

import com.metamatrix.core.tree.TreeNode;
import com.metamatrix.core.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SimpleTreeNode
implements StringUtil.Constants,
TreeNode {
    private Object obj;
    private SimpleTreeNode parent;
    private List children;

    public SimpleTreeNode() {
        this(null, null);
    }

    public SimpleTreeNode(Object object) {
        this(object, null);
    }

    public SimpleTreeNode(SimpleTreeNode parent) {
        this(null, parent);
    }

    public SimpleTreeNode(Object object, SimpleTreeNode parent) {
        this.setObject(object);
        this.setParent(parent);
        this.children = this.createChildList();
    }

    public final Object getObject() {
        return this.obj;
    }

    public final TreeNode getParent() {
        return this.parent;
    }

    public final List getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public void setObject(Object object) {
        this.obj = object;
    }

    public boolean setParent(SimpleTreeNode parent) {
        SimpleTreeNode oldParent = this.parent;
        if (parent == oldParent) {
            return false;
        }
        if (oldParent != null && !oldParent.removeChild(this)) {
            return false;
        }
        this.parent = parent;
        if (parent != null && !parent.addChild(this)) {
            oldParent.addChild(this);
            return false;
        }
        return true;
    }

    protected List createChildList() {
        return new ArrayList();
    }

    protected List getChildList() {
        return this.children;
    }

    protected boolean addChild(SimpleTreeNode child) {
        return this.children.add(child);
    }

    private boolean removeChild(TreeNode child) {
        return this.children.remove(child);
    }

    public String toString() {
        return this.obj == null ? "" : this.obj.toString();
    }
}

