/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.struct;

import com.metamatrix.core.CorePlugin;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.util.StringUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;

public class ReflectionWrapper {
    private Object target;
    private Class targetClass;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$util$Date;

    public ReflectionWrapper(Object target) {
        this.targetClass = target.getClass();
        this.target = target;
    }

    public String[] getFieldsWithUserDefinedTypes() {
        ArrayList<String> fieldNames = new ArrayList<String>();
        Field[] fields = this.targetClass.getFields();
        for (int i2 = 0; i2 < fields.length; ++i2) {
            if (!this.isUserDefined(fields[i2].getType())) continue;
            fieldNames.add(fields[i2].getName());
        }
        return fieldNames.toArray(new String[fieldNames.size()]);
    }

    public String[] getFieldsWithPrimitiveTypes() {
        ArrayList<String> fieldNames = new ArrayList<String>();
        Field[] fields = this.targetClass.getFields();
        for (int i2 = 0; i2 < fields.length; ++i2) {
            if (this.isUserDefined(fields[i2].getType())) continue;
            fieldNames.add(fields[i2].getName());
        }
        return fieldNames.toArray(new String[fieldNames.size()]);
    }

    public Object get(String fieldName) {
        try {
            Field field = this.targetClass.getField(fieldName);
            Object fieldValue = field.get(this.target);
            return fieldValue;
        }
        catch (SecurityException e2) {
            throw new MetaMatrixRuntimeException(e2);
        }
        catch (NoSuchFieldException e3) {
            Object[] params = new Object[]{this.targetClass.getName(), fieldName};
            String message = CorePlugin.Util.getString("ReflectionWrapper.Could_not_find_field_{0}.{1}", params);
            throw new MetaMatrixRuntimeException(e3, message);
        }
        catch (IllegalArgumentException e4) {
            throw new MetaMatrixRuntimeException(e4);
        }
        catch (IllegalAccessException e5) {
            throw new MetaMatrixRuntimeException(e5);
        }
    }

    public boolean isUserDefined(Class type) {
        if (type.isPrimitive()) {
            return false;
        }
        HashSet<Class> pseudoPrimitiveTypes = new HashSet<Class>();
        pseudoPrimitiveTypes.add(class$java$lang$Integer == null ? (class$java$lang$Integer = ReflectionWrapper.class$("java.lang.Integer")) : class$java$lang$Integer);
        pseudoPrimitiveTypes.add(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ReflectionWrapper.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        pseudoPrimitiveTypes.add(class$java$lang$String == null ? (class$java$lang$String = ReflectionWrapper.class$("java.lang.String")) : class$java$lang$String);
        pseudoPrimitiveTypes.add(class$java$lang$Long == null ? (class$java$lang$Long = ReflectionWrapper.class$("java.lang.Long")) : class$java$lang$Long);
        pseudoPrimitiveTypes.add(class$java$lang$Float == null ? (class$java$lang$Float = ReflectionWrapper.class$("java.lang.Float")) : class$java$lang$Float);
        pseudoPrimitiveTypes.add(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = ReflectionWrapper.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
        pseudoPrimitiveTypes.add(class$java$util$Date == null ? (class$java$util$Date = ReflectionWrapper.class$("java.util.Date")) : class$java$util$Date);
        if (pseudoPrimitiveTypes.contains(type)) {
            return false;
        }
        if (type.isArray()) {
            return this.isUserDefined(type.getComponentType());
        }
        return true;
    }

    public String applyTemplate(String template, String nullString) {
        String prefix = "";
        template = this.applyTemplateForObject(template, "", this.target, nullString);
        String[] fieldNames = this.getFieldsWithUserDefinedTypes();
        for (int i2 = 0; i2 < fieldNames.length; ++i2) {
            String name = fieldNames[i2];
            template = this.applyTemplateForObject(template, prefix + name + ".", this.get(name), nullString);
        }
        return template;
    }

    private String applyTemplateForObject(String template, String prefix, Object templateTarget, String nullString) {
        if (templateTarget == null) {
            return template;
        }
        Field[] fields = templateTarget.getClass().getFields();
        for (int i2 = 0; i2 < fields.length; ++i2) {
            String fieldName = fields[i2].getName();
            Object value = new ReflectionWrapper(templateTarget).get(fieldName);
            String valueString = nullString;
            if (value != null) {
                valueString = value.toString();
            }
            template = StringUtil.replace(template, "%" + prefix + fieldName + "%", valueString);
        }
        return template;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

