/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.selection;

import com.metamatrix.core.selection.TreeSelectionProvider;
import com.metamatrix.core.util.ArgCheck;
import java.util.HashSet;
import java.util.Set;

public class TreeSelectionState {
    public static final int SELECTED = 1;
    public static final int UNSELECTED = 0;
    public static final int PARTIALLY_SELECTED = 2;
    public static final int UNKNOWN = -1;
    private final Set selecteds;
    private final Set unselecteds;
    private final Set partiallySelected;
    private final TreeSelectionProvider provider;

    public TreeSelectionState(TreeSelectionProvider provider) {
        ArgCheck.isNotNull(provider);
        this.selecteds = new HashSet();
        this.unselecteds = new HashSet();
        this.partiallySelected = new HashSet();
        this.provider = provider;
    }

    public boolean hasSelectionModes() {
        return this.selecteds.size() != 0 || this.partiallySelected.size() != 0 || this.unselecteds.size() != 0;
    }

    public int getSelectionMode(Object node) {
        ArgCheck.isNotNull(node);
        if (this.selecteds.contains(node)) {
            return 1;
        }
        if (this.unselecteds.contains(node)) {
            return 0;
        }
        if (this.partiallySelected.contains(node)) {
            return 2;
        }
        if (this.provider.isRoot(node)) {
            this.unselecteds.add(node);
            return 0;
        }
        Object parentKey = this.provider.getParent(node);
        int parentMode = this.getSelectionMode(parentKey);
        if (parentMode == 1) {
            this.selecteds.add(node);
            return 1;
        }
        if (parentMode == 2) {
            return -1;
        }
        return 0;
    }

    public void setSelected(Object node, int selectionMode) {
        ArgCheck.isNotNull(node);
        if (selectionMode == 1) {
            this.selecteds.add(node);
            this.unselecteds.remove(node);
            this.partiallySelected.remove(node);
        } else if (selectionMode == 0) {
            this.selecteds.remove(node);
            this.unselecteds.add(node);
            this.partiallySelected.remove(node);
        } else if (selectionMode == 2) {
            this.selecteds.remove(node);
            this.unselecteds.remove(node);
            this.partiallySelected.add(node);
        }
    }
}

