/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.proxy;

import com.metamatrix.core.CorePlugin;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.proxy.ServiceInterceptorStack;
import com.metamatrix.core.proxy.ServiceInvocationStruct;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.ReflectionHelper;
import com.metamatrix.internal.core.text.MessageFormat;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ServiceInvocation {
    private Method method;
    private Object[] arguments;
    private ServiceInterceptorStack stack;
    private Map attributes = Collections.synchronizedMap(new HashMap());

    protected ServiceInvocation() {
    }

    public ServiceInvocation(ServiceInvocationStruct struct, Class targetInterface, ServiceInterceptorStack stack) {
        ReflectionHelper helper = new ReflectionHelper(targetInterface);
        try {
            this.method = helper.findBestMethodOnTarget(struct.methodName, struct.arguments);
        }
        catch (SecurityException err) {
            throw new MetaMatrixRuntimeException(err);
        }
        catch (NoSuchMethodException err) {
            throw new MetaMatrixRuntimeException(MessageFormat.format(CorePlugin.Util.getString("ServiceInvocation.Method_not_found_{0}.{1}"), new Object[]{targetInterface.getName(), struct.methodName}));
        }
        if (this.method == null) {
            throw new MetaMatrixRuntimeException(MessageFormat.format(CorePlugin.Util.getString("ServiceInvocation.Method_not_found_{0}.{1}"), new Object[]{targetInterface.getName(), struct.methodName}));
        }
        this.arguments = struct.arguments;
        Assertion.assertTrue(struct.attributeNames.length == struct.attributeValues.length);
        ServiceInvocation.populateAttributeMap(struct, this.attributes);
        this.stack = stack;
    }

    private static void populateAttributeMap(ServiceInvocationStruct struct, Map attributeMap) {
        for (int i2 = 0; i2 < struct.attributeNames.length; ++i2) {
            attributeMap.put(struct.attributeNames[i2], struct.attributeValues[i2]);
        }
    }

    public ServiceInvocation(Method method, Object[] arguments, ServiceInterceptorStack stack) {
        if (method == null) {
            String msg = CorePlugin.Util.getString("ServiceInvocation.The_Method_reference_may_not_be_null");
            throw new IllegalArgumentException(msg);
        }
        if (arguments == null) {
            String msg = CorePlugin.Util.getString("ServiceInvocation.The_arguments_array_may_not_be_null");
            throw new IllegalArgumentException(msg);
        }
        if (stack == null) {
            String msg = CorePlugin.Util.getString("ServiceInvocation.The_stack_may_not_be_null");
            throw new IllegalArgumentException(msg);
        }
        this.method = method;
        this.arguments = arguments;
        this.stack = stack;
    }

    public Object invokeNext() throws Throwable {
        return this.stack.pop().invoke(this);
    }

    public Object invokeOn(Object target) throws Throwable {
        return this.method.invoke(target, this.arguments);
    }

    public String getMethodName() {
        return this.method.getName();
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public void setAttribute(String key, Serializable value) {
        this.attributes.put(key, value);
    }

    public void setLocalAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public static Object getAttribute(ServiceInvocationStruct struct, String key) {
        HashMap attributeMap = new HashMap();
        ServiceInvocation.populateAttributeMap(struct, attributeMap);
        return attributeMap.get(key);
    }

    public ServiceInvocationStruct toStruct() {
        ServiceInvocationStruct result = new ServiceInvocationStruct();
        result.methodName = this.method.getName();
        result.arguments = this.arguments;
        result.attributeNames = new String[this.attributes.size()];
        result.attributeValues = new Object[this.attributes.size()];
        int i2 = 0;
        Iterator iterator = this.attributes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            result.attributeNames[i2] = (String)entry.getKey();
            result.attributeValues[i2] = entry.getValue();
            ++i2;
        }
        return result;
    }
}

