/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.plugin;

import com.metamatrix.core.CorePlugin;
import com.metamatrix.core.util.Argument;
import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public abstract class PluginUtilities {
    private static final String PLUGINS_FOLDER = "plugins";
    private static final String BOOT_PLUGIN_FOLDER = "org.eclipse.core.boot";
    private static final String BOOT_JAR = "boot.jar";
    private static final String PROTOCOL = "file";
    private static final String BOOT_LOADER = "org.eclipse.core.boot.BootLoader";
    private static final String TEMPORARY_METADATA_PATH = System.getProperty("java.io.tmpdir") + "metamatrix";
    private static final String STARTUP_METHOD = "startup";
    private static final String SHUTDOWN_METHOD = "shutdown";
    private static final String CONSOLE_LOGGING_OPTION = CorePlugin.Util.getString("PluginUtilities.-consoleLog_11");
    private static final int BOOT_PLUGIN_FOLDER_NOT_FOUND_CODE = 0;
    private static final String BOOT_PLUGIN_FOLDER_NOT_FOUND_MESSAGE = CorePlugin.Util.getString("PluginUtilities.Could_not_find___12") + "org.eclipse.core.boot" + CorePlugin.Util.getString("PluginUtilities.__folder._13");
    private static final String CONSTRUCTOR_MESSAGE = CorePlugin.Util.getString("PluginUtilities.Make_sure_the_executable_extension_class_contains_a_public_constructor_14") + CorePlugin.Util.getString("PluginUtilities._with_no_arguments._15");
    private static Class bootLoader;
    private static String[] startupArgs;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$lang$String;

    public static Object createExecutableExtension(IExtension extension, String element, String attribute) throws CoreException {
        try {
            IConfigurationElement[] elems = extension.getConfigurationElements();
            int count = elems.length;
            for (int ndx = 0; ndx < count; ++ndx) {
                IConfigurationElement elem = elems[ndx];
                if (!elem.getName().equals(element)) continue;
                return elem.createExecutableExtension(attribute);
            }
            return null;
        }
        catch (CoreException err) {
            if (err.getStatus().getException() instanceof InstantiationException) {
                System.err.println(CONSTRUCTOR_MESSAGE);
            }
            throw err;
        }
    }

    public static Object createExecutableExtension(String id, String element, String attribute) throws CoreException {
        IExtension extension = PluginUtilities.getExtension(id);
        if (extension == null) {
            return null;
        }
        return PluginUtilities.createExecutableExtension(extension, element, attribute);
    }

    public static IExtension getExtension(String id) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry != null) {
            IExtensionPoint[] points = registry.getExtensionPoints();
            int pointCount = points.length;
            for (int pointNdx = 0; pointNdx < pointCount; ++pointNdx) {
                IExtension extension = PluginUtilities.getExtension(id, points[pointNdx].getExtensions());
                if (extension == null) continue;
                return extension;
            }
        }
        return null;
    }

    public static IExtension getExtension(String id, IExtension[] extensions) {
        int count = extensions.length;
        for (int ndx = 0; ndx < count; ++ndx) {
            IExtension extension = extensions[ndx];
            String uniqueId = extension.getUniqueIdentifier();
            if (uniqueId == null || !uniqueId.equals(id)) continue;
            return extension;
        }
        return null;
    }

    public static IExtension[] getExtensions(String id) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry != null) {
            IExtensionPoint point = registry.getExtensionPoint(id);
            if (point == null) {
                return new IExtension[0];
            }
            return point.getExtensions();
        }
        return new IExtension[0];
    }

    public static IConfigurationElement[] getConfigurationElements(IExtension extension, String elementName) {
        ArrayList<IConfigurationElement> list = new ArrayList<IConfigurationElement>();
        if (extension != null && elementName != null) {
            IConfigurationElement[] elems = extension.getConfigurationElements();
            for (int j2 = 0; j2 < elems.length; ++j2) {
                IConfigurationElement elem = elems[j2];
                if (!elementName.equals(elem.getName())) continue;
                list.add(elem);
            }
        }
        IConfigurationElement[] result = new IConfigurationElement[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            result[i2] = (IConfigurationElement)list.get(i2);
        }
        return result;
    }

    public static IConfigurationElement[] getConfigurationElementsFor(String id) {
        return Platform.getExtensionRegistry().getConfigurationElementsFor(id);
    }

    public static IExtensionPoint getExtensionPoint(String id) {
        return Platform.getExtensionRegistry().getExtensionPoint(id);
    }

    public static void setConsoleLogging(boolean logging) {
        startupArgs = logging ? new String[]{CONSOLE_LOGGING_OPTION} : new String[0];
    }

    public static void shutdown() throws IllegalAccessException, IllegalStateException, InvocationTargetException, NoSuchMethodException {
        if (bootLoader == null) {
            throw new IllegalStateException(CorePlugin.Util.getString("PluginUtilities.One_of_the_other_PluginUtilities.getApplication_methods_must_first_be_called._17"));
        }
        bootLoader.getMethod(SHUTDOWN_METHOD, new Class[0]).invoke((Object)bootLoader, new Object[0]);
        bootLoader = null;
    }

    public static void startup(String installPath) throws ClassNotFoundException, CoreException, IllegalAccessException, InvocationTargetException, MalformedURLException, NoSuchMethodException {
        PluginUtilities.startup(installPath, null);
    }

    public static void startup(String installPath, String metadataPath) throws ClassNotFoundException, CoreException, IllegalAccessException, InvocationTargetException, MalformedURLException, NoSuchMethodException {
        Argument.isNotEmpty(installPath, CorePlugin.Util.getString("PluginUtilities.The_installation_path_must_not_be_empty._18"));
        if (bootLoader == null) {
            StringBuffer bootFolderPath;
            char lastChr;
            if (metadataPath == null) {
                metadataPath = TEMPORARY_METADATA_PATH;
            }
            if ((lastChr = (bootFolderPath = new StringBuffer(installPath)).charAt(bootFolderPath.length() - 1)) != '/' && lastChr != '\\') {
                bootFolderPath.append('/');
            }
            bootFolderPath.append(PLUGINS_FOLDER);
            File[] bootPluginFolders = new File(bootFolderPath.toString()).listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() && file.getName().startsWith(PluginUtilities.BOOT_PLUGIN_FOLDER);
                }
            });
            if (bootPluginFolders.length == 0) {
                Status status = new Status(4, BOOT_PLUGIN_FOLDER, 0, BOOT_PLUGIN_FOLDER_NOT_FOUND_MESSAGE, null);
                throw new CoreException(status);
            }
            String bootJarPath = new File(bootPluginFolders[0], BOOT_JAR).getAbsolutePath().replace(File.separatorChar, '/');
            URL bootUrl = new URL(PROTOCOL, null, bootJarPath);
            Class<?> bootLoader = new URLClassLoader(new URL[]{bootUrl}, null).loadClass(BOOT_LOADER);
            Method startupMeth = bootLoader.getMethod(STARTUP_METHOD, class$java$net$URL == null ? (class$java$net$URL = PluginUtilities.class$("java.net.URL")) : class$java$net$URL, class$java$lang$String == null ? (class$java$lang$String = PluginUtilities.class$("java.lang.String")) : class$java$lang$String, array$Ljava$lang$String == null ? (array$Ljava$lang$String = PluginUtilities.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
            startupMeth.invoke(bootLoader, null, metadataPath, startupArgs);
            PluginUtilities.bootLoader = bootLoader;
        }
    }

    public static String getPluginProjectLocation(String pluginProjectId) throws Exception {
        return PluginUtilities.getPluginProjectLocation(pluginProjectId, false);
    }

    public static String getPluginProjectLocation(String pluginProjectId, boolean removeEndingSeparator) throws Exception {
        String filePrefix = "file:";
        URL pluginURL = Platform.getBundle(pluginProjectId).getEntry("/");
        URL resolvedPluginUrl = Platform.resolve(pluginURL);
        String pluginPath = resolvedPluginUrl.toExternalForm();
        if (pluginPath != null) {
            if (pluginPath.startsWith("file:") && (pluginPath = pluginPath.substring("file:".length())).indexOf(58) > 0 && pluginPath.charAt(0) == '/') {
                pluginPath = pluginPath.substring(1);
            }
            if (removeEndingSeparator && (pluginPath.endsWith("/") || pluginPath.endsWith("\\"))) {
                pluginPath = pluginPath.substring(0, pluginPath.length() - 1);
            }
        }
        return pluginPath;
    }

    public static String getPluginProjectLocation(String pluginProjectId, String version) throws Exception {
        String filePrefix = "file:";
        Bundle[] bundles = Platform.getBundles(pluginProjectId, version);
        String result = null;
        for (int i2 = 0; i2 < bundles.length; ++i2) {
            URL pluginURL = bundles[i2].getEntry("/");
            URL resolvedPluginUrl = Platform.resolve(pluginURL);
            String pluginPath = resolvedPluginUrl.toExternalForm();
            if (pluginPath == null) continue;
            if (pluginPath.startsWith("file:") && (pluginPath = pluginPath.substring("file:".length())).indexOf(58) > 0 && pluginPath.charAt(0) == '/') {
                pluginPath = pluginPath.substring(1);
            }
            result = pluginPath;
            if (pluginPath.indexOf(version) <= 0) continue;
            return pluginPath;
        }
        return result;
    }

    public static String getPluginsLocation(boolean removeEndingSeparator) throws Exception {
        String pluginPath = PluginUtilities.getPluginProjectLocation("com.metamatrix.core", false);
        if (pluginPath != null) {
            int pluginsIndex = pluginPath.indexOf(PLUGINS_FOLDER);
            pluginPath = pluginPath.substring(0, pluginsIndex + PLUGINS_FOLDER.length());
            if (removeEndingSeparator && (pluginPath.endsWith("/") || pluginPath.endsWith("\\"))) {
                pluginPath = pluginPath.substring(0, pluginPath.length() - 1);
            }
        }
        return pluginPath;
    }

    public static String getPluginsLocation() throws Exception {
        return PluginUtilities.getPluginsLocation(false);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        startupArgs = new String[0];
    }
}

