/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.id;

import com.metamatrix.core.CorePlugin;
import com.metamatrix.core.id.IntegerID;
import com.metamatrix.core.id.InvalidIDException;
import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.id.ObjectIDFactory;
import com.metamatrix.core.id.ParsedObjectID;
import java.io.Serializable;

public class IntegerIDFactory
implements ObjectIDFactory,
Serializable {
    private int lastID = 0;

    public String getDescription() {
        return CorePlugin.Util.getString("IntegerIDFactory.Description");
    }

    protected int getNextValue() {
        return ++this.lastID;
    }

    public ObjectID create() {
        return new IntegerID(this.getNextValue());
    }

    public boolean validate(ObjectID id) {
        return id instanceof IntegerID;
    }

    public ObjectID stringToObject(String value) throws InvalidIDException {
        ParsedObjectID parsedID = ParsedObjectID.parsedStringifiedObjectID(value, "mmint");
        try {
            return new IntegerID(Integer.parseInt(parsedID.getRemainder()));
        }
        catch (NumberFormatException e2) {
            throw new InvalidIDException(CorePlugin.Util.getString("IntegerIDFactory.The_specified_ID_value_is_invalid", value, this.getProtocol()));
        }
    }

    public ObjectID stringWithoutProtocolToObject(String value) throws InvalidIDException {
        try {
            return new IntegerID(Integer.parseInt(value));
        }
        catch (NumberFormatException e2) {
            throw new InvalidIDException(CorePlugin.Util.getString("IntegerIDFactory.The_specified_ID_value_is_invalid", value, this.getProtocol()));
        }
    }

    public String getProtocol() {
        return "mmint";
    }
}

