/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.commandshell;

import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.util.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;

public class ConnectorResultUtility {
    private static final String ERROR_MESSAGE_PREFIX = "CompareResults Error: ";
    private static final String NULL_STRING = "<null>";
    private static final String COLUMN_SEPARATOR = "\t";
    private static final String NOROWS_STRING = "No rows returned.";

    public static String resultsToString(List results, String[] columnNames) {
        if (results == null || results.isEmpty()) {
            return NOROWS_STRING;
        }
        StringBuffer result = new StringBuffer();
        int columnIndex = 0;
        Iterator iterator = results.iterator();
        while (iterator.hasNext()) {
            List row = (List)iterator.next();
            boolean firstColumn = true;
            columnIndex = 0;
            Iterator j2 = row.iterator();
            while (j2.hasNext()) {
                Object next = j2.next();
                String value = null;
                if (next == null) {
                    value = NULL_STRING;
                } else {
                    value = next.toString();
                    value = StringUtil.replaceAll(value, COLUMN_SEPARATOR, "\\t");
                    value = StringUtil.replaceAll(value, "\n", "\\n");
                }
                if (firstColumn) {
                    firstColumn = false;
                } else {
                    result.append(COLUMN_SEPARATOR);
                }
                result.append(value);
                ++columnIndex;
            }
            result.append(StringUtil.LINE_SEPARATOR);
        }
        if (columnNames == null || columnNames.length == 0) {
            columnNames = new String[columnIndex];
            for (int i2 = 0; i2 < columnIndex; ++i2) {
                columnNames[i2] = "col" + (i2 + 1);
            }
        }
        StringBuffer header = new StringBuffer();
        boolean firstValue = true;
        for (int i3 = 0; i3 < columnNames.length; ++i3) {
            String label = null;
            if (columnNames[i3] == null) {
                label = NULL_STRING;
            } else {
                label = columnNames[i3];
                int delimiterIndex = columnNames[i3].lastIndexOf(46);
                if (delimiterIndex != -1) {
                    label = columnNames[i3].substring(delimiterIndex + 1);
                }
            }
            if (firstValue) {
                firstValue = false;
            } else {
                header.append(COLUMN_SEPARATOR);
            }
            header.append(label);
        }
        header.append(StringUtil.LINE_SEPARATOR);
        return header.toString() + result.toString();
    }

    public static String resultsToString(List results) {
        return ConnectorResultUtility.resultsToString(results, null);
    }

    private static int getRowCount(String text) throws IOException {
        BufferedReader reader = new BufferedReader(new StringReader(text));
        int rowCount = 0;
        String line = reader.readLine();
        while (line != null) {
            ++rowCount;
            line = reader.readLine();
        }
        return rowCount;
    }

    public static String compareResultsStrings(String expected, String actual) {
        if (expected.equals(actual)) {
            return null;
        }
        try {
            BufferedReader expectedReader = new BufferedReader(new StringReader(expected));
            BufferedReader actualReader = new BufferedReader(new StringReader(actual));
            int expectedRowCount = ConnectorResultUtility.getRowCount(expected);
            int actualRowCount = ConnectorResultUtility.getRowCount(actual);
            if (expectedRowCount > actualRowCount) {
                return "CompareResults Error: Expected " + expectedRowCount + " records but received only " + actualRowCount;
            }
            if (actualRowCount > expectedRowCount) {
                return "CompareResults Error: Expected " + expectedRowCount + " records but received " + actualRowCount;
            }
            String expectedLine = expectedReader.readLine();
            int rowIndex = 0;
            while (expectedLine != null) {
                int expectedColumnCount;
                String actualLine = actualReader.readLine();
                List actualRow = StringUtil.split(actualLine, COLUMN_SEPARATOR);
                List expectedRow = StringUtil.split(expectedLine, COLUMN_SEPARATOR);
                int actualColumnCount = actualRow.size();
                if (actualColumnCount != (expectedColumnCount = expectedRow.size())) {
                    return "Incorrect number of columns at row = " + rowIndex + ", expected = " + expectedColumnCount + ", actual = " + actualColumnCount;
                }
                for (int columnIndex = 0; columnIndex < expectedColumnCount; ++columnIndex) {
                    Object expectedValue = expectedRow.get(columnIndex);
                    Object actualValue = actualRow.get(columnIndex);
                    if (!(expectedValue == null ? actualValue != null : !expectedValue.equals(actualValue))) continue;
                    return ConnectorResultUtility.getMismatchMessage(rowIndex, columnIndex, expectedValue, actualValue);
                }
                expectedLine = expectedReader.readLine();
                ++rowIndex;
            }
        }
        catch (IOException e2) {
            throw new MetaMatrixRuntimeException(e2);
        }
        return null;
    }

    private static String getMismatchMessage(int rowIndex, int columnIndex, Object expectedValue, Object actualValue) {
        return "CompareResults Error: Value mismatch at row " + rowIndex + " and column " + columnIndex + ": expected = " + expectedValue + ", actual = " + actualValue;
    }
}

