/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.sysadmin.extension.value;

import com.metamatrix.common.types.Transform;
import com.metamatrix.common.types.TransformationException;
import com.metamatrix.connector.sysadmin.extension.IObjectCommand;
import com.metamatrix.connector.sysadmin.extension.IValueTranslator;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.exception.ConnectorException;

public class BasicValueTranslator
implements IValueTranslator {
    private Transform transform;
    private ConnectorEnvironment env;

    public BasicValueTranslator(Transform transform) {
        this.transform = transform;
    }

    public void initialize(ConnectorEnvironment env) {
        this.env = env;
    }

    public Class getSourceType() {
        return this.transform.getSourceType();
    }

    public Class getTargetType() {
        return this.transform.getTargetType();
    }

    public Object translate(Object value, IObjectCommand command, ExecutionContext context) throws ConnectorException {
        try {
            return this.transform.transform(value);
        }
        catch (TransformationException e2) {
            if (this.env != null) {
                this.env.getLogger().logError(e2.getMessage(), e2);
            }
            throw new ConnectorException((Throwable)e2);
        }
    }
}

