/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.sysadmin.extension.command;

import com.metamatrix.connector.sysadmin.extension.IObjectCommand;
import com.metamatrix.connector.sysadmin.util.SysAdminUtil;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.ICommand;
import com.metamatrix.data.language.IMetadataReference;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;

public abstract class ObjectCommand
implements IObjectCommand {
    private final RuntimeMetadata metadata;
    private final ICommand command;

    public ObjectCommand(RuntimeMetadata metadata, ICommand command) throws ConnectorException {
        ArgCheck.isNotNull(metadata);
        ArgCheck.isNotNull(command);
        this.metadata = metadata;
        this.command = command;
    }

    public ICommand getCommand() {
        return this.command;
    }

    public String getCommandName() {
        if (this.getGroupNameInSource() != null) {
            return this.getGroupNameInSource();
        }
        return this.getGroupName();
    }

    public boolean hasResults() {
        return false;
    }

    public RuntimeMetadata getMetadata() {
        return this.metadata;
    }

    protected String getMetadataObjectNameInSource(IMetadataReference reference) throws ConnectorException {
        return SysAdminUtil.getMetadataObjectNameInSource(this.getMetadata(), reference);
    }

    protected String determineName(IMetadataReference reference) throws ConnectorException {
        return SysAdminUtil.getExecutionName(this.getMetadata(), reference);
    }
}

