/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.metadata.internal;

import com.metamatrix.connector.metadata.MetadataConnectorPlugin;
import com.metamatrix.connector.metadata.index.MetadataInCriteria;
import com.metamatrix.connector.metadata.index.MetadataLiteralCriteria;
import com.metamatrix.connector.metadata.internal.ObjectProcedure;
import com.metamatrix.connector.metadata.internal.ObjectQuery;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.ICompareCriteria;
import com.metamatrix.data.language.ICompoundCriteria;
import com.metamatrix.data.language.ICriteria;
import com.metamatrix.data.language.IExpression;
import com.metamatrix.data.language.IInCriteria;
import com.metamatrix.data.language.ILikeCriteria;
import com.metamatrix.data.language.IParameter;
import com.metamatrix.data.language.IQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MetadataSearchCriteriaBuilder {
    private static char SQL_WILDCARD_CHAR = (char)37;
    private final Map criteriaMap = new HashMap();
    private ObjectQuery query;

    public MetadataSearchCriteriaBuilder(ObjectQuery query) throws ConnectorException {
        ArgCheck.isNotNull(query);
        this.query = query;
        this.initCriteria(query.getQuery());
    }

    public MetadataSearchCriteriaBuilder(ObjectProcedure proc) throws ConnectorException {
        ArgCheck.isNotNull(proc);
        this.initCriteria(proc);
    }

    private void initCriteria(IQuery query) throws ConnectorException {
        ArgCheck.isNotNull(query);
        this.buildMetadataSearchCriteria(query.getWhere());
    }

    private void initCriteria(ObjectProcedure proc) throws ConnectorException {
        Collection inParams = proc.getInParameters();
        if (inParams != null) {
            Iterator iter = inParams.iterator();
            while (iter.hasNext()) {
                Object value;
                IParameter parameter = (IParameter)iter.next();
                String nameInSource = proc.getParameterNameInSource(parameter);
                if (nameInSource == null || !StringUtil.startsWithIgnoreCase(nameInSource, "get") || (value = parameter.getValue()) == null) continue;
                MetadataLiteralCriteria literalCriteria = new MetadataLiteralCriteria(nameInSource, value);
                this.criteriaMap.put(nameInSource.toUpperCase(), literalCriteria);
            }
        }
    }

    public Map getCriteria() {
        return this.criteriaMap;
    }

    public void buildMetadataSearchCriteria(ICriteria criteria) throws ConnectorException {
        if (criteria != null) {
            if (criteria instanceof ICompareCriteria) {
                this.buildMetadataCompareCriteria((ICompareCriteria)criteria);
            } else if (criteria instanceof ILikeCriteria) {
                this.buildMetadataLikeCriteria((ILikeCriteria)criteria);
            } else if (criteria instanceof IInCriteria) {
                this.buildMetadataInCriteria((IInCriteria)criteria);
            } else if (criteria instanceof ICompoundCriteria) {
                this.buildMetadataCompoundCriteria((ICompoundCriteria)criteria);
            } else {
                Object[] params = new Object[]{criteria};
                throw new RuntimeException(MetadataConnectorPlugin.Util.getString("ObjectQuery.Unsupported_criteria_{0}", params));
            }
        }
    }

    private void buildMetadataCompareCriteria(ICompareCriteria criteria) throws ConnectorException {
        Assertion.assertTrue(criteria.getOperator() == 0, "Only supports equals.");
        IExpression ltExpression = criteria.getLeftExpression();
        IExpression rtExpression = criteria.getRightExpression();
        String fieldName = this.query.getElementName(ltExpression);
        Object literalValue = this.query.getExpressionValue(rtExpression);
        String fieldFunctionName = this.query.getFunctionName(ltExpression);
        String valueFunctionName = this.query.getFunctionName(rtExpression);
        MetadataLiteralCriteria literalCriteria = new MetadataLiteralCriteria(fieldName, literalValue);
        literalCriteria.setFieldFunction(fieldFunctionName);
        literalCriteria.setValueFunction(valueFunctionName);
        this.criteriaMap.put(fieldName.toUpperCase(), literalCriteria);
    }

    private void buildMetadataLikeCriteria(ILikeCriteria criteria) throws ConnectorException {
        IExpression ltExpression = criteria.getLeftExpression();
        IExpression rtExpression = criteria.getRightExpression();
        String fieldName = this.query.getElementName(ltExpression);
        String literalValue = (String)this.query.getExpressionValue(rtExpression);
        literalValue = literalValue.replace(SQL_WILDCARD_CHAR, '*');
        String fieldFunctionName = this.query.getFunctionName(ltExpression);
        String valueFunctionName = this.query.getFunctionName(rtExpression);
        MetadataLiteralCriteria literalCriteria = new MetadataLiteralCriteria(fieldName, literalValue);
        literalCriteria.setFieldFunction(fieldFunctionName);
        literalCriteria.setValueFunction(valueFunctionName);
        this.criteriaMap.put(fieldName.toUpperCase(), literalCriteria);
    }

    private void buildMetadataInCriteria(IInCriteria criteria) throws ConnectorException {
        IExpression ltExpression = criteria.getLeftExpression();
        List rtExpressions = criteria.getRightExpressions();
        ArrayList<Object> literalValues = new ArrayList<Object>(rtExpressions.size());
        String fieldName = this.query.getElementName(ltExpression);
        Iterator iter = rtExpressions.iterator();
        while (iter.hasNext()) {
            literalValues.add(this.query.getExpressionValue((IExpression)iter.next()));
        }
        String fieldFunctionName = this.query.getFunctionName(ltExpression);
        MetadataInCriteria literalCriteria = new MetadataInCriteria(fieldName, literalValues);
        literalCriteria.setFieldFunction(fieldFunctionName);
        this.criteriaMap.put(fieldName.toUpperCase(), literalCriteria);
    }

    private void buildMetadataCompoundCriteria(ICompoundCriteria compoundCriteria) throws ConnectorException {
        if (compoundCriteria.getOperator() == 0) {
            Iterator critIter = compoundCriteria.getCriteria().iterator();
            while (critIter.hasNext()) {
                this.buildMetadataSearchCriteria((ICriteria)critIter.next());
            }
        } else {
            throw new RuntimeException(MetadataConnectorPlugin.Util.getString("ObjectQuery.Only_supports_AND_operator"));
        }
    }
}

