/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.metadata.index;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.connector.metadata.RuntimeVdbRecord;
import com.metamatrix.connector.metadata.index.MetadataInCriteria;
import com.metamatrix.connector.metadata.index.MetadataLiteralCriteria;
import com.metamatrix.connector.metadata.index.MetadataSearchCriteria;
import com.metamatrix.connector.metadata.index.VdbMetadataContext;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.CharOperation;
import com.metamatrix.dqp.service.VDBService;
import com.metamatrix.modeler.core.metadata.runtime.DatatypeRecord;
import com.metamatrix.modeler.core.metadata.runtime.FileRecord;
import com.metamatrix.modeler.core.metadata.runtime.MetadataConstants;
import com.metamatrix.modeler.core.metadata.runtime.MetadataRecord;
import com.metamatrix.modeler.core.metadata.runtime.ModelRecord;
import com.metamatrix.modeler.core.metadata.runtime.PropertyRecord;
import com.metamatrix.modeler.core.metadata.runtime.VdbRecord;
import com.metamatrix.modeler.internal.core.metadata.runtime.ModelRecordImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class MetadataResultsPostProcessor {
    private final String vdbName;
    private final String vdbVersion;
    private final VDBService vdbService;

    public MetadataResultsPostProcessor(VdbMetadataContext context) {
        this.vdbName = context.getVdbName();
        this.vdbVersion = context.getVdbVersion();
        this.vdbService = context.getVdbService();
        Assertion.isNotNull(this.vdbName);
        Assertion.isNotNull(this.vdbVersion);
    }

    public Collection processMetadataRecords(String indexFileName, Collection records, Map searchCriteria, boolean needSearchFiltering) {
        ArgCheck.isNotNull(records);
        ArgCheck.isNotNull(searchCriteria);
        ArgCheck.isNotNull(indexFileName);
        if (!(needSearchFiltering || indexFileName.equalsIgnoreCase("VDBS.INDEX") || indexFileName.equalsIgnoreCase("MODELS.INDEX") || indexFileName.equalsIgnoreCase("FILES.INDEX"))) {
            return records;
        }
        ArrayList<MetadataRecord> processedRecods = new ArrayList<MetadataRecord>(records.size());
        Iterator iterator = records.iterator();
        while (iterator.hasNext()) {
            ModelRecord modelRecord;
            MetadataRecord record = (MetadataRecord)iterator.next();
            if (record instanceof VdbRecord) {
                MetadataRecord wrappedRecord = this.getWarpedVdbRecord((VdbRecord)record);
                if (wrappedRecord == null) continue;
                processedRecods.add(wrappedRecord);
                continue;
            }
            if (record instanceof FileRecord) {
                FileRecord fileRecord = this.filterFileRecordsByVisibility((FileRecord)record);
                if (fileRecord == null) continue;
                processedRecods.add(fileRecord);
                continue;
            }
            if (record instanceof ModelRecord && (modelRecord = this.getModelRecordWithUpdatedVisibility((ModelRecord)record)) != null) {
                record = modelRecord;
            }
            if (needSearchFiltering) {
                MetadataRecord filteredRecord = this.filterBySearchCriteria(record, searchCriteria);
                if (filteredRecord == null) continue;
                processedRecods.add(filteredRecord);
                continue;
            }
            processedRecods.add(record);
        }
        return processedRecods;
    }

    public MetadataRecord getWarpedVdbRecord(VdbRecord record) {
        if (!record.getName().equalsIgnoreCase("System") || this.vdbName.equalsIgnoreCase("System")) {
            return new RuntimeVdbRecord(record, this.vdbName, this.vdbVersion);
        }
        return null;
    }

    public ModelRecord getModelRecordWithUpdatedVisibility(ModelRecord record) {
        ModelRecordImpl mRecord;
        String modelName;
        if (record instanceof ModelRecordImpl && !MetadataConstants.isSystemModelWithSystemTableType(modelName = (mRecord = (ModelRecordImpl)record).getName())) {
            int visibility = 0;
            if (this.vdbService != null) {
                try {
                    visibility = this.vdbService.getModelVisibility(this.vdbName, this.vdbVersion, modelName);
                }
                catch (MetaMatrixComponentException e2) {
                    throw new MetaMatrixRuntimeException(e2);
                }
            }
            mRecord.setVisible(visibility == 0);
            return mRecord;
        }
        return null;
    }

    private FileRecord filterFileRecordsByVisibility(FileRecord record) {
        int visibility = 0;
        if (this.vdbService != null) {
            try {
                visibility = this.vdbService.getFileVisibility(this.vdbName, this.vdbVersion, record.getPathInVdb());
            }
            catch (MetaMatrixComponentException e2) {
                throw new MetaMatrixRuntimeException(e2);
            }
        }
        if (visibility == 0) {
            return record;
        }
        return null;
    }

    public MetadataRecord filterBySearchCriteria(MetadataRecord record, Map searchCriteria) {
        if (!searchCriteria.isEmpty()) {
            if (!this.applyMetadataRecordCriteria(record, searchCriteria)) {
                return null;
            }
            if (record instanceof DatatypeRecord && !this.applyDatatypeRecordCriteria((DatatypeRecord)record, searchCriteria)) {
                return null;
            }
            if (record instanceof PropertyRecord && !this.applyPropertyRecordCriteria((PropertyRecord)record, searchCriteria)) {
                return null;
            }
        }
        return record;
    }

    private boolean applyDatatypeRecordCriteria(DatatypeRecord record, Map searchCriteria) {
        MetadataSearchCriteria runtypeCriteria = this.getSearchCriteria(searchCriteria, "RuntimeTypeName");
        if (!this.applyCriteria(runtypeCriteria, record.getRuntimeTypeName())) {
            return false;
        }
        MetadataSearchCriteria baseTypeCriteria = this.getSearchCriteria(searchCriteria, "BasetypeID");
        if (!this.applyCriteria(baseTypeCriteria, record.getBasetypeID())) {
            return false;
        }
        MetadataSearchCriteria dataTypeCriteria = this.getSearchCriteria(searchCriteria, "DatatypeID");
        return this.applyCriteria(dataTypeCriteria, record.getDatatypeID());
    }

    private boolean applyPropertyRecordCriteria(PropertyRecord record, Map searchCriteria) {
        MetadataSearchCriteria propNameCriteria = this.getSearchCriteria(searchCriteria, "PropertyName");
        if (!this.applyCriteria(propNameCriteria, record.getPropertyName())) {
            return false;
        }
        MetadataSearchCriteria propValueCriteria = this.getSearchCriteria(searchCriteria, "PropertyValue");
        return this.applyCriteria(propValueCriteria, record.getPropertyValue());
    }

    private boolean applyMetadataRecordCriteria(MetadataRecord record, Map searchCriteria) {
        MetadataSearchCriteria recordTypeCriteria = this.getSearchCriteria(searchCriteria, "Recordtype");
        if (!this.applyCriteria(recordTypeCriteria, new Character(record.getRecordType()))) {
            return false;
        }
        MetadataSearchCriteria fullNameCriteria = this.getSearchCriteria(searchCriteria, "FullName");
        if (!this.applyCriteria(fullNameCriteria, record.getFullName())) {
            return false;
        }
        MetadataSearchCriteria nameCriteria = this.getSearchCriteria(searchCriteria, "Name");
        if (!this.applyCriteria(nameCriteria, record.getName())) {
            return false;
        }
        MetadataSearchCriteria modelNameCriteria = this.getSearchCriteria(searchCriteria, "ModelName");
        if (!this.applyCriteria(modelNameCriteria, record.getModelName())) {
            return false;
        }
        MetadataSearchCriteria nameInSourceCriteria = this.getSearchCriteria(searchCriteria, "NameInSource");
        if (!this.applyCriteria(nameInSourceCriteria, record.getNameInSource())) {
            return false;
        }
        MetadataSearchCriteria uuidCriteria = this.getSearchCriteria(searchCriteria, "UUID");
        if (!this.applyCriteria(uuidCriteria, record.getUUID())) {
            return false;
        }
        MetadataSearchCriteria parentUuidCriteria = this.getSearchCriteria(searchCriteria, "ParentUUID");
        return this.applyCriteria(parentUuidCriteria, record.getParentUUID());
    }

    private MetadataSearchCriteria getSearchCriteria(Map searchCriteria, String key) {
        return (MetadataSearchCriteria)searchCriteria.get(key.toUpperCase());
    }

    private boolean applyCriteria(MetadataSearchCriteria criteria, Object value) {
        boolean criteriaPassed;
        block4: {
            block2: {
                Object evaluatedLiteral;
                block5: {
                    block3: {
                        criteriaPassed = true;
                        if (!(criteria instanceof MetadataLiteralCriteria)) break block2;
                        MetadataLiteralCriteria literalCriteria = (MetadataLiteralCriteria)criteria;
                        evaluatedLiteral = literalCriteria.getEvaluatedValue();
                        if (!(value instanceof String) || !(evaluatedLiteral instanceof String)) break block3;
                        String literalString = evaluatedLiteral.toString();
                        String valueString = value.toString();
                        if (CharOperation.match(literalString.toCharArray(), valueString.toCharArray(), true)) break block4;
                        criteriaPassed = false;
                        break block4;
                    }
                    if (value == null || value.equals(evaluatedLiteral)) break block5;
                    criteriaPassed = false;
                    break block4;
                }
                if (value != null || evaluatedLiteral == null) break block4;
                criteriaPassed = false;
                break block4;
            }
            if (criteria instanceof MetadataInCriteria) {
                MetadataInCriteria inCriteria = (MetadataInCriteria)criteria;
                Collection literalCriteria = inCriteria.getLiteralCriteria();
                Iterator critIter = literalCriteria.iterator();
                while (critIter.hasNext()) {
                    MetadataLiteralCriteria literalCrit = (MetadataLiteralCriteria)critIter.next();
                    if (this.applyCriteria(literalCrit, value)) continue;
                    criteriaPassed = false;
                    break;
                }
            }
        }
        return criteriaPassed;
    }
}

