/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.metadata.adapter;

import com.metamatrix.connector.metadata.MetadataConnectorPlugin;
import com.metamatrix.connector.metadata.adapter.BatchListAssembler;
import com.metamatrix.connector.metadata.adapter.ObjectConnection;
import com.metamatrix.connector.metadata.adapter.ObjectResultsTranslator;
import com.metamatrix.connector.metadata.internal.ObjectQuery;
import com.metamatrix.connector.metadata.internal.ObjectQueryProcessor;
import com.metamatrix.data.api.Batch;
import com.metamatrix.data.api.SynchQueryExecution;
import com.metamatrix.data.basic.BasicBatch;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.IQuery;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;
import java.util.Collections;
import java.util.List;

public class ObjectSynchExecution
implements SynchQueryExecution {
    private final RuntimeMetadata metadata;
    private ObjectQueryProcessor processor;
    private ObjectQuery query;
    private BatchListAssembler queryResults;
    private int maxBatchSize;
    private boolean closed;
    private ObjectConnection connection;
    private ObjectResultsTranslator resultsTranslator;

    public ObjectSynchExecution(RuntimeMetadata metadata, ObjectConnection connection, ObjectResultsTranslator resultsTranslator) {
        this.metadata = metadata;
        this.connection = connection;
        this.resultsTranslator = resultsTranslator;
    }

    private void throwAwayResults() {
        this.queryResults = null;
    }

    public synchronized void execute(IQuery query, int maxBatchSize) throws ConnectorException {
        if (this.closed) {
            throw new ConnectorException(MetadataConnectorPlugin.Util.getString("ObjectSynchExecution.closed"));
        }
        this.processor = new ObjectQueryProcessor(this.connection.getMetadataObjectSource(), this.resultsTranslator);
        this.query = new ObjectQuery(this.metadata, query);
        this.maxBatchSize = maxBatchSize;
        this.queryResults = new BatchListAssembler(this.processor.process(this.query));
    }

    public synchronized Batch nextBatch() throws ConnectorException {
        if (this.closed) {
            throw new ConnectorException(MetadataConnectorPlugin.Util.getString("ObjectSynchExecution.closed"));
        }
        List subList = this.queryResults.next(this.maxBatchSize);
        BasicBatch result = new BasicBatch(Collections.unmodifiableList(subList));
        if (!this.queryResults.hasNext()) {
            result.setLast();
        }
        return result;
    }

    public synchronized void cancel() throws ConnectorException {
        this.closed = true;
        this.throwAwayResults();
    }

    public synchronized void close() throws ConnectorException {
        this.closed = true;
        this.throwAwayResults();
    }
}

