/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.metadata.adapter;

import com.metamatrix.connector.metadata.MetadataProcedureExecution;
import com.metamatrix.connector.metadata.adapter.ObjectConnection;
import com.metamatrix.connector.metadata.adapter.ObjectResultsTranslator;
import com.metamatrix.connector.sysadmin.SysAdminProcedureExecution;
import com.metamatrix.data.api.Batch;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ProcedureExecution;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.IParameter;
import com.metamatrix.data.language.IProcedure;
import com.metamatrix.data.metadata.runtime.MetadataID;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;

public class ObjectProcedureExecution
implements ProcedureExecution {
    private ProcedureExecution redirection = null;
    private ObjectResultsTranslator translator = null;
    private final RuntimeMetadata metadata;
    private ConnectorEnvironment environment;
    private ObjectConnection connection;

    public ObjectProcedureExecution(RuntimeMetadata metadata, ObjectConnection connection, ObjectResultsTranslator resultsTranslator, ConnectorEnvironment environment) {
        this.metadata = metadata;
        this.translator = resultsTranslator;
        this.environment = environment;
        this.connection = connection;
    }

    public void execute(IProcedure procedure, int maxBatchSize) throws ConnectorException {
        this.redirection = this.isAdminModel(procedure) ? new SysAdminProcedureExecution(this.metadata, this.connection.getSysAdminobjectSource(), this.environment) : new MetadataProcedureExecution(this.metadata, this.connection.getMetadataObjectSource(), this.translator);
        this.redirection.execute(procedure, maxBatchSize);
    }

    private boolean isAdminModel(IProcedure procedure) throws ConnectorException {
        MetadataID mID = procedure.getMetadataID();
        String fn = mID.getFullName().toLowerCase();
        return fn.indexOf("systemadmin") >= 0;
    }

    public Object getOutputValue(IParameter parameter) throws ConnectorException {
        return this.redirection.getOutputValue(parameter);
    }

    public void cancel() throws ConnectorException {
        this.redirection.cancel();
    }

    public void close() throws ConnectorException {
        this.redirection.close();
    }

    public Batch nextBatch() throws ConnectorException {
        return this.redirection.nextBatch();
    }
}

