/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.metadata.adapter;

import com.metamatrix.connector.metadata.adapter.ObjectConnector;
import com.metamatrix.connector.metadata.adapter.ObjectConnectorCapabilities;
import com.metamatrix.connector.metadata.adapter.ObjectProcedureExecution;
import com.metamatrix.connector.metadata.adapter.ObjectResultsTranslator;
import com.metamatrix.connector.metadata.adapter.ObjectSynchExecution;
import com.metamatrix.connector.metadata.internal.IObjectSource;
import com.metamatrix.data.api.Connection;
import com.metamatrix.data.api.ConnectorCapabilities;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ConnectorMetadata;
import com.metamatrix.data.api.Execution;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.api.SecurityContext;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;

public class ObjectConnection
implements Connection {
    private ConnectorEnvironment environment;
    private SecurityContext securityContext;
    private ObjectConnector connector;

    public ObjectConnection(ConnectorEnvironment environment, SecurityContext context, ObjectConnector connector) {
        this.securityContext = context;
        this.environment = environment;
        this.connector = connector;
    }

    public Execution createExecution(int executionMode, ExecutionContext executionContext, RuntimeMetadata metadata) {
        ObjectResultsTranslator translator = new ObjectResultsTranslator(this.environment, executionContext);
        switch (executionMode) {
            case 0: {
                return new ObjectSynchExecution(metadata, this, translator);
            }
            case 2: {
                return new ObjectProcedureExecution(metadata, this, translator, this.environment);
            }
        }
        return null;
    }

    protected IObjectSource getMetadataObjectSource() throws ConnectorException {
        return this.connector.getMetadataObjectSource(this.securityContext);
    }

    protected Object getSysAdminobjectSource() throws ConnectorException {
        return this.connector.getSysAdminObjectSource(this.securityContext);
    }

    public ConnectorMetadata getMetadata() {
        return null;
    }

    public void release() {
        this.environment = null;
        this.securityContext = null;
        this.connector = null;
    }

    public ConnectorCapabilities getCapabilities() {
        return ObjectConnectorCapabilities.getInstance();
    }
}

