/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.metadata;

import com.metamatrix.api.exception.MetaMatrixRuntimeException;
import com.metamatrix.connector.metadata.MetadataConnectorPlugin;
import com.metamatrix.connector.metadata.PropertyHolder;
import com.metamatrix.connector.metadata.internal.ISimpleObjectSource;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class PropertyFileObjectSource
implements ISimpleObjectSource {
    private String propertyFilePath;

    public PropertyFileObjectSource(String propertyFilePath) {
        this.propertyFilePath = propertyFilePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getObjects(String propertyFileName, Map criteria) {
        ArrayList<PropertyHolder> arrayList;
        block12: {
            if (criteria != null && criteria.size() > 0) {
                throw new UnsupportedOperationException(MetadataConnectorPlugin.Util.getString("PropertyFileObjectSource.Criteria_not_supported._1"));
            }
            InputStream input = null;
            try {
                input = this.getClass().getClassLoader().getResourceAsStream(this.expandPropertyFileName(propertyFileName));
                if (input == null) {
                    throw new MetaMatrixRuntimeException(this.getErrorMessage(propertyFileName));
                }
                Properties properties = new Properties();
                properties.load(input);
                ArrayList<PropertyHolder> results = new ArrayList<PropertyHolder>();
                Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Object, Object> entry = iterator.next();
                    PropertyHolder holder = new PropertyHolder(new Integer((String)entry.getKey()));
                    holder.setValue(entry.getValue());
                    results.add(holder);
                }
                arrayList = results;
                if (input == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        input.close();
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e2) {
                    throw new MetaMatrixRuntimeException(e2, this.getErrorMessage(propertyFileName));
                }
                catch (IOException e3) {
                    throw new MetaMatrixRuntimeException(e3, this.getErrorMessage(propertyFileName));
                }
            }
            input.close();
        }
        return arrayList;
    }

    private String expandPropertyFileName(String propertyFileName) {
        if (this.propertyFilePath == null) {
            return propertyFileName;
        }
        return this.propertyFilePath + propertyFileName;
    }

    private String getErrorMessage(String propertyFileName) {
        return MetadataConnectorPlugin.Util.getString("PropertyFileObjectSource.Error_loading_property_file___1", this.expandPropertyFileName(propertyFileName));
    }
}

