/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.metadata;

import com.metamatrix.connector.metadata.MetadataConnectorPlugin;
import com.metamatrix.connector.metadata.adapter.BatchListAssembler;
import com.metamatrix.connector.metadata.adapter.ObjectResultsTranslator;
import com.metamatrix.connector.metadata.internal.IObjectSource;
import com.metamatrix.connector.metadata.internal.ObjectProcedure;
import com.metamatrix.connector.metadata.internal.ObjectProcedureProcessor;
import com.metamatrix.data.api.Batch;
import com.metamatrix.data.api.ProcedureExecution;
import com.metamatrix.data.basic.BasicBatch;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.IParameter;
import com.metamatrix.data.language.IProcedure;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;
import java.util.Collections;
import java.util.List;

public class MetadataProcedureExecution
implements ProcedureExecution {
    private final RuntimeMetadata metadata;
    private final ObjectProcedureProcessor processor;
    private int maxBatchSize;
    private ObjectProcedure procedure;
    private BatchListAssembler queryResults;

    public MetadataProcedureExecution(RuntimeMetadata metadata, IObjectSource objectSource, ObjectResultsTranslator resultsTranslator) {
        this.metadata = metadata;
        this.processor = new ObjectProcedureProcessor(objectSource, resultsTranslator);
    }

    public void execute(IProcedure procedure, int maxBatchSize) throws ConnectorException {
        this.procedure = new ObjectProcedure(this.metadata, procedure);
        this.maxBatchSize = maxBatchSize;
        this.processor.process(this.procedure);
        if (this.procedure.getResultSetNameInSource() != null) {
            this.queryResults = new BatchListAssembler(this.processor.getResultSet());
        }
    }

    public Object getOutputValue(IParameter parameter) throws ConnectorException {
        if (parameter.getDirection() != 1 && parameter.getDirection() != 2 && parameter.getDirection() != 3) {
            throw new ConnectorException(MetadataConnectorPlugin.Util.getString("ObjectProcedureExecution.0"));
        }
        return null;
    }

    public void cancel() throws ConnectorException {
        this.throwAwayResults();
    }

    public void close() throws ConnectorException {
        this.throwAwayResults();
    }

    private void throwAwayResults() {
        this.queryResults = null;
    }

    public Batch nextBatch() throws ConnectorException {
        if (this.queryResults != null) {
            List subList = this.queryResults.next(this.maxBatchSize);
            BasicBatch result = new BasicBatch(Collections.unmodifiableList(subList));
            if (!this.queryResults.hasNext()) {
                result.setLast();
            }
            return result;
        }
        return null;
    }
}

