/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.xml.xmi;

import com.metamatrix.api.core.message.DefaultMessage;
import com.metamatrix.api.core.message.MessageList;
import com.metamatrix.api.core.xmi.EntityInfo;
import com.metamatrix.api.core.xmi.FeatureInfo;
import com.metamatrix.api.core.xmi.XMIConstants;
import com.metamatrix.api.core.xmi.XMIHeader;
import com.metamatrix.api.core.xmi.XMIReaderAdapter;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.xml.xmi.XMIHeaderContentHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.EmptyStackException;
import java.util.Stack;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMIContentHandler
extends DefaultHandler {
    public static final String XMI_CONTENT_HANDLER = "XMI Content Handler";
    public static final String XMI_UUID = "xmi.uuid";
    public static final String XMI_ID = "xmi.id";
    public static final String NAME = "name";
    public static final String HREF = "href";
    public static final String XMI_LABEL = "xmi.label";
    public static final String XMI_ID_REF = "xmi.idref";
    public static final String XMI_CONTENT = "XMI.content";
    private HeaderHandler headerHandler;
    private XMIReaderAdapter readerAdapter;
    private ContentHandler currentHandler;
    private int depth = 1;
    private Stack entityInfo;
    private Stack objectInfo;
    private EntityInfo previousEntityInfo;
    private FeatureInfo previousFeatureInfo;
    protected BodyHandler bodyHandler;
    private StringBuffer textBuffer = new StringBuffer(4096);
    private boolean ignoringWhite = true;

    public XMIContentHandler(XMIReaderAdapter adapter) {
        this.readerAdapter = adapter;
        try {
            this.headerHandler = new HeaderHandler();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.bodyHandler = new BodyHandler(adapter);
        this.currentHandler = this.headerHandler;
        this.entityInfo = new Stack();
        this.objectInfo = new Stack();
    }

    public void setXMIHeader(XMIHeader header) {
        this.readerAdapter.setHeader(header);
        this.currentHandler = this.bodyHandler;
    }

    public void characters(char[] characters, int start, int length) throws SAXException {
        LogManager.logTrace(XMI_CONTENT_HANDLER, "Process characters");
        this.currentHandler.characters(characters, start, length);
    }

    public void ignorableWhitespace(char[] characters, int start, int length) throws SAXException {
        LogManager.logTrace(XMI_CONTENT_HANDLER, "ignorableWhitespace");
        if (this.ignoringWhite) {
            return;
        }
        if (length == 0) {
            return;
        }
        this.currentHandler.ignorableWhitespace(characters, start, length);
    }

    public void startDocument() throws SAXException {
        LogManager.logTrace(XMI_CONTENT_HANDLER, "Start document");
    }

    public void endDocument() throws SAXException {
        LogManager.logTrace(XMI_CONTENT_HANDLER, "End document");
        this.currentHandler.endDocument();
    }

    public void endElement(String uri, String name, String qName) throws SAXException {
        if ("".equals(uri)) {
            LogManager.logTrace(XMI_CONTENT_HANDLER, "End element: " + qName);
        } else {
            LogManager.logTrace(XMI_CONTENT_HANDLER, "End element:   {" + uri + "}" + name);
        }
        if (XMI_CONTENT.equals(name)) {
            --this.depth;
            return;
        }
        this.currentHandler.endElement(uri, name, qName);
    }

    public void startElement(String uri, String name, String qName, Attributes atts) throws SAXException {
        if ("".equals(uri)) {
            LogManager.logTrace(XMI_CONTENT_HANDLER, "Start element: " + qName);
        } else {
            LogManager.logTrace(XMI_CONTENT_HANDLER, "Start element: {" + uri + "}" + name);
        }
        if (XMI_CONTENT.equals(name)) {
            ++this.depth;
            return;
        }
        this.currentHandler.startElement(uri, name, qName, atts);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void read(InputStream stream, MessageList messages, XMIReaderAdapter adapter, boolean closeStream) throws SAXException, IOException {
        try {
            try {
                InputSource source = new InputSource(stream);
                SAXParser parser = new SAXParser();
                XMIContentHandler handler = new XMIContentHandler(adapter);
                parser.setContentHandler(handler);
                parser.parse(source);
            }
            catch (SAXException e3) {
                messages.add(new DefaultMessage("Unable to process XMI from the input stream", 3));
                throw e3;
            }
            Object var8_8 = null;
            if (stream == null) return;
            if (!closeStream) return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (stream == null) throw throwable;
            if (!closeStream) throw throwable;
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException e2) {
                messages.add(new DefaultMessage("Failed to close FileInputStream", 3));
                throw e2;
            }
        }
        try {}
        catch (IOException e2) {
            messages.add(new DefaultMessage("Failed to close FileInputStream", 3));
            throw e2;
        }
        stream.close();
    }

    private static String normalizeString(String value) {
        char[] c2 = value.toCharArray();
        char[] n2 = new char[c2.length];
        boolean white = true;
        int pos = 0;
        for (int i2 = 0; i2 < c2.length; ++i2) {
            if (" \t\n\r".indexOf(c2[i2]) != -1) {
                if (white) continue;
                n2[pos++] = 32;
                white = true;
                continue;
            }
            n2[pos++] = c2[i2];
            white = false;
        }
        if (white && pos > 0) {
            --pos;
        }
        return new String(n2, 0, pos);
    }

    protected class BodyHandler
    extends DefaultHandler {
        private XMIReaderAdapter readerAdapter;
        public final String BODY_HANDLER = "BODY Handler";

        public BodyHandler(XMIReaderAdapter adapter) {
            this.readerAdapter = adapter;
        }

        public void characters(char[] characters, int start, int length) {
            if (XMIContentHandler.this.objectInfo.isEmpty()) {
                return;
            }
            XMIContentHandler.this.textBuffer.append(characters, start, length);
        }

        public void ignorableWhitespace(char[] characters, int start, int length) throws SAXException {
            XMIContentHandler.this.textBuffer.append(characters, start, length);
        }

        public void endElement(String uri, String name, String qName) throws SAXException {
            FeatureInfo featureInfo;
            if ("".equals(uri)) {
                LogManager.logTrace("BODY Handler", "End element: " + qName);
            } else {
                LogManager.logTrace("BODY Handler", "End element:   {" + uri + "}" + name);
            }
            if (XMIContentHandler.this.textBuffer.length() != 0) {
                String value = XMIContentHandler.normalizeString(XMIContentHandler.this.textBuffer.toString());
                XMIContentHandler.this.textBuffer.setLength(0);
                if (value.length() != 0) {
                    ObjectInfoWrapper parent = (ObjectInfoWrapper)XMIContentHandler.this.entityInfo.peek();
                    ObjectInfoWrapper featureWrapper = (ObjectInfoWrapper)XMIContentHandler.this.objectInfo.peek();
                    FeatureInfo featureInfo2 = (FeatureInfo)featureWrapper.getResult();
                    featureInfo2.setValue(value);
                    this.readerAdapter.createFeature(featureInfo2, parent.getResult());
                }
            }
            ObjectInfoWrapper result = null;
            try {
                result = (ObjectInfoWrapper)XMIContentHandler.this.objectInfo.pop();
            }
            catch (EmptyStackException e2) {
                // empty catch block
            }
            if (result == null) {
                return;
            }
            if (result.isEntity()) {
                try {
                    XMIContentHandler.this.entityInfo.pop();
                }
                catch (EmptyStackException e3) {
                    // empty catch block
                }
                this.readerAdapter.finishEntity(result.getResult());
                try {
                    ObjectInfoWrapper featureWrapper = (ObjectInfoWrapper)XMIContentHandler.this.objectInfo.peek();
                    if (!featureWrapper.isEntity()) {
                        featureInfo = (FeatureInfo)featureWrapper.getResult();
                        featureInfo.setValue(result.getResult());
                        ObjectInfoWrapper parentWrapper = (ObjectInfoWrapper)XMIContentHandler.this.entityInfo.peek();
                        this.readerAdapter.createFeature(featureInfo, parentWrapper.getResult());
                    }
                }
                catch (EmptyStackException e4) {}
            } else {
                ObjectInfoWrapper parentWrapper = (ObjectInfoWrapper)XMIContentHandler.this.entityInfo.peek();
                featureInfo = (FeatureInfo)result.getResult();
                this.readerAdapter.finishFeature(featureInfo, parentWrapper.getResult());
            }
            XMIContentHandler.this.depth--;
        }

        public void startElement(String uri, String name, String qName, Attributes atts) throws SAXException {
            if ("".equals(uri)) {
                LogManager.logTrace("BODY Handler", "Start element: " + qName);
            } else {
                LogManager.logTrace("BODY Handler", "Start element: {" + uri + "}" + name);
            }
            ObjectInfoWrapper parent = null;
            if (this.isEntity(uri, name, qName, atts)) {
                EntityInfo info = new EntityInfo(XMIContentHandler.this.previousFeatureInfo, name, uri);
                if (!XMIContentHandler.this.entityInfo.isEmpty()) {
                    parent = (ObjectInfoWrapper)XMIContentHandler.this.entityInfo.peek();
                }
                XMIContentHandler.this.previousEntityInfo = info;
                int length = atts.getLength();
                for (int i2 = 0; i2 < length; ++i2) {
                    String localName = atts.getLocalName(i2);
                    String value = atts.getValue(i2);
                    if (XMIContentHandler.NAME.equals(localName)) {
                        info.setName(value);
                        continue;
                    }
                    if (XMIContentHandler.XMI_ID.equals(localName)) {
                        info.setID(value);
                        continue;
                    }
                    if (XMIContentHandler.XMI_UUID.equals(localName)) {
                        info.setUUID(value);
                        continue;
                    }
                    if (XMIContentHandler.HREF.equals(localName)) {
                        info.setHref(value);
                        continue;
                    }
                    if (XMIContentHandler.XMI_LABEL.equals(localName)) {
                        info.setLabel(value);
                        continue;
                    }
                    if (!XMIContentHandler.XMI_ID_REF.equals(localName)) continue;
                    info.setIDRef(value);
                }
                info.setAttributes(atts);
                Object result = null;
                String parentId = null;
                if (parent != null) {
                    parentId = parent.getId();
                    info.setParentId(parentId);
                    result = this.readerAdapter.createEntity(info, parent.getResult());
                } else {
                    result = this.readerAdapter.createEntity(info, null);
                }
                ObjectInfoWrapper wrapper = new ObjectInfoWrapper(result, true, info.getID(), parentId);
                XMIContentHandler.this.objectInfo.push(wrapper);
                XMIContentHandler.this.entityInfo.push(wrapper);
                length = atts.getLength();
                for (int i3 = 0; i3 < length; ++i3) {
                    String localName = atts.getLocalName(i3);
                    if (XMIContentHandler.XMI_ID.equals(localName) || XMIContentHandler.XMI_UUID.equals(localName) || XMIContentHandler.HREF.equals(localName) || XMIContentHandler.XMI_LABEL.equals(localName) || XMIContentHandler.XMI_ID_REF.equals(localName)) continue;
                    String value = atts.getValue(i3);
                    FeatureInfo feature = new FeatureInfo(XMIContentHandler.this.previousEntityInfo, localName, name, uri);
                    feature.setValue(value);
                    this.readerAdapter.createFeature(feature, result);
                    this.readerAdapter.finishFeature(feature, result);
                }
            } else {
                parent = (ObjectInfoWrapper)XMIContentHandler.this.entityInfo.peek();
                FeatureInfo info = null;
                int index = name.indexOf(XMIConstants.DELIMITER_CHAR);
                if (index > 0) {
                    String metaClassName = name.substring(0, index);
                    String featurename = name.substring(index + 1);
                    info = new FeatureInfo(XMIContentHandler.this.previousEntityInfo, featurename, metaClassName, uri);
                } else {
                    info = new FeatureInfo(XMIContentHandler.this.previousEntityInfo, name, name, uri);
                }
                XMIContentHandler.this.previousFeatureInfo = info;
                ObjectInfoWrapper wrapper = new ObjectInfoWrapper(info, false, null, null);
                XMIContentHandler.this.objectInfo.push(wrapper);
            }
            ++XMIContentHandler.this.depth;
        }

        public void endDocument() throws SAXException {
            LogManager.logTrace("BODY Handler", "End document");
            this.readerAdapter.finishDocument();
        }

        protected boolean isEntity(String uri, String name, String qName, Attributes atts) {
            return (XMIContentHandler.this.depth + 2) % 2 == 0;
        }
    }

    private class HeaderHandler
    extends XMIHeaderContentHandler {
        public void complete() {
            XMIContentHandler.this.setXMIHeader(this.getHeader());
        }
    }

    private static class ObjectInfoWrapper {
        private final Object result;
        private final boolean isEntity;
        private final String id;
        private final String parentId;

        public ObjectInfoWrapper(Object result, boolean isEntity, String id, String parentId) {
            this.result = result;
            this.isEntity = isEntity;
            this.id = id;
            this.parentId = parentId;
        }

        public Object getResult() {
            return this.result;
        }

        public boolean isEntity() {
            return this.isEntity;
        }

        public String getId() {
            return this.id;
        }

        public String getParentId() {
            return this.parentId;
        }
    }
}

