/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.util.commandline;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.common.util.commandline.ExecutionTarget;
import com.metamatrix.common.util.commandline.IPropertyValidation;
import java.io.File;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class HeadlessCommandLineTool {
    private IPropertyValidation validator = null;

    HeadlessCommandLineTool() {
    }

    public void run(String propertyFile) throws Exception {
        String targetClzz;
        File f2 = new File(propertyFile);
        if (!f2.exists()) {
            System.out.println(CommonPlugin.Util.getString("ERR.008.040.0006", propertyFile));
        }
        Properties properties = PropertiesUtils.load(propertyFile);
        Properties sysprops = System.getProperties();
        Properties allProps = new Properties();
        allProps.putAll((Map<?, ?>)sysprops);
        allProps.putAll((Map<?, ?>)properties);
        String bootstrapFileName = sysprops.getProperty("metamatrix.config.readerFile");
        if (bootstrapFileName != null) {
            Properties bootstrapProps = PropertiesUtils.load(bootstrapFileName);
            allProps.put("metamatrix.security.password.PasswordKeyStore", bootstrapProps.get("metamatrix.security.password.PasswordKeyStore"));
        }
        if ((targetClzz = properties.getProperty("TargetClass")) == null) {
            targetClzz = System.getProperty("TargetClass");
        }
        if (targetClzz == null) {
            throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.030.0039", "TargetClass"));
        }
        String validatorClzz = properties.getProperty("ValidationClass");
        if (validatorClzz != null && validatorClzz.length() > 0) {
            this.validator = this.createValidation(validatorClzz);
            Iterator<Map.Entry<Object, Object>> itp = allProps.entrySet().iterator();
            while (itp.hasNext()) {
                Map.Entry<Object, Object> entry = itp.next();
                this.validator.isPropertyValid((String)entry.getKey(), (String)entry.getValue());
            }
        }
        ExecutionTarget tool = this.createTargetInstance(targetClzz);
        tool.run(allProps);
        System.exit(0);
    }

    protected final ExecutionTarget createTargetInstance(String targetClzz) throws Exception {
        ExecutionTarget sr = null;
        sr = (ExecutionTarget)Class.forName(targetClzz).newInstance();
        return sr;
    }

    protected final IPropertyValidation createValidation(String clzz) throws Exception {
        IPropertyValidation sr = null;
        sr = (IPropertyValidation)Class.forName(clzz).newInstance();
        return sr;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Invalid usage of Headless Command Line System.\ntypical usage: HeadlessCommandLineTool <propertyFileName>");
            System.exit(0);
        }
        HeadlessCommandLineTool ui = new HeadlessCommandLineTool();
        try {
            ui.run(args[0]);
        }
        catch (Exception err) {
            err.printStackTrace();
            System.exit(-1);
        }
    }
}

