/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.util;

import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.util.ByteArrayHelper;
import com.metamatrix.common.util.DateUtil;
import com.metamatrix.common.util.VMNaming;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public final class ApplicationInfo
implements Serializable {
    public static final String APPLICATION_PRODUCT_INFORMATION = "Product Information";
    public static final String APPLICATION_RELEASE_NUMBER_PROPERTY = "Release-Number";
    public static final String APPLICATION_BUILD_NUMBER_PROPERTY = "Build";
    private static final ApplicationInfo INSTANCE = new ApplicationInfo();
    private static final String LINE_SEPARATOR = "\n";
    private static final String METAMATRIX_JAR = "metamatrix.jar.location";
    private static final String LIBRARY = "Library";
    private static final String APPLICATION_TITLE_PROPERTY = "Title";
    private static final String APPLICATION_DESCRIPTION_PROPERTY = "Description";
    private static final String APPLICATION_RELEASE_DATE_PROPERTY = "Release-Date";
    private static final String APPLICATION_BUILD_DATE_PROPERTY = "Build-Date";
    private static final String APPLICATION_COPYRIGHT_PROPERTY = "Copyright";
    private static final String APPLICATION_LICENSE_ID_PROPERTY = "License-ID";
    private static final String APPLICATION_LICENSE_VERSION_PROPERTY = "License-version";
    private static final String APPLICATION_ABOUT_TITLE_PROPERTY = "About-Title";
    private static final String APPLICATION_ABOUT_ICON_PROPERTY = "About-Icon";
    private static final String APPLICATION_ABOUT_DESCRIPTION_PROPERTY = "About-Description";
    private static final String APPLICATION_ABOUT_URL_PROPERTY = "About-URL";
    private static final String PATCH = "Patch";
    private static final String PATCH_VERSION = "Patch-Version";
    private static final String PATCH_DATE = "Patch-Date";
    private String originatingVM;
    private String originatingHostname;
    private LinkedList components = new LinkedList();
    private boolean unmodifiable = false;

    private ApplicationInfo() {
        this.originatingVM = VMNaming.getVMName();
        if (this.originatingVM == null) {
            this.originatingVM = "VM ID " + VMNaming.getVMID();
        }
        try {
            this.originatingHostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e2) {
            this.originatingHostname = "localhost";
        }
    }

    public static ApplicationInfo getInstance() {
        return INSTANCE;
    }

    public synchronized void addComponent(String parentPackage) throws ComponentNotFoundException {
        if (this.isUnmodifiable()) {
            throw new IllegalStateException(CommonPlugin.Util.getString("ERR.003.030.0001"));
        }
        if (this.containsComponent(parentPackage)) {
            return;
        }
        this.components.add(this.createComponent(parentPackage));
    }

    private Component createComponent(String parentPackage) throws ComponentNotFoundException {
        Component c2 = new Component(parentPackage);
        try {
            StringTokenizer tokenClasspath = ApplicationInfo.setupClassPath();
            JarFile jarFile = ApplicationInfo.findManifestInClasspath(tokenClasspath, LIBRARY, parentPackage);
            if (jarFile == null) {
                throw new IOException(CommonPlugin.Util.getString("ERR.003.030.0002"));
            }
            Attributes manifestAttributes = jarFile.getManifest().getAttributes(APPLICATION_PRODUCT_INFORMATION);
            c2.setTitle((String)manifestAttributes.get(new Attributes.Name(APPLICATION_TITLE_PROPERTY)));
            c2.setDescription((String)manifestAttributes.get(new Attributes.Name(APPLICATION_DESCRIPTION_PROPERTY)));
            c2.setReleaseNumber((String)manifestAttributes.get(new Attributes.Name(APPLICATION_RELEASE_NUMBER_PROPERTY)));
            c2.setReleaseDate((String)manifestAttributes.get(new Attributes.Name(APPLICATION_RELEASE_DATE_PROPERTY)));
            c2.setBuildNumber((String)manifestAttributes.get(new Attributes.Name(APPLICATION_BUILD_NUMBER_PROPERTY)));
            c2.setBuildDate((String)manifestAttributes.get(new Attributes.Name(APPLICATION_BUILD_DATE_PROPERTY)));
            c2.setCopyright((String)manifestAttributes.get(new Attributes.Name(APPLICATION_COPYRIGHT_PROPERTY)));
            c2.setLicenseID((String)manifestAttributes.get(new Attributes.Name(APPLICATION_LICENSE_ID_PROPERTY)));
            c2.setLicenseVersion((String)manifestAttributes.get(new Attributes.Name(APPLICATION_LICENSE_VERSION_PROPERTY)));
            c2.setAboutTitle((String)manifestAttributes.get(new Attributes.Name(APPLICATION_ABOUT_TITLE_PROPERTY)));
            c2.setAboutIcon((String)manifestAttributes.get(new Attributes.Name(APPLICATION_ABOUT_ICON_PROPERTY)));
            c2.setAboutDescription((String)manifestAttributes.get(new Attributes.Name(APPLICATION_ABOUT_DESCRIPTION_PROPERTY)));
            c2.setAboutURL((String)manifestAttributes.get(new Attributes.Name(APPLICATION_ABOUT_URL_PROPERTY)));
            JarFile patchJarFile = ApplicationInfo.findManifestInClasspath(tokenClasspath, LIBRARY, PATCH);
            if (patchJarFile != null) {
                c2.setPatchDate((String)manifestAttributes.get(new Attributes.Name(PATCH_DATE)));
                c2.setPatchLevel((String)manifestAttributes.get(new Attributes.Name(PATCH_VERSION)));
            }
        }
        catch (IOException io) {
            try {
                LogManager.logWarning("CONFIG", CommonPlugin.Util.getString("ERR.003.030.0004", METAMATRIX_JAR));
            }
            catch (NoClassDefFoundError err) {
                // empty catch block
            }
            throw new ComponentNotFoundException("ERR.003.030.0003", CommonPlugin.Util.getString("ERR.003.030.0003", parentPackage));
        }
        return c2;
    }

    private static String getClassPath() {
        return System.getProperty("java.class.path");
    }

    private static StringTokenizer setupClassPath() {
        String classPath = ApplicationInfo.getClassPath();
        String separator = System.getProperty("path.separator");
        String jarFile = System.getProperty(METAMATRIX_JAR);
        if (jarFile != null && jarFile.length() > 0) {
            classPath = classPath + separator + jarFile;
        }
        return new StringTokenizer(classPath, separator);
    }

    private static JarFile findManifestInClasspath(StringTokenizer path, String attributeToFind, String attributeMatch) {
        JarFile file = null;
        while (path.hasMoreTokens()) {
            String pathElement = path.nextToken();
            File pathFile = new File(pathElement);
            if (pathFile.isDirectory() || pathElement.indexOf(".jar") <= 0 && pathElement.indexOf(".zip") <= 0) continue;
            try {
                String vendor;
                Attributes manifestAttributes;
                file = new JarFile(pathElement);
                Manifest manifest = file.getManifest();
                if (manifest == null || (manifestAttributes = manifest.getAttributes(APPLICATION_PRODUCT_INFORMATION)) == null || (vendor = (String)manifestAttributes.get(new Attributes.Name(attributeToFind))) == null || !vendor.equals(attributeMatch)) continue;
                return file;
            }
            catch (IOException io) {
            }
        }
        return null;
    }

    private boolean containsComponent(String packageName) {
        Iterator iter = this.components.iterator();
        while (iter.hasNext()) {
            Component comp = (Component)iter.next();
            if (!comp.getComponentPackage().equals(packageName)) continue;
            return true;
        }
        return false;
    }

    public synchronized List getComponents() {
        return Collections.unmodifiableList(this.components);
    }

    public boolean isUnmodifiable() {
        return this.unmodifiable;
    }

    public void markUnmodifiable() {
        if (this.unmodifiable) {
            return;
        }
        this.unmodifiable = true;
        if (ApplicationInfo.getInstance() == this) {
            Iterator iter = this.getComponents().iterator();
            while (iter.hasNext()) {
                Component comp = (Component)iter.next();
                try {
                    LogManager.logInfo("CONFIG", CommonPlugin.Util.getString("MSG.003.030.0001", new Object[]{comp.getTitle(), comp.getReleaseNumber(), comp.getBuildNumber()}));
                }
                catch (NoClassDefFoundError noClassDefFoundError) {}
            }
        }
    }

    public synchronized String toString() {
        StringBuffer sb = new StringBuffer("Application Information");
        sb.append(LINE_SEPARATOR);
        sb.append(" VM Name:               " + this.originatingVM);
        sb.append(LINE_SEPARATOR);
        sb.append(" Hostname:              " + this.originatingHostname);
        sb.append(LINE_SEPARATOR);
        Iterator iter = this.components.iterator();
        if (iter.hasNext()) {
            sb.append("Main Component:");
            sb.append(LINE_SEPARATOR);
            sb.append(iter.next().toString());
        }
        while (iter.hasNext()) {
            sb.append(LINE_SEPARATOR);
            sb.append("Dependency Component:");
            sb.append(LINE_SEPARATOR);
            sb.append(iter.next().toString());
        }
        return sb.toString();
    }

    public String getVMName() {
        return this.originatingVM;
    }

    public String getHostname() {
        return this.originatingHostname;
    }

    public Component getMainComponent() {
        if (this.components.size() > 0) {
            return (Component)this.components.getFirst();
        }
        return null;
    }

    public void setMainComponent(String componentPackage) throws ComponentNotFoundException {
        if (this.isUnmodifiable()) {
            throw new IllegalStateException(CommonPlugin.Util.getString("ERR.003.030.0001"));
        }
        Component mainComponent = this.createComponent(componentPackage);
        if (this.components.contains(mainComponent)) {
            if (this.getMainComponent() != null && this.getMainComponent().equals(mainComponent)) {
                return;
            }
            this.components.remove(mainComponent);
            this.components.addFirst(mainComponent);
        } else {
            this.components.addFirst(this.createComponent(componentPackage));
        }
    }

    public synchronized String getClasspathInfo() {
        String classPath = ApplicationInfo.getClassPath();
        StringBuffer sb = new StringBuffer();
        sb.append("\nDate: " + DateUtil.getCurrentDateAsString());
        sb.append(LINE_SEPARATOR);
        HashMap<String, Boolean> pathResults = new HashMap<String, Boolean>();
        ArrayList<String> reversetList = new ArrayList<String>();
        StringTokenizer path = ApplicationInfo.setupClassPath();
        while (path.hasMoreTokens()) {
            String pathElement = path.nextToken();
            File pathFile = new File(pathElement);
            if (pathFile.exists()) {
                pathResults.put(pathElement, Boolean.TRUE);
            } else {
                pathResults.put(pathElement, Boolean.FALSE);
            }
            reversetList.add(pathElement);
        }
        sb.append("Classpath Information");
        sb.append(LINE_SEPARATOR);
        sb.append("CLASSPATH: ");
        sb.append(classPath);
        sb.append(LINE_SEPARATOR);
        sb.append(LINE_SEPARATOR);
        Iterator iter = reversetList.iterator();
        sb.append("---- Classpath Entries ----");
        sb.append(LINE_SEPARATOR);
        while (iter.hasNext()) {
            String epath = (String)iter.next();
            Boolean doesExist = (Boolean)pathResults.get(epath);
            sb.append(epath);
            if (!doesExist.booleanValue()) {
                sb.append(" (MISSING)");
            }
            sb.append(LINE_SEPARATOR);
        }
        sb.append(LINE_SEPARATOR);
        sb.append("Note the (MISSING) at the end to designate that the classpath entry is missing");
        try {
            Enumeration<URL> readmes = ClassLoader.getSystemResources("patch_readme.txt");
            sb.append(LINE_SEPARATOR);
            sb.append(LINE_SEPARATOR);
            sb.append("---- Patch Readme Entries----");
            sb.append(LINE_SEPARATOR);
            int cnt = 0;
            if (readmes != null) {
                while (readmes.hasMoreElements()) {
                    ++cnt;
                    URL url = readmes.nextElement();
                    sb.append("Patch " + url.getFile() + ":");
                    sb.append(LINE_SEPARATOR);
                    InputStream is = url.openStream();
                    byte[] data = ByteArrayHelper.toByteArray(is);
                    sb.append(new String(data));
                    sb.append("-------------------------------------");
                    sb.append(LINE_SEPARATOR);
                    is.close();
                }
            }
            if (cnt == 0) {
                sb.append("no Patch Readme Entries found");
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return sb.toString();
    }

    public final class Component
    implements Serializable {
        private String packageName;
        private String title;
        private String desc;
        private String releaseNumber;
        private String releaseDate;
        private String buildNumber;
        private String buildDate;
        private String copyright;
        private String licenseID;
        private String licenseVersion;
        private String aboutTitle;
        private String aboutIcon;
        private String aboutDesc;
        private String aboutURL;
        private String patchLevel;
        private String patchDate;

        private Component(String componentPackage) {
            this.packageName = componentPackage;
        }

        public String getComponentPackage() {
            return this.packageName;
        }

        public String getTitle() {
            return this.title;
        }

        public String getDescription() {
            return this.desc;
        }

        public String getReleaseNumber() {
            return this.releaseNumber;
        }

        public String getReleaseDate() {
            return this.releaseDate;
        }

        public String getBuildNumber() {
            return this.buildNumber;
        }

        public String getBuildDate() {
            return this.buildDate;
        }

        public String getCopyright() {
            return this.copyright;
        }

        public String getLicenseID() {
            return this.licenseID;
        }

        public String getLicenseVersion() {
            return this.licenseVersion;
        }

        public String getAboutTitle() {
            return this.aboutTitle;
        }

        public String getAboutIcon() {
            return this.aboutIcon;
        }

        public String getAboutDescription() {
            return this.aboutDesc;
        }

        public String getAboutURL() {
            return this.aboutURL;
        }

        public String getPatchLevel() {
            return this.patchLevel;
        }

        public String getPatchDate() {
            return this.patchDate;
        }

        void setPatchLevel(String value) {
            if (value == null) {
                value = "";
            }
            this.patchLevel = value;
        }

        void setPatchDate(String value) {
            if (value == null) {
                value = "";
            }
            this.patchDate = value;
        }

        void setTitle(String value) {
            if (value == null) {
                value = "";
            }
            this.title = value;
        }

        void setDescription(String value) {
            if (value == null) {
                value = "";
            }
            this.desc = value;
        }

        void setReleaseNumber(String value) {
            if (value == null) {
                value = "";
            }
            this.releaseNumber = value;
        }

        void setReleaseDate(String value) {
            if (value == null) {
                value = "";
            }
            this.releaseDate = value;
        }

        void setBuildNumber(String value) {
            if (value == null) {
                value = "";
            }
            this.buildNumber = value;
        }

        void setBuildDate(String value) {
            if (value == null) {
                value = "";
            }
            this.buildDate = value;
        }

        void setCopyright(String value) {
            if (value == null) {
                value = "";
            }
            this.copyright = value;
        }

        void setLicenseID(String value) {
            if (value == null) {
                value = "";
            }
            this.licenseID = value;
        }

        void setLicenseVersion(String value) {
            if (value == null) {
                value = "";
            }
            this.licenseVersion = value;
        }

        void setAboutTitle(String value) {
            if (value == null) {
                value = "";
            }
            this.aboutTitle = value;
        }

        void setAboutIcon(String value) {
            if (value == null) {
                value = "";
            }
            this.aboutIcon = value;
        }

        void setAboutDescription(String value) {
            if (value == null) {
                value = "";
            }
            this.aboutDesc = value;
        }

        void setAboutURL(String value) {
            if (value == null) {
                value = "www.metamatrix.com";
            }
            this.aboutURL = value;
        }

        public boolean equals(Object obj) {
            Component component;
            if (obj == this) {
                return true;
            }
            return obj instanceof Component && (component = (Component)obj) != null && component.getComponentPackage().equals(this.getComponentPackage());
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(" Component Package:     ");
            sb.append(this.packageName);
            sb.append(ApplicationInfo.LINE_SEPARATOR);
            sb.append("   Title:               ");
            sb.append(this.title);
            sb.append(ApplicationInfo.LINE_SEPARATOR);
            sb.append("   Description:         ");
            sb.append(ApplicationInfo.LINE_SEPARATOR);
            sb.append(this.desc);
            sb.append("   Release Number:      ");
            sb.append(this.releaseNumber);
            sb.append(ApplicationInfo.LINE_SEPARATOR);
            sb.append("   Release Date:        ");
            sb.append(this.releaseDate);
            sb.append(ApplicationInfo.LINE_SEPARATOR);
            sb.append("   Build Number:        ");
            sb.append(this.buildNumber);
            sb.append(ApplicationInfo.LINE_SEPARATOR);
            sb.append("   Build Date:          ");
            sb.append(this.buildDate);
            sb.append(ApplicationInfo.LINE_SEPARATOR);
            sb.append("   Copyright:           ");
            sb.append(this.copyright);
            sb.append(ApplicationInfo.LINE_SEPARATOR);
            sb.append("   License ID:          ");
            sb.append(this.licenseID);
            sb.append(ApplicationInfo.LINE_SEPARATOR);
            sb.append("   License Version:     ");
            sb.append(this.licenseVersion);
            sb.append(ApplicationInfo.LINE_SEPARATOR);
            sb.append("   About Title:         ");
            sb.append(this.aboutTitle);
            sb.append(ApplicationInfo.LINE_SEPARATOR);
            sb.append("   About Icon:          ");
            sb.append(this.aboutIcon);
            sb.append(ApplicationInfo.LINE_SEPARATOR);
            sb.append("   About Description:   ");
            sb.append(this.aboutDesc);
            sb.append(ApplicationInfo.LINE_SEPARATOR);
            sb.append("   About URL:           ");
            sb.append(this.aboutURL);
            return sb.toString();
        }
    }
}

