/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.tree.util;

import com.metamatrix.api.core.message.ProgressMonitor;
import com.metamatrix.common.object.ObjectDefinition;
import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.common.tree.TreeView;
import com.metamatrix.common.tree.util.TreeNodeVisitor;
import com.metamatrix.common.util.I18nArgCheck;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TreeViewUtil {
    public static void visit(Iterator iter, TreeNodeVisitor visitor) {
        I18nArgCheck.isNotNull(iter, "ERR.003.028.0061");
        I18nArgCheck.isNotNull(visitor, "ERR.003.028.0062");
        while (iter.hasNext()) {
            TreeNode node = (TreeNode)iter.next();
            visitor.visit(node);
        }
    }

    public static void visit(Iterator iter, TreeNodeVisitor visitor, ProgressMonitor monitor) {
        I18nArgCheck.isNotNull(iter, "ERR.003.028.0061");
        I18nArgCheck.isNotNull(visitor, "ERR.003.028.0062");
        I18nArgCheck.isNotNull(monitor, "ERR.003.028.0063");
        while (iter.hasNext()) {
            TreeNode node = (TreeNode)iter.next();
            visitor.visit(node);
            if (!monitor.isCancelled()) continue;
            break;
        }
    }

    public static List getTreeNodesByType(TreeView tree, TreeNode root, ObjectDefinition type, boolean recursive) {
        I18nArgCheck.isNotNull(root, "ERR.003.028.0001");
        ArrayList contents = new ArrayList();
        TreeViewUtil.addObjectsToList(tree, root, type, recursive, contents);
        return contents;
    }

    private static void addObjectsToList(TreeView tree, TreeNode parent, ObjectDefinition type, boolean recursive, List contents) {
        I18nArgCheck.isNotNull(tree, "ERR.003.028.0002");
        I18nArgCheck.isNotNull(parent, "ERR.003.028.0001");
        I18nArgCheck.isNotNull(contents, "ERR.003.028.0011");
        List children = tree.getChildren(parent);
        int len = children.size();
        for (int i2 = 0; i2 < len; ++i2) {
            TreeNode child = (TreeNode)children.get(i2);
            if (type == null || ((Object)child.getType()).equals(type)) {
                contents.add(child);
            }
            if (!recursive) continue;
            TreeViewUtil.addObjectsToList(tree, child, type, recursive, contents);
        }
    }
}

