/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.tree.directory;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.object.ObjectDefinition;
import com.metamatrix.common.tree.directory.DirectoryEntry;
import com.metamatrix.core.util.Assertion;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;

public class PreviewableDirectoryEntry
implements DirectoryEntry {
    protected static final int BUFFER_SIZE = 1024;
    private static final String TEMP_FILE_PREFIX = "prevDirEntTemp";
    private static final String TEMP_FILE_SUFFIX = "tmp";
    private DirectoryEntry entry;
    private File tempFile;

    public PreviewableDirectoryEntry(DirectoryEntry actualEntry) {
        Assertion.isNotNull(actualEntry, "The DirectoryEntry reference may not be null.");
        this.entry = actualEntry;
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.canWrite()) {
            throw new IOException(CommonPlugin.Util.getString("ERR.003.028.0057"));
        }
        this.tempFile = File.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX);
        return new FileOutputStream(this.tempFile);
    }

    public boolean savePreview() throws IOException {
        boolean success = false;
        if (this.tempFile != null) {
            OutputStream fileOstream = this.entry.getOutputStream();
            OutputStreamWriter entryWriter = new OutputStreamWriter(fileOstream);
            success = this.writePreview(entryWriter, true);
        }
        return success;
    }

    public boolean writePreview(Writer writer, boolean closeWriterUponCompletion) throws IOException {
        boolean success = false;
        if (this.tempFile != null) {
            FileReader contentsReader = new FileReader(this.tempFile);
            char[] buffer = new char[1024];
            int n2 = 0;
            while ((n2 = contentsReader.read(buffer)) > -1) {
                writer.write(buffer, 0, n2);
            }
            contentsReader.close();
            if (closeWriterUponCompletion) {
                writer.close();
            }
            success = true;
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPreview() throws IOException {
        if (this.tempFile != null) {
            try {
                this.tempFile.delete();
            }
            finally {
                this.tempFile = null;
            }
        }
    }

    public boolean hasPreview() {
        return this.tempFile != null;
    }

    public DirectoryEntry getTargetDirectoryEntry() {
        return this.entry;
    }

    public boolean canRead() {
        return this.tempFile != null;
    }

    public InputStream getInputStream() throws IOException {
        if (this.tempFile != null) {
            return new FileInputStream(this.tempFile);
        }
        return this.entry.getInputStream();
    }

    public boolean canWrite() {
        return this.entry.canWrite();
    }

    public boolean loadPreview() {
        return this.entry.loadPreview();
    }

    public URL toURL() throws MalformedURLException {
        return this.entry.toURL();
    }

    public boolean exists() {
        return this.entry.exists();
    }

    public String getName() {
        return this.entry.getName();
    }

    public String getFullName() {
        return this.entry.getFullName();
    }

    public String getNamespace() {
        return this.entry.getNamespace();
    }

    public ObjectDefinition getType() {
        return this.entry.getType();
    }

    public char getSeparatorChar() {
        return this.entry.getSeparatorChar();
    }

    public String getSeparator() {
        return this.entry.getSeparator();
    }

    public boolean isModified() {
        return this.entry.isModified();
    }

    public int compareTo(Object o2) {
        if (o2 == null) {
            return 1;
        }
        PreviewableDirectoryEntry that = (PreviewableDirectoryEntry)o2;
        if (that == this) {
            return 0;
        }
        return this.hashCode() - that.hashCode();
    }

    public boolean equals(Object o2) {
        if (o2 instanceof PreviewableDirectoryEntry) {
            return o2 == this || o2.hashCode() == this.hashCode();
        }
        return false;
    }
}

